/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin.header;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.jet.lang.resolve.kotlin.header.ReadDataFromAnnotationVisitor;

public abstract class KotlinClassFileHeader {
    private final int version;

    @Nullable
    public static KotlinClassFileHeader readKotlinHeaderFromClassFile(@NotNull KotlinJvmBinaryClass kotlinClass) {
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/header/KotlinClassFileHeader", "readKotlinHeaderFromClassFile"));
        }
        ReadDataFromAnnotationVisitor visitor = new ReadDataFromAnnotationVisitor();
        kotlinClass.loadClassAnnotations(visitor);
        return visitor.createHeader(kotlinClass);
    }

    protected KotlinClassFileHeader(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }
}

