/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.declarations;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamespaceHeader;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.resolve.lazy.data.JetClassLikeInfo;
import org.jetbrains.jet.lang.resolve.lazy.declarations.ClassMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.declarations.DeclarationProviderFactory;
import org.jetbrains.jet.lang.resolve.lazy.declarations.EmptyPackageMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.declarations.FileBasedPackageMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.declarations.PsiBasedClassMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.storage.MemoizedFunctionToNullable;
import org.jetbrains.jet.lang.resolve.lazy.storage.NotNullLazyValue;
import org.jetbrains.jet.lang.resolve.lazy.storage.StorageManager;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.util.QualifiedNamesUtil;

public class FileBasedDeclarationProviderFactory
implements DeclarationProviderFactory {
    private final Predicate<FqName> isPackageDeclaredExternally;
    private final StorageManager storageManager;
    private final NotNullLazyValue<Index> index;
    private final MemoizedFunctionToNullable<FqName, PackageMemberDeclarationProvider> packageDeclarationProviders;

    public FileBasedDeclarationProviderFactory(@NotNull StorageManager storageManager, @NotNull Collection<JetFile> files) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "<init>"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "<init>"));
        }
        this(storageManager, files, Predicates.alwaysFalse());
    }

    public FileBasedDeclarationProviderFactory(@NotNull StorageManager storageManager, final @NotNull Collection<JetFile> files, @NotNull Predicate<FqName> isPackageDeclaredExternally) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "<init>"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "<init>"));
        }
        if (isPackageDeclaredExternally == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "<init>"));
        }
        this.storageManager = storageManager;
        this.isPackageDeclaredExternally = isPackageDeclaredExternally;
        this.index = storageManager.createLazyValue(new Computable<Index>(){

            @Override
            public Index compute() {
                return FileBasedDeclarationProviderFactory.computeFilesByPackage(files);
            }
        });
        this.packageDeclarationProviders = storageManager.createMemoizedFunctionWithNullableValues(new Function<FqName, PackageMemberDeclarationProvider>(){

            @Override
            public PackageMemberDeclarationProvider fun(FqName fqName) {
                return FileBasedDeclarationProviderFactory.this.createPackageMemberDeclarationProvider(fqName);
            }
        }, StorageManager.ReferenceKind.STRONG);
    }

    @NotNull
    private static Index computeFilesByPackage(@NotNull Collection<JetFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "computeFilesByPackage"));
        }
        Index index = new Index();
        for (JetFile file : files) {
            JetNamespaceHeader header = file.getNamespaceHeader();
            if (header == null) {
                throw new IllegalArgumentException("Scripts are not supported");
            }
            FqName packageFqName = new FqName(header.getQualifiedName());
            FileBasedDeclarationProviderFactory.addMeAndParentPackages(index, packageFqName);
            index.filesByPackage.put(packageFqName, file);
        }
        Index index2 = index;
        if (index2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "computeFilesByPackage"));
        }
        return index2;
    }

    private static void addMeAndParentPackages(@NotNull Index index, @NotNull FqName name) {
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "addMeAndParentPackages"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "addMeAndParentPackages"));
        }
        index.declaredPackages.add(name);
        if (!name.isRoot()) {
            FileBasedDeclarationProviderFactory.addMeAndParentPackages(index, name.parent());
        }
    }

    boolean isPackageDeclaredExplicitly(@NotNull FqName packageFqName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "isPackageDeclaredExplicitly"));
        }
        return this.index.compute().declaredPackages.contains(packageFqName);
    }

    boolean isPackageDeclared(@NotNull FqName packageFqName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "isPackageDeclared"));
        }
        return this.isPackageDeclaredExplicitly(packageFqName) || this.isPackageDeclaredExternally.apply(packageFqName);
    }

    Collection<FqName> getAllDeclaredSubPackagesOf(final @NotNull FqName parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "getAllDeclaredSubPackagesOf"));
        }
        return Collections2.filter(this.index.compute().declaredPackages, new Predicate<FqName>(){

            @Override
            public boolean apply(FqName fqName) {
                return !fqName.isRoot() && fqName.parent().equals(parent);
            }
        });
    }

    Collection<NavigatablePsiElement> getPackageDeclarations(final @NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "getPackageDeclarations"));
        }
        if (fqName.isRoot()) {
            return Collections.emptyList();
        }
        ArrayList<NavigatablePsiElement> resultElements = Lists.newArrayList();
        for (FqName declaredPackage : this.index.compute().filesByPackage.keys()) {
            if (!QualifiedNamesUtil.isSubpackageOf(declaredPackage, fqName)) continue;
            Collection files = this.index.compute().filesByPackage.get(declaredPackage);
            resultElements.addAll(ContainerUtil.map(files, new Function<JetFile, NavigatablePsiElement>(){

                @Override
                public NavigatablePsiElement fun(JetFile file) {
                    return JetPsiUtil.getPackageReference(file, QualifiedNamesUtil.numberOfSegments(fqName) - 1);
                }
            }));
        }
        return resultElements;
    }

    @Override
    public PackageMemberDeclarationProvider getPackageMemberDeclarationProvider(@NotNull FqName packageFqName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "getPackageMemberDeclarationProvider"));
        }
        return this.packageDeclarationProviders.fun(packageFqName);
    }

    @Nullable
    public PackageMemberDeclarationProvider createPackageMemberDeclarationProvider(@NotNull FqName packageFqName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "createPackageMemberDeclarationProvider"));
        }
        if (!this.isPackageDeclaredExplicitly(packageFqName)) {
            if (this.isPackageDeclaredExternally.apply(packageFqName)) {
                return EmptyPackageMemberDeclarationProvider.INSTANCE;
            }
            return null;
        }
        return new FileBasedPackageMemberDeclarationProvider(this.storageManager, packageFqName, this, this.index.compute().filesByPackage.get(packageFqName));
    }

    @Override
    @NotNull
    public ClassMemberDeclarationProvider getClassMemberDeclarationProvider(@NotNull JetClassLikeInfo classLikeInfo) {
        if (classLikeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "getClassMemberDeclarationProvider"));
        }
        if (!this.index.compute().filesByPackage.containsKey(classLikeInfo.getContainingPackageFqName())) {
            throw new IllegalStateException("This factory doesn't know about this class: " + classLikeInfo);
        }
        PsiBasedClassMemberDeclarationProvider psiBasedClassMemberDeclarationProvider = new PsiBasedClassMemberDeclarationProvider(this.storageManager, classLikeInfo);
        if (psiBasedClassMemberDeclarationProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "getClassMemberDeclarationProvider"));
        }
        return psiBasedClassMemberDeclarationProvider;
    }

    private static class Index {
        private final Multimap<FqName, JetFile> filesByPackage = HashMultimap.create();
        private final Set<FqName> declaredPackages = Sets.newHashSet();

        private Index() {
        }
    }
}

