/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.storage;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.Diagnostics;
import org.jetbrains.jet.lang.resolve.lazy.storage.LazyResolveStorageManager;
import org.jetbrains.jet.lang.resolve.lazy.storage.LockBasedStorageManager;
import org.jetbrains.jet.util.slicedmap.ReadOnlySlice;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public class LockBasedLazyResolveStorageManager
extends LockBasedStorageManager
implements LazyResolveStorageManager {
    @Override
    @NotNull
    public BindingTrace createSafeTrace(@NotNull BindingTrace originalTrace) {
        if (originalTrace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedLazyResolveStorageManager", "createSafeTrace"));
        }
        LockProtectedTrace lockProtectedTrace = new LockProtectedTrace(this.lock, originalTrace);
        if (lockProtectedTrace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedLazyResolveStorageManager", "createSafeTrace"));
        }
        return lockProtectedTrace;
    }

    private static class LockProtectedTrace
    implements BindingTrace {
        private final Object lock;
        private final BindingTrace trace;
        private final BindingContext context;

        public LockProtectedTrace(@NotNull Object lock, @NotNull BindingTrace trace) {
            if (lock == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedLazyResolveStorageManager$LockProtectedTrace", "<init>"));
            }
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedLazyResolveStorageManager$LockProtectedTrace", "<init>"));
            }
            this.lock = lock;
            this.trace = trace;
            this.context = new LockProtectedContext(lock, trace.getBindingContext());
        }

        @Override
        public BindingContext getBindingContext() {
            return this.context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <K, V> void record(WritableSlice<K, V> slice, K key, V value) {
            Object object = this.lock;
            synchronized (object) {
                this.trace.record(slice, key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <K> void record(WritableSlice<K, Boolean> slice, K key) {
            Object object = this.lock;
            synchronized (object) {
                this.trace.record(slice, key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
            Object object = this.lock;
            synchronized (object) {
                return this.trace.get(slice, key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
            Object object = this.lock;
            // MONITORENTER : object
            Collection<K> collection = this.trace.getKeys(slice);
            // MONITOREXIT : object
            if (collection != null) return collection;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedLazyResolveStorageManager$LockProtectedTrace", "getKeys"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void report(@NotNull Diagnostic diagnostic) {
            if (diagnostic == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedLazyResolveStorageManager$LockProtectedTrace", "report"));
            }
            Object object = this.lock;
            synchronized (object) {
                this.trace.report(diagnostic);
            }
        }
    }

    private static class LockProtectedContext
    implements BindingContext {
        private final Object lock;
        private final BindingContext context;

        private LockProtectedContext(Object lock, BindingContext context) {
            this.lock = lock;
            this.context = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public Diagnostics getDiagnostics() {
            Object object = this.lock;
            // MONITORENTER : object
            Diagnostics diagnostics = this.context.getDiagnostics();
            // MONITOREXIT : object
            if (diagnostics != null) return diagnostics;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedLazyResolveStorageManager$LockProtectedContext", "getDiagnostics"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
            Object object = this.lock;
            synchronized (object) {
                return this.context.get(slice, key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
            Object object = this.lock;
            // MONITORENTER : object
            Collection<K> collection = this.context.getKeys(slice);
            // MONITOREXIT : object
            if (collection != null) return collection;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedLazyResolveStorageManager$LockProtectedContext", "getKeys"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <K, V> ImmutableMap<K, V> getSliceContents(@NotNull ReadOnlySlice<K, V> slice) {
            if (slice == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedLazyResolveStorageManager$LockProtectedContext", "getSliceContents"));
            }
            Object object = this.lock;
            // MONITORENTER : object
            ImmutableMap<K, V> immutableMap = this.context.getSliceContents(slice);
            // MONITOREXIT : object
            if (immutableMap != null) return immutableMap;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedLazyResolveStorageManager$LockProtectedContext", "getSliceContents"));
        }
    }
}

