/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.storage;

import com.intellij.openapi.util.Computable;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ConcurrentWeakValueHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.lazy.storage.MemoizedFunctionToNotNull;
import org.jetbrains.jet.lang.resolve.lazy.storage.MemoizedFunctionToNullable;
import org.jetbrains.jet.lang.resolve.lazy.storage.NotNullLazyValue;
import org.jetbrains.jet.lang.resolve.lazy.storage.NullableLazyValue;
import org.jetbrains.jet.lang.resolve.lazy.storage.StorageManager;
import org.jetbrains.jet.utils.ExceptionUtils;
import org.jetbrains.jet.utils.WrappedValues;

public class LockBasedStorageManager
implements StorageManager {
    protected final Object lock = new Object(){

        public String toString() {
            return "LockBasedStorageManager centralized lock";
        }
    };

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNotNull<K, V> createMemoizedFunction(@NotNull Function<K, V> compute, @NotNull StorageManager.ReferenceKind valuesReferenceKind) {
        if (compute == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager", "createMemoizedFunction"));
        }
        if (valuesReferenceKind == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager", "createMemoizedFunction"));
        }
        ConcurrentMap<K, V> map = LockBasedStorageManager.createConcurrentMap(valuesReferenceKind);
        MapBasedMemoizedFunctionToNotNull<K, V> mapBasedMemoizedFunctionToNotNull = new MapBasedMemoizedFunctionToNotNull<K, V>(this.lock, map, compute);
        if (mapBasedMemoizedFunctionToNotNull == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager", "createMemoizedFunction"));
        }
        return mapBasedMemoizedFunctionToNotNull;
    }

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNullable<K, V> createMemoizedFunctionWithNullableValues(@NotNull Function<K, V> compute, @NotNull StorageManager.ReferenceKind valuesReferenceKind) {
        if (compute == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager", "createMemoizedFunctionWithNullableValues"));
        }
        if (valuesReferenceKind == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager", "createMemoizedFunctionWithNullableValues"));
        }
        ConcurrentMap<K, V> map = LockBasedStorageManager.createConcurrentMap(valuesReferenceKind);
        MapBasedMemoizedFunction<K, V> mapBasedMemoizedFunction = new MapBasedMemoizedFunction<K, V>(this.lock, map, compute);
        if (mapBasedMemoizedFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager", "createMemoizedFunctionWithNullableValues"));
        }
        return mapBasedMemoizedFunction;
    }

    private static <K, V> ConcurrentMap<K, V> createConcurrentMap(StorageManager.ReferenceKind referenceKind) {
        return referenceKind == StorageManager.ReferenceKind.WEAK ? new ConcurrentWeakValueHashMap() : new ConcurrentHashMap();
    }

    @Override
    @NotNull
    public <T> NotNullLazyValue<T> createLazyValue(@NotNull Computable<T> computable) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager", "createLazyValue"));
        }
        LockBasedNotNullLazyValue<T> lockBasedNotNullLazyValue = new LockBasedNotNullLazyValue<T>(this.lock, computable);
        if (lockBasedNotNullLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager", "createLazyValue"));
        }
        return lockBasedNotNullLazyValue;
    }

    @Override
    @NotNull
    public <T> NotNullLazyValue<T> createLazyValueWithPostCompute(@NotNull Computable<T> computable, final @NotNull Consumer<T> postCompute) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager", "createLazyValueWithPostCompute"));
        }
        if (postCompute == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager", "createLazyValueWithPostCompute"));
        }
        LockBasedNotNullLazyValue lockBasedNotNullLazyValue = new LockBasedNotNullLazyValue<T>(this.lock, computable){

            @Override
            protected void postCompute(@NotNull T value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager$2", "postCompute"));
                }
                postCompute.consume(value);
            }
        };
        if (lockBasedNotNullLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager", "createLazyValueWithPostCompute"));
        }
        return lockBasedNotNullLazyValue;
    }

    @Override
    @NotNull
    public <T> NullableLazyValue<T> createNullableLazyValue(@NotNull Computable<T> computable) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager", "createNullableLazyValue"));
        }
        LockBasedLazyValue<T> lockBasedLazyValue = new LockBasedLazyValue<T>(this.lock, computable);
        if (lockBasedLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager", "createNullableLazyValue"));
        }
        return lockBasedLazyValue;
    }

    @Override
    @NotNull
    public <T> NullableLazyValue<T> createNullableLazyValueWithPostCompute(@NotNull Computable<T> computable, final @NotNull Consumer<T> postCompute) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager", "createNullableLazyValueWithPostCompute"));
        }
        if (postCompute == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager", "createNullableLazyValueWithPostCompute"));
        }
        LockBasedLazyValue lockBasedLazyValue = new LockBasedLazyValue<T>(this.lock, computable){

            @Override
            protected void postCompute(@Nullable T value) {
                postCompute.consume(value);
            }
        };
        if (lockBasedLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager", "createNullableLazyValueWithPostCompute"));
        }
        return lockBasedLazyValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T compute(@NotNull Computable<T> computable) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager", "compute"));
        }
        Object object = this.lock;
        synchronized (object) {
            return computable.compute();
        }
    }

    private static class MapBasedMemoizedFunctionToNotNull<K, V>
    extends MapBasedMemoizedFunction<K, V>
    implements MemoizedFunctionToNotNull<K, V> {
        public MapBasedMemoizedFunctionToNotNull(@NotNull Object lock, @NotNull ConcurrentMap<K, Object> map, @NotNull Function<K, V> compute) {
            if (lock == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager$MapBasedMemoizedFunctionToNotNull", "<init>"));
            }
            if (map == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager$MapBasedMemoizedFunctionToNotNull", "<init>"));
            }
            if (compute == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager$MapBasedMemoizedFunctionToNotNull", "<init>"));
            }
            super(lock, map, compute);
        }

        @Override
        @NotNull
        public V fun(@NotNull K input) {
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager$MapBasedMemoizedFunctionToNotNull", "fun"));
            }
            Object result = super.fun(input);
            assert (result != null) : "compute() returned null";
            Object v = result;
            if (v == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager$MapBasedMemoizedFunctionToNotNull", "fun"));
            }
            return v;
        }
    }

    private static class MapBasedMemoizedFunction<K, V>
    implements MemoizedFunctionToNullable<K, V> {
        private final Object lock;
        private final ConcurrentMap<K, Object> cache;
        private final Function<K, V> compute;

        public MapBasedMemoizedFunction(@NotNull Object lock, @NotNull ConcurrentMap<K, Object> map, @NotNull Function<K, V> compute) {
            if (lock == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager$MapBasedMemoizedFunction", "<init>"));
            }
            if (map == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager$MapBasedMemoizedFunction", "<init>"));
            }
            if (compute == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager$MapBasedMemoizedFunction", "<init>"));
            }
            this.lock = lock;
            this.cache = map;
            this.compute = compute;
        }

        @Override
        @Nullable
        public V fun(@NotNull K input) {
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager$MapBasedMemoizedFunction", "fun"));
            }
            Object value = this.cache.get(input);
            if (value != null) {
                return WrappedValues.unescapeExceptionOrNull(value);
            }
            Object object = this.lock;
            synchronized (object) {
                value = this.cache.get(input);
                if (value != null) {
                    return WrappedValues.unescapeExceptionOrNull(value);
                }
                try {
                    V typedValue = this.compute.fun(input);
                    Object oldValue = this.cache.put(input, WrappedValues.escapeNull(typedValue));
                    assert (oldValue == null) : "Race condition detected";
                    return typedValue;
                }
                catch (Throwable throwable) {
                    Object oldValue = this.cache.put(input, WrappedValues.escapeThrowable(throwable));
                    assert (oldValue == null) : "Race condition detected";
                    throw ExceptionUtils.rethrow(throwable);
                }
            }
        }
    }

    private static class LockBasedNotNullLazyValue<T>
    extends LockBasedLazyValue<T>
    implements NotNullLazyValue<T> {
        public LockBasedNotNullLazyValue(@NotNull Object lock, @NotNull Computable<T> computable) {
            if (lock == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager$LockBasedNotNullLazyValue", "<init>"));
            }
            if (computable == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager$LockBasedNotNullLazyValue", "<init>"));
            }
            super(lock, computable);
        }

        @Override
        @NotNull
        public T compute() {
            Object result = super.compute();
            assert (result != null) : "compute() returned null";
            Object t = result;
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager$LockBasedNotNullLazyValue", "compute"));
            }
            return t;
        }
    }

    private static class LockBasedLazyValue<T>
    implements NullableLazyValue<T> {
        private final Object lock;
        private final Computable<T> computable;
        @Nullable
        private volatile Object value;

        public LockBasedLazyValue(@NotNull Object lock, @NotNull Computable<T> computable) {
            if (lock == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager$LockBasedLazyValue", "<init>"));
            }
            if (computable == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/lazy/storage/LockBasedStorageManager$LockBasedLazyValue", "<init>"));
            }
            this.value = null;
            this.lock = lock;
            this.computable = computable;
        }

        @Override
        public T compute() {
            Object _value = this.value;
            if (_value != null) {
                return (T)WrappedValues.unescapeExceptionOrNull(_value);
            }
            Object object = this.lock;
            synchronized (object) {
                _value = this.value;
                if (_value != null) {
                    return (T)WrappedValues.unescapeExceptionOrNull(_value);
                }
                try {
                    T typedValue = this.computable.compute();
                    this.value = WrappedValues.escapeNull(typedValue);
                    this.postCompute(typedValue);
                    return typedValue;
                }
                catch (Throwable throwable) {
                    this.value = WrappedValues.escapeThrowable(throwable);
                    throw ExceptionUtils.rethrow(throwable);
                }
            }
        }

        protected void postCompute(T value) {
        }
    }
}

