/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotatedImpl;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;

public final class JetTypeImpl
extends AnnotatedImpl
implements JetType {
    private final TypeConstructor constructor;
    private final List<TypeProjection> arguments;
    private final boolean nullable;
    private final JetScope memberScope;

    public JetTypeImpl(List<AnnotationDescriptor> annotations, TypeConstructor constructor, boolean nullable, @NotNull List<TypeProjection> arguments, JetScope memberScope) {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/types/JetTypeImpl", "<init>"));
        }
        super(annotations);
        if (memberScope instanceof ErrorUtils.ErrorScope) {
            throw new IllegalStateException("JetTypeImpl should not be created for error type: " + memberScope + "\n" + constructor);
        }
        this.constructor = constructor;
        this.nullable = nullable;
        this.arguments = arguments;
        this.memberScope = memberScope;
    }

    public JetTypeImpl(TypeConstructor constructor, JetScope memberScope) {
        this(Collections.emptyList(), constructor, false, Collections.emptyList(), memberScope);
    }

    public JetTypeImpl(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/JetTypeImpl", "<init>"));
        }
        this(Collections.emptyList(), classDescriptor.getTypeConstructor(), false, Collections.emptyList(), classDescriptor.getMemberScope(Collections.<TypeProjection>emptyList()));
    }

    @Override
    @NotNull
    public TypeConstructor getConstructor() {
        TypeConstructor typeConstructor = this.constructor;
        if (typeConstructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/JetTypeImpl", "getConstructor"));
        }
        return typeConstructor;
    }

    @Override
    @NotNull
    public List<TypeProjection> getArguments() {
        List<TypeProjection> list = this.arguments;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/JetTypeImpl", "getArguments"));
        }
        return list;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    @NotNull
    public JetScope getMemberScope() {
        JetScope jetScope = this.memberScope;
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/JetTypeImpl", "getMemberScope"));
        }
        return jetScope;
    }

    @Override
    public boolean isError() {
        return false;
    }

    public String toString() {
        return TypeUtils.toString(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JetType)) {
            return false;
        }
        JetType type = (JetType)o;
        return this.nullable == type.isNullable() && JetTypeChecker.INSTANCE.equalTypes(this, type);
    }

    public int hashCode() {
        int result = this.constructor.hashCode();
        result = 31 * result + ((Object)this.arguments).hashCode();
        result = 31 * result + (this.nullable ? 1 : 0);
        return result;
    }
}

