/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.Variance;

public class TypeProjection {
    private final Variance projection;
    private final JetType type;

    public TypeProjection(@NotNull Variance projection, @NotNull JetType type) {
        if (projection == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/TypeProjection", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/types/TypeProjection", "<init>"));
        }
        this.projection = projection;
        this.type = type;
    }

    public TypeProjection(JetType type) {
        this(Variance.INVARIANT, type);
    }

    @NotNull
    public Variance getProjectionKind() {
        Variance variance = this.projection;
        if (variance == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeProjection", "getProjectionKind"));
        }
        return variance;
    }

    @NotNull
    public JetType getType() {
        JetType jetType = this.type;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeProjection", "getType"));
        }
        return jetType;
    }

    public String toString() {
        if (this.projection == Variance.INVARIANT) {
            return this.type.toString();
        }
        return (Object)((Object)this.projection) + " " + this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeProjection that = (TypeProjection)o;
        if (this.projection != that.projection) {
            return false;
        }
        return !(this.type != null ? !((Object)this.type).equals(that.type) : that.type != null);
    }

    public int hashCode() {
        int result = this.projection != null ? this.projection.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }
}

