/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.lang;

import com.google.common.collect.ImmutableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public enum PrimitiveType {
    BOOLEAN("Boolean"),
    CHAR("Char"),
    BYTE("Byte"),
    SHORT("Short"),
    INT("Int"),
    FLOAT("Float"),
    LONG("Long"),
    DOUBLE("Double");

    public static final ImmutableSet<PrimitiveType> NUMBER_TYPES;
    private final Name typeName;
    private final Name arrayTypeName;
    private final Name rangeTypeName;
    private final FqName className;
    private final FqName arrayClassName;
    private final FqName rangeClassName;
    private final FqName progressionClassName;

    private PrimitiveType(String typeName) {
        this.typeName = Name.identifier(typeName);
        this.arrayTypeName = Name.identifier(typeName + "Array");
        this.rangeTypeName = Name.identifier(typeName + "Range");
        FqName builtInsPackageFqName = KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME;
        this.className = builtInsPackageFqName.child(this.typeName);
        this.arrayClassName = builtInsPackageFqName.child(this.arrayTypeName);
        this.rangeClassName = builtInsPackageFqName.child(this.rangeTypeName);
        this.progressionClassName = builtInsPackageFqName.child(Name.identifier(typeName + "Progression"));
    }

    @NotNull
    public Name getTypeName() {
        Name name = this.typeName;
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/PrimitiveType", "getTypeName"));
        }
        return name;
    }

    @NotNull
    public Name getArrayTypeName() {
        Name name = this.arrayTypeName;
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/PrimitiveType", "getArrayTypeName"));
        }
        return name;
    }

    @NotNull
    public Name getRangeTypeName() {
        Name name = this.rangeTypeName;
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/PrimitiveType", "getRangeTypeName"));
        }
        return name;
    }

    @NotNull
    public FqName getClassName() {
        FqName fqName = this.className;
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/PrimitiveType", "getClassName"));
        }
        return fqName;
    }

    @NotNull
    public FqName getArrayClassName() {
        FqName fqName = this.arrayClassName;
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/PrimitiveType", "getArrayClassName"));
        }
        return fqName;
    }

    @NotNull
    public FqName getRangeClassName() {
        FqName fqName = this.rangeClassName;
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/PrimitiveType", "getRangeClassName"));
        }
        return fqName;
    }

    @NotNull
    public FqName getProgressionClassName() {
        FqName fqName = this.progressionClassName;
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/PrimitiveType", "getProgressionClassName"));
        }
        return fqName;
    }

    static {
        NUMBER_TYPES = ImmutableSet.of(CHAR, BYTE, SHORT, INT, FLOAT, LONG, new PrimitiveType[]{DOUBLE});
    }
}

