/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.ref;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.ref.JetTypeName;
import org.jetbrains.jet.lang.types.ref.SimpleParser;

class JetTypeNameParser
extends SimpleParser {
    private static final Pattern namePattern = Pattern.compile("(?i)[a-z][a-z0-9]*");

    public JetTypeNameParser(String input) {
        super(input);
    }

    @NotNull
    public Name parseName() {
        Name name = Name.identifier(this.consume(namePattern));
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ref/JetTypeNameParser", "parseName"));
        }
        return name;
    }

    @NotNull
    public FqName parseFqName() {
        FqName fqName = FqName.topLevel(this.parseName());
        while (this.consumeIfLookingAt('.')) {
            fqName = fqName.child(this.parseName());
        }
        FqName fqName2 = fqName;
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ref/JetTypeNameParser", "parseFqName"));
        }
        return fqName2;
    }

    @NotNull
    public JetTypeName parse() {
        FqName fqName = this.parseFqName();
        ArrayList<JetTypeName> typeArguments = Lists.newArrayList();
        if (this.consumeIfLookingAt('<')) {
            typeArguments.add(this.parse());
            while (this.consumeIfLookingAt(',')) {
                typeArguments.add(this.parse());
            }
            this.consume('>');
        }
        JetTypeName jetTypeName = new JetTypeName(fqName, typeArguments);
        if (jetTypeName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ref/JetTypeNameParser", "parse"));
        }
        return jetTypeName;
    }

    @NotNull
    public static JetTypeName parse(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/ref/JetTypeNameParser", "parse"));
        }
        JetTypeNameParser parser = new JetTypeNameParser(string);
        JetTypeName typeName = parser.parse();
        parser.checkEof();
        JetTypeName jetTypeName = typeName;
        if (jetTypeName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ref/JetTypeNameParser", "parse"));
        }
        return jetTypeName;
    }
}

