/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.js.compiler;

import com.google.dart.compiler.backend.js.JsToStringGenerationVisitor;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.backend.js.ast.JsProgramFragment;
import com.google.dart.compiler.util.TextOutput;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.js.compiler.SourceMapBuilder;

public class JsSourceGenerationVisitor
extends JsToStringGenerationVisitor
implements TextOutput.OutListener {
    @Nullable
    private final SourceMapBuilder sourceMapBuilder;
    private Object pendingSourceInfo;

    public JsSourceGenerationVisitor(TextOutput out, @Nullable SourceMapBuilder sourceMapBuilder) {
        super(out);
        this.sourceMapBuilder = sourceMapBuilder;
        out.setOutListener(this);
    }

    @Override
    public void visitProgramFragment(JsProgramFragment x) {
        x.acceptChildren(this);
    }

    @Override
    public void visitBlock(JsBlock x) {
        this.printJsBlock(x, false, true);
    }

    @Override
    public void newLined() {
        if (this.sourceMapBuilder != null) {
            this.sourceMapBuilder.newLine();
        }
    }

    @Override
    public void indentedAfterNewLine() {
        if (this.pendingSourceInfo != null) {
            assert (this.sourceMapBuilder != null);
            this.sourceMapBuilder.processSourceInfo(this.pendingSourceInfo);
            this.pendingSourceInfo = null;
        }
    }

    public void accept(JsNode node) {
        if (!(node instanceof JsNameRef)) {
            this.mapSource(node);
        }
        super.accept(node);
    }

    private void mapSource(JsNode node) {
        Object sourceInfo;
        if (this.sourceMapBuilder != null && (sourceInfo = node.getSource()) != null) {
            assert (this.pendingSourceInfo == null);
            if (this.p.isJustNewlined()) {
                this.pendingSourceInfo = sourceInfo;
            } else {
                this.sourceMapBuilder.processSourceInfo(sourceInfo);
            }
        }
    }

    @Override
    protected void beforeNodePrinted(JsNode node) {
        this.mapSource(node);
    }

    @Override
    public void visitProgram(JsProgram program) {
        program.acceptChildren(this);
        if (this.sourceMapBuilder != null) {
            this.sourceMapBuilder.addLink();
        }
    }
}

