/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.context;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Named;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.Name;

public final class Namer {
    public static final String KOTLIN_NAME = "Kotlin";
    public static final String KOTLIN_LOWER_NAME = "Kotlin".toLowerCase();
    public static final String CALLEE_NAME = "$fun";
    public static final String OUTER_CLASS_NAME = "$outer";
    private static final Named CLASS_OBJECT_INITIALIZER_NAMED = new Named(){

        @Override
        @NotNull
        public Name getName() {
            Name name = Name.identifier("object_initializer$");
            if (name == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer$1", "getName"));
            }
            return name;
        }
    };
    @NotNull
    private final JsName kotlinName;
    @NotNull
    private final JsScope kotlinScope;
    @NotNull
    private final JsName className;
    @NotNull
    private final JsName traitName;
    @NotNull
    private final JsExpression definePackage;
    @NotNull
    private final JsExpression defineRootPackage;
    @NotNull
    private final JsName objectName;
    @NotNull
    private final JsName enumEntriesName;
    @NotNull
    private final JsName isTypeName;

    @NotNull
    public static String getReceiverParameterName() {
        if ("$receiver" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getReceiverParameterName"));
        }
        return "$receiver";
    }

    @NotNull
    public static String getRootNamespaceName() {
        if ("_" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getRootNamespaceName"));
        }
        return "_";
    }

    @NotNull
    public static JsNameRef superMethodNameRef(@NotNull JsName superClassJsName) {
        if (superClassJsName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/context/Namer", "superMethodNameRef"));
        }
        JsNameRef jsNameRef = new JsNameRef("baseInitializer", (JsExpression)superClassJsName.makeRef());
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "superMethodNameRef"));
        }
        return jsNameRef;
    }

    @NotNull
    public static String nameForClassesVariable() {
        if ("_c" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "nameForClassesVariable"));
        }
        return "_c";
    }

    @NotNull
    public static String getNameForAccessor(@NotNull String propertyName, boolean isGetter, boolean useNativeAccessor) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/context/Namer", "getNameForAccessor"));
        }
        if (useNativeAccessor) {
            String string = propertyName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getNameForAccessor"));
            }
            return string;
        }
        if (isGetter) {
            String string = Namer.getNameForGetter(propertyName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getNameForAccessor"));
            }
            return string;
        }
        String string = Namer.getNameForSetter(propertyName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getNameForAccessor"));
        }
        return string;
    }

    @NotNull
    public static String getKotlinBackingFieldName(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/context/Namer", "getKotlinBackingFieldName"));
        }
        String string = Namer.getNameWithPrefix(propertyName, "$");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getKotlinBackingFieldName"));
        }
        return string;
    }

    @NotNull
    private static String getNameForGetter(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/context/Namer", "getNameForGetter"));
        }
        String string = Namer.getNameWithPrefix(propertyName, "get_");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getNameForGetter"));
        }
        return string;
    }

    @NotNull
    private static String getNameForSetter(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/context/Namer", "getNameForSetter"));
        }
        String string = Namer.getNameWithPrefix(propertyName, "set_");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getNameForSetter"));
        }
        return string;
    }

    @NotNull
    public static JsExpression getClassObjectAccessor(@NotNull JsExpression referenceToClass) {
        if (referenceToClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/context/Namer", "getClassObjectAccessor"));
        }
        JsNameRef jsNameRef = new JsNameRef("object", referenceToClass);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getClassObjectAccessor"));
        }
        return jsNameRef;
    }

    @NotNull
    public static Named getNamedForClassObjectInitializer() {
        Named named = CLASS_OBJECT_INITIALIZER_NAMED;
        if (named == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getNamedForClassObjectInitializer"));
        }
        return named;
    }

    @NotNull
    public static String getDelegateName(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/context/Namer", "getDelegateName"));
        }
        String string = propertyName + "$delegate";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getDelegateName"));
        }
        return string;
    }

    @NotNull
    public static JsNameRef getDelegateNameRef(String propertyName) {
        JsNameRef jsNameRef = new JsNameRef(Namer.getDelegateName(propertyName), (JsExpression)JsLiteral.THIS);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getDelegateNameRef"));
        }
        return jsNameRef;
    }

    @NotNull
    private static String getNameWithPrefix(@NotNull String name, @NotNull String prefix) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/context/Namer", "getNameWithPrefix"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/context/Namer", "getNameWithPrefix"));
        }
        String string = prefix + name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getNameWithPrefix"));
        }
        return string;
    }

    @NotNull
    public static JsNameRef getFunctionCallRef(@NotNull JsExpression functionExpression) {
        if (functionExpression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/context/Namer", "getFunctionCallRef"));
        }
        JsNameRef jsNameRef = new JsNameRef("call", functionExpression);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getFunctionCallRef"));
        }
        return jsNameRef;
    }

    @NotNull
    public static Namer newInstance(@NotNull JsScope rootScope) {
        if (rootScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/context/Namer", "newInstance"));
        }
        Namer namer = new Namer(rootScope);
        if (namer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "newInstance"));
        }
        return namer;
    }

    private Namer(@NotNull JsScope rootScope) {
        if (rootScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/context/Namer", "<init>"));
        }
        this.kotlinName = rootScope.declareName(KOTLIN_NAME);
        this.kotlinScope = new JsScope(rootScope, "Kotlin standard object");
        this.traitName = this.kotlinScope.declareName("createTrait");
        this.definePackage = this.kotlin("definePackage");
        this.defineRootPackage = this.kotlin("defineRootPackage");
        this.className = this.kotlinScope.declareName("createClass");
        this.enumEntriesName = this.kotlinScope.declareName("createEnumEntries");
        this.objectName = this.kotlinScope.declareName("createObject");
        this.isTypeName = this.kotlinScope.declareName("isType");
    }

    @NotNull
    public JsExpression classCreationMethodReference() {
        JsNameRef jsNameRef = this.kotlin(this.className);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "classCreationMethodReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression enumEntriesCreationMethodReference() {
        JsNameRef jsNameRef = this.kotlin(this.enumEntriesName);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "enumEntriesCreationMethodReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression traitCreationMethodReference() {
        JsNameRef jsNameRef = this.kotlin(this.traitName);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "traitCreationMethodReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression packageDefinitionMethodReference() {
        JsExpression jsExpression = this.definePackage;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "packageDefinitionMethodReference"));
        }
        return jsExpression;
    }

    @NotNull
    public JsExpression rootPackageDefinitionMethodReference() {
        JsExpression jsExpression = this.defineRootPackage;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "rootPackageDefinitionMethodReference"));
        }
        return jsExpression;
    }

    @NotNull
    public JsExpression objectCreationMethodReference() {
        JsNameRef jsNameRef = this.kotlin(this.objectName);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "objectCreationMethodReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression throwNPEFunctionRef() {
        JsNameRef jsNameRef = new JsNameRef("throwNPE", (JsExpression)this.kotlinObject());
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "throwNPEFunctionRef"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsNameRef propertyMetadataRef() {
        JsNameRef jsNameRef = new JsNameRef("PropertyMetadata", (JsExpression)this.kotlinObject());
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "propertyMetadataRef"));
        }
        return jsNameRef;
    }

    @NotNull
    private JsNameRef kotlin(@NotNull JsName name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/context/Namer", "kotlin"));
        }
        JsNameRef jsNameRef = new JsNameRef(name, (JsExpression)this.kotlinObject());
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "kotlin"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression kotlin(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/context/Namer", "kotlin"));
        }
        JsNameRef jsNameRef = this.kotlin(this.kotlinScope.declareName(name));
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "kotlin"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsNameRef kotlinObject() {
        JsNameRef jsNameRef = this.kotlinName.makeRef();
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "kotlinObject"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression isOperationReference() {
        JsNameRef jsNameRef = this.kotlin(this.isTypeName);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "isOperationReference"));
        }
        return jsNameRef;
    }

    @NotNull
    JsScope getKotlinScope() {
        JsScope jsScope = this.kotlinScope;
        if (jsScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "getKotlinScope"));
        }
        return jsScope;
    }

    @NotNull
    static String generateNamespaceName(DeclarationDescriptor descriptor) {
        if (DescriptorUtils.isRootNamespace((NamespaceDescriptor)descriptor)) {
            String string = Namer.getRootNamespaceName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "generateNamespaceName"));
            }
            return string;
        }
        String string = descriptor.getName().asString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "generateNamespaceName"));
        }
        return string;
    }

    @NotNull
    public JsInvocation classCreateInvocation(@NotNull ClassDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/context/Namer", "classCreateInvocation"));
        }
        switch (descriptor.getKind()) {
            case TRAIT: {
                JsInvocation jsInvocation = new JsInvocation(this.traitCreationMethodReference());
                if (jsInvocation == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "classCreateInvocation"));
                }
                return jsInvocation;
            }
            case OBJECT: 
            case CLASS_OBJECT: 
            case ENUM_ENTRY: {
                JsInvocation jsInvocation = new JsInvocation(this.objectCreationMethodReference());
                if (jsInvocation == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "classCreateInvocation"));
                }
                return jsInvocation;
            }
        }
        JsInvocation jsInvocation = new JsInvocation(this.classCreationMethodReference());
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "classCreateInvocation"));
        }
        return jsInvocation;
    }

    @NotNull
    public JsInvocation enumEntriesObjectCreateInvocation() {
        JsInvocation jsInvocation = new JsInvocation(this.enumEntriesCreationMethodReference());
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/Namer", "enumEntriesObjectCreateInvocation"));
        }
        return jsInvocation;
    }
}

