/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.declaration;

import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVars;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.declaration.DefineInvocation;
import org.jetbrains.k2js.translate.declaration.NamespaceTranslator;
import org.jetbrains.k2js.translate.general.AbstractTranslator;

public final class NamespaceDeclarationTranslator
extends AbstractTranslator {
    private final Iterable<JetFile> files;
    private final Map<NamespaceDescriptor, NamespaceTranslator> descriptorToTranslator;

    public static List<JsStatement> translateFiles(@NotNull Collection<JetFile> files, @NotNull TranslationContext context) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/declaration/NamespaceDeclarationTranslator", "translateFiles"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/declaration/NamespaceDeclarationTranslator", "translateFiles"));
        }
        return new NamespaceDeclarationTranslator(files, context).translate();
    }

    private NamespaceDeclarationTranslator(@NotNull Iterable<JetFile> files, @NotNull TranslationContext context) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/declaration/NamespaceDeclarationTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/declaration/NamespaceDeclarationTranslator", "<init>"));
        }
        super(context);
        this.descriptorToTranslator = new LinkedHashMap<NamespaceDescriptor, NamespaceTranslator>();
        this.files = files;
    }

    @NotNull
    private List<JsStatement> translate() {
        THashMap<NamespaceDescriptor, DefineInvocation> descriptorToDefineInvocation = new THashMap<NamespaceDescriptor, DefineInvocation>();
        NamespaceDescriptor rootNamespaceDescriptor = null;
        for (JetFile file : this.files) {
            NamespaceDescriptor descriptor = this.context().bindingContext().get(BindingContext.FILE_TO_NAMESPACE, file);
            assert (descriptor != null);
            NamespaceTranslator translator = this.descriptorToTranslator.get(descriptor);
            if (translator == null) {
                if (rootNamespaceDescriptor == null) {
                    rootNamespaceDescriptor = this.getRootPackageDescriptor(descriptorToDefineInvocation, descriptor);
                }
                translator = new NamespaceTranslator(descriptor, descriptorToDefineInvocation, this.context());
                this.descriptorToTranslator.put(descriptor, translator);
            }
            translator.translate(file);
        }
        if (rootNamespaceDescriptor == null) {
            List<JsStatement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/NamespaceDeclarationTranslator", "translate"));
            }
            return list;
        }
        this.context().classDeclarationTranslator().generateDeclarations();
        for (NamespaceTranslator translator : this.descriptorToTranslator.values()) {
            translator.add(descriptorToDefineInvocation);
        }
        JsVars vars = new JsVars(true);
        vars.addIfHasInitializer(this.context().classDeclarationTranslator().getDeclaration());
        vars.addIfHasInitializer(this.getRootPackageDeclaration((DefineInvocation)descriptorToDefineInvocation.get(rootNamespaceDescriptor)));
        List<JsStatement> list = Collections.singletonList(vars);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/NamespaceDeclarationTranslator", "translate"));
        }
        return list;
    }

    @NotNull
    private NamespaceDescriptor getRootPackageDescriptor(@NotNull Map<NamespaceDescriptor, DefineInvocation> descriptorToDefineInvocation, @NotNull NamespaceDescriptor descriptor) {
        if (descriptorToDefineInvocation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/declaration/NamespaceDeclarationTranslator", "getRootPackageDescriptor"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/declaration/NamespaceDeclarationTranslator", "getRootPackageDescriptor"));
        }
        NamespaceDescriptor rootNamespace = descriptor;
        while (DescriptorUtils.isTopLevelDeclaration(rootNamespace)) {
            rootNamespace = (NamespaceDescriptor)rootNamespace.getContainingDeclaration();
        }
        descriptorToDefineInvocation.put(rootNamespace, DefineInvocation.createDefineInvocation(rootNamespace, null, new JsObjectLiteral(true), this.context()));
        NamespaceDescriptor namespaceDescriptor = rootNamespace;
        if (namespaceDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/NamespaceDeclarationTranslator", "getRootPackageDescriptor"));
        }
        return namespaceDescriptor;
    }

    private JsVars.JsVar getRootPackageDeclaration(@NotNull DefineInvocation defineInvocation) {
        if (defineInvocation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/declaration/NamespaceDeclarationTranslator", "getRootPackageDeclaration"));
        }
        JsInvocation rootPackageVar = new JsInvocation(this.context().namer().rootPackageDefinitionMethodReference(), defineInvocation.asList());
        return new JsVars.JsVar(this.context().scope().declareName(Namer.getRootNamespaceName()), rootPackageVar);
    }
}

