/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsIf;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVars;
import com.intellij.openapi.util.Pair;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetWhenCondition;
import org.jetbrains.jet.lang.psi.JetWhenConditionIsPattern;
import org.jetbrains.jet.lang.psi.JetWhenConditionWithExpression;
import org.jetbrains.jet.lang.psi.JetWhenEntry;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;
import org.jetbrains.k2js.translate.utils.mutator.AssignToExpressionMutator;
import org.jetbrains.k2js.translate.utils.mutator.LastExpressionMutator;

public final class WhenTranslator
extends AbstractTranslator {
    @NotNull
    private final JetWhenExpression whenExpression;
    @Nullable
    private final Pair<JsVars.JsVar, JsExpression> expressionToMatch;
    @Nullable
    private Pair<JsVars.JsVar, JsExpression> result;

    @Nullable
    public static JsNode translate(@NotNull JetWhenExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/WhenTranslator", "translate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/expression/WhenTranslator", "translate"));
        }
        WhenTranslator translator = new WhenTranslator(expression, context);
        if (BindingUtils.isStatement(context.bindingContext(), expression)) {
            translator.translateAsStatement(context.dynamicContext().jsBlock().getStatements());
            return null;
        }
        return translator.translateAsExpression();
    }

    private WhenTranslator(@NotNull JetWhenExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/WhenTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/expression/WhenTranslator", "<init>"));
        }
        super(context);
        this.whenExpression = expression;
        JetExpression subject = expression.getSubjectExpression();
        this.expressionToMatch = subject != null ? TranslationUtils.createTemporaryIfNeed(Translation.translateAsExpression(subject, this.context()), context) : null;
    }

    @Nullable
    private JsNode translateAsExpression() {
        this.result = this.context().dynamicContext().createTemporary(null);
        this.translateAsStatement(this.context().dynamicContext().jsBlock().getStatements());
        return (JsNode)this.result.second;
    }

    private void translateAsStatement(List<JsStatement> statements) {
        this.addTempVarsStatement(statements);
        JsIf prevIf = null;
        for (JetWhenEntry entry : this.whenExpression.getEntries()) {
            JsStatement statement = this.withReturnValueCaptured(this.translateEntryExpression(entry));
            if (entry.isElse()) {
                if (prevIf == null) {
                    statements.add(statement);
                    break;
                }
                prevIf.setElseStatement(statement);
                break;
            }
            JsIf ifStatement = new JsIf(this.translateConditions(entry), statement);
            if (prevIf == null) {
                statements.add(ifStatement);
            } else {
                prevIf.setElseStatement(ifStatement);
            }
            prevIf = ifStatement;
        }
    }

    private void addTempVarsStatement(List<JsStatement> statements) {
        JsVars vars = new JsVars();
        if (this.expressionToMatch != null && this.expressionToMatch.first != null) {
            vars.add((JsVars.JsVar)this.expressionToMatch.first);
        }
        if (this.result != null) {
            vars.add((JsVars.JsVar)this.result.first);
        }
        if (!vars.isEmpty()) {
            statements.add(vars);
        }
    }

    @NotNull
    private JsStatement withReturnValueCaptured(@NotNull JsNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/WhenTranslator", "withReturnValueCaptured"));
        }
        JsStatement jsStatement = this.result == null ? JsAstUtils.convertToStatement(node) : LastExpressionMutator.mutateLastExpression(node, new AssignToExpressionMutator((JsExpression)this.result.second));
        if (jsStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/WhenTranslator", "withReturnValueCaptured"));
        }
        return jsStatement;
    }

    @NotNull
    private JsNode translateEntryExpression(@NotNull JetWhenEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/WhenTranslator", "translateEntryExpression"));
        }
        JetExpression expressionToExecute = entry.getExpression();
        assert (expressionToExecute != null) : "WhenEntry should have whenExpression to execute.";
        JsNode jsNode = Translation.translateExpression(expressionToExecute, this.context());
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/WhenTranslator", "translateEntryExpression"));
        }
        return jsNode;
    }

    @NotNull
    private JsExpression translateConditions(@NotNull JetWhenEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/WhenTranslator", "translateConditions"));
        }
        JetWhenCondition[] conditions = entry.getConditions();
        assert (conditions.length > 0) : "When entry (not else) should have at least one condition";
        if (conditions.length == 1) {
            JsExpression jsExpression = this.translateCondition(conditions[0]);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/WhenTranslator", "translateConditions"));
            }
            return jsExpression;
        }
        JsExpression result = this.translateCondition(conditions[0]);
        for (int i = 1; i < conditions.length; ++i) {
            result = new JsBinaryOperation(JsBinaryOperator.OR, this.translateCondition(conditions[i]), result);
        }
        JsExpression jsExpression = result;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/WhenTranslator", "translateConditions"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression translateCondition(@NotNull JetWhenCondition condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/WhenTranslator", "translateCondition"));
        }
        if (condition instanceof JetWhenConditionIsPattern || condition instanceof JetWhenConditionWithExpression) {
            JsExpression jsExpression = this.translatePatternCondition(condition);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/WhenTranslator", "translateCondition"));
            }
            return jsExpression;
        }
        throw new AssertionError((Object)("Unsupported when condition " + condition.getClass()));
    }

    @NotNull
    private JsExpression translatePatternCondition(@NotNull JetWhenCondition condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/WhenTranslator", "translatePatternCondition"));
        }
        JsExpression patternMatchExpression = this.translateWhenConditionToBooleanExpression(condition);
        if (WhenTranslator.isNegated(condition)) {
            JsPrefixOperation jsPrefixOperation = JsAstUtils.negated(patternMatchExpression);
            if (jsPrefixOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/WhenTranslator", "translatePatternCondition"));
            }
            return jsPrefixOperation;
        }
        JsExpression jsExpression = patternMatchExpression;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/WhenTranslator", "translatePatternCondition"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression translateWhenConditionToBooleanExpression(@NotNull JetWhenCondition condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/WhenTranslator", "translateWhenConditionToBooleanExpression"));
        }
        if (condition instanceof JetWhenConditionIsPattern) {
            JsExpression jsExpression = this.translateIsCondition((JetWhenConditionIsPattern)condition);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/WhenTranslator", "translateWhenConditionToBooleanExpression"));
            }
            return jsExpression;
        }
        if (condition instanceof JetWhenConditionWithExpression) {
            JsExpression jsExpression = this.translateExpressionCondition((JetWhenConditionWithExpression)condition);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/WhenTranslator", "translateWhenConditionToBooleanExpression"));
            }
            return jsExpression;
        }
        throw new AssertionError((Object)"Wrong type of JetWhenCondition");
    }

    @NotNull
    private JsExpression translateIsCondition(@NotNull JetWhenConditionIsPattern conditionIsPattern) {
        if (conditionIsPattern == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/WhenTranslator", "translateIsCondition"));
        }
        JsExpression expressionToMatch = this.getExpressionToMatch();
        assert (expressionToMatch != null) : "An is-check is not allowed in when() without subject.";
        JetTypeReference typeReference = conditionIsPattern.getTypeRef();
        assert (typeReference != null) : "An is-check must have a type reference.";
        JsExpression jsExpression = Translation.patternTranslator(this.context()).translateIsCheck(expressionToMatch, typeReference);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/WhenTranslator", "translateIsCondition"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression translateExpressionCondition(@NotNull JetWhenConditionWithExpression condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/WhenTranslator", "translateExpressionCondition"));
        }
        JetExpression patternExpression = condition.getExpression();
        assert (patternExpression != null) : "Expression pattern should have an expression.";
        JsExpression expressionToMatch = this.getExpressionToMatch();
        if (expressionToMatch == null) {
            JsExpression jsExpression = Translation.patternTranslator(this.context()).translateExpressionForExpressionPattern(patternExpression);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/WhenTranslator", "translateExpressionCondition"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = Translation.patternTranslator(this.context()).translateExpressionPattern(expressionToMatch, patternExpression);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/WhenTranslator", "translateExpressionCondition"));
        }
        return jsExpression;
    }

    @Nullable
    private JsExpression getExpressionToMatch() {
        return this.expressionToMatch != null ? (JsExpression)this.expressionToMatch.second : null;
    }

    private static boolean isNegated(@NotNull JetWhenCondition condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/WhenTranslator", "isNegated"));
        }
        if (condition instanceof JetWhenConditionIsPattern) {
            return ((JetWhenConditionIsPattern)condition).isNegated();
        }
        return false;
    }
}

