/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression.foreach;

import com.google.common.collect.Lists;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFor;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVars;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.expression.foreach.ForTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;
import org.jetbrains.k2js.translate.utils.TemporariesUtils;

public final class RangeForTranslator
extends ForTranslator {
    @NotNull
    private final TemporaryVariable rangeExpression;
    @NotNull
    private final TemporaryVariable start;
    @NotNull
    private final TemporaryVariable end;
    @NotNull
    private final TemporaryVariable increment;

    @NotNull
    public static JsStatement doTranslate(@NotNull JetForExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/foreach/RangeForTranslator", "doTranslate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/expression/foreach/RangeForTranslator", "doTranslate"));
        }
        JsBlock jsBlock = new RangeForTranslator(expression, context).translate();
        if (jsBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/RangeForTranslator", "doTranslate"));
        }
        return jsBlock;
    }

    public static boolean isApplicable(@NotNull JetForExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/foreach/RangeForTranslator", "isApplicable"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/expression/foreach/RangeForTranslator", "isApplicable"));
        }
        JetExpression loopRange = PsiUtils.getLoopRange(expression);
        JetType rangeType = BindingUtils.getTypeForExpression(context.bindingContext(), loopRange);
        return DescriptorUtils.getClassDescriptorForType(rangeType).getName().asString().equals("IntRange");
    }

    private RangeForTranslator(@NotNull JetForExpression forExpression, @NotNull TranslationContext context) {
        if (forExpression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/foreach/RangeForTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/expression/foreach/RangeForTranslator", "<init>"));
        }
        super(forExpression, context);
        this.rangeExpression = context.declareTemporary(Translation.translateAsExpression(PsiUtils.getLoopRange(this.expression), context));
        this.start = this.context().declareTemporary(this.getProperty("start"));
        this.end = this.context().declareTemporary(this.getProperty("end"));
        this.increment = this.context().declareTemporary(this.getProperty("increment"));
    }

    @NotNull
    private JsBlock translate() {
        ArrayList<JsStatement> blockStatements = Lists.newArrayList();
        blockStatements.add(TemporariesUtils.temporariesInitialization(this.rangeExpression, this.start, this.end, this.increment).makeStmt());
        blockStatements.add(this.generateForExpression());
        JsBlock jsBlock = new JsBlock(blockStatements);
        if (jsBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/RangeForTranslator", "translate"));
        }
        return jsBlock;
    }

    @NotNull
    private JsFor generateForExpression() {
        JsFor result = new JsFor(this.initExpression(), this.getCondition(), this.getIncrExpression());
        result.setBody(this.translateBody(null));
        JsFor jsFor = result;
        if (jsFor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/RangeForTranslator", "generateForExpression"));
        }
        return jsFor;
    }

    @NotNull
    private JsVars initExpression() {
        JsVars jsVars = JsAstUtils.newVar(this.parameterName, this.start.reference());
        if (jsVars == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/RangeForTranslator", "initExpression"));
        }
        return jsVars;
    }

    @NotNull
    private JsExpression getCondition() {
        JsBinaryOperation jsBinaryOperation = JsAstUtils.lessThanEq(this.parameterName.makeRef(), this.end.reference());
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/RangeForTranslator", "getCondition"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    private JsExpression getIncrExpression() {
        JsBinaryOperation jsBinaryOperation = JsAstUtils.addAssign(this.parameterName.makeRef(), this.increment.reference());
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/RangeForTranslator", "getIncrExpression"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    private JsExpression getProperty(@NotNull String funName) {
        if (funName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/foreach/RangeForTranslator", "getProperty"));
        }
        JsNameRef jsNameRef = new JsNameRef(funName, (JsExpression)this.rangeExpression.reference());
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/RangeForTranslator", "getProperty"));
        }
        return jsNameRef;
    }
}

