/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.general;

import com.google.dart.compiler.backend.js.ast.JsProgram;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.k2js.translate.context.TranslationContext;

public abstract class AbstractTranslator {
    @NotNull
    private final TranslationContext context;

    protected AbstractTranslator(@NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/general/AbstractTranslator", "<init>"));
        }
        this.context = context;
    }

    @NotNull
    protected JsProgram program() {
        JsProgram jsProgram = this.context.program();
        if (jsProgram == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/general/AbstractTranslator", "program"));
        }
        return jsProgram;
    }

    @NotNull
    protected TranslationContext context() {
        TranslationContext translationContext = this.context;
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/general/AbstractTranslator", "context"));
        }
        return translationContext;
    }

    @NotNull
    protected BindingContext bindingContext() {
        BindingContext bindingContext = this.context.bindingContext();
        if (bindingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/general/AbstractTranslator", "bindingContext"));
        }
        return bindingContext;
    }
}

