/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.intrinsic.functions.factories;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class KotlinFunctionIntrinsic
extends FunctionIntrinsic {
    @NotNull
    private final JsNameRef function;

    public KotlinFunctionIntrinsic(@NotNull String functionName) {
        if (functionName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/intrinsic/functions/factories/KotlinFunctionIntrinsic", "<init>"));
        }
        this.function = new JsNameRef(functionName, "Kotlin");
    }

    @Override
    @NotNull
    public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments, @NotNull TranslationContext context) {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/intrinsic/functions/factories/KotlinFunctionIntrinsic", "apply"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/k2js/translate/intrinsic/functions/factories/KotlinFunctionIntrinsic", "apply"));
        }
        JsInvocation jsInvocation = new JsInvocation((JsExpression)this.function, receiver == null ? arguments : TranslationUtils.generateInvocationArguments(receiver, arguments));
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/factories/KotlinFunctionIntrinsic", "apply"));
        }
        return jsInvocation;
    }
}

