/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.intrinsic.functions.patterns;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.lang.PrimitiveType;

public final class NamePredicate
implements Predicate<Name> {
    @NotNull
    public static final NamePredicate PRIMITIVE_NUMBERS = new NamePredicate(ContainerUtil.map(PrimitiveType.NUMBER_TYPES, new Function<PrimitiveType, String>(){

        @Override
        public String fun(PrimitiveType type) {
            return type.getTypeName().asString();
        }
    }));
    @NotNull
    public static final NamePredicate STRING = new NamePredicate("String");
    @NotNull
    private final List<Name> validNames;

    public NamePredicate(String ... validNames) {
        if (validNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/NamePredicate", "<init>"));
        }
        this(Arrays.asList(validNames));
    }

    public NamePredicate(@NotNull List<String> validNames) {
        if (validNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/NamePredicate", "<init>"));
        }
        this.validNames = Lists.newArrayList();
        for (String validName : validNames) {
            this.validNames.add(Name.guess(validName));
        }
    }

    public NamePredicate(@NotNull Collection<Name> validNames) {
        if (validNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/NamePredicate", "<init>"));
        }
        this.validNames = Lists.newArrayList();
        this.validNames.addAll(validNames);
    }

    public NamePredicate(Name ... validNames) {
        if (validNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/intrinsic/functions/patterns/NamePredicate", "<init>"));
        }
        this.validNames = Lists.newArrayList();
        this.validNames.addAll(Lists.newArrayList(validNames));
    }

    @Override
    public boolean apply(@Nullable Name name) {
        if (name == null) {
            return false;
        }
        for (Name validName : this.validNames) {
            if (!name.equals(validName)) continue;
            return true;
        }
        return false;
    }
}

