/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.util.ExpressionAsFunctionDescriptor;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.reference.AbstractCallExpressionTranslator;
import org.jetbrains.k2js.translate.reference.CallArgumentTranslator;
import org.jetbrains.k2js.translate.reference.CallBuilder;
import org.jetbrains.k2js.translate.reference.CallType;
import org.jetbrains.k2js.translate.reference.InlinedCallExpressionTranslator;
import org.jetbrains.k2js.translate.reference.ReferenceTranslator;
import org.jetbrains.k2js.translate.utils.AnnotationsUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;

public final class CallExpressionTranslator
extends AbstractCallExpressionTranslator {
    private final boolean isNativeFunctionCall;
    private CallArgumentTranslator.ArgumentsInfo argumentsInfo;
    private JsExpression translatedReceiver;
    private JsExpression translatedCallee;

    @NotNull
    public static JsExpression translate(@NotNull JetCallExpression expression, @Nullable JsExpression receiver, @NotNull CallType callType, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/CallExpressionTranslator", "translate"));
        }
        if (callType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/k2js/translate/reference/CallExpressionTranslator", "translate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/k2js/translate/reference/CallExpressionTranslator", "translate"));
        }
        if (InlinedCallExpressionTranslator.shouldBeInlined(expression, context)) {
            JsExpression jsExpression = InlinedCallExpressionTranslator.translate(expression, receiver, callType, context);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallExpressionTranslator", "translate"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = new CallExpressionTranslator(expression, receiver, callType, context).translate();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallExpressionTranslator", "translate"));
        }
        return jsExpression;
    }

    private CallExpressionTranslator(@NotNull JetCallExpression expression, @Nullable JsExpression receiver, @NotNull CallType callType, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/CallExpressionTranslator", "<init>"));
        }
        if (callType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/k2js/translate/reference/CallExpressionTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/k2js/translate/reference/CallExpressionTranslator", "<init>"));
        }
        super(expression, receiver, callType, context);
        this.argumentsInfo = null;
        this.translatedReceiver = null;
        this.translatedCallee = null;
        this.isNativeFunctionCall = AnnotationsUtils.isNativeObject(this.resolvedCall.getCandidateDescriptor());
    }

    @NotNull
    private JsExpression translate() {
        this.prepareToBuildCall();
        JsExpression jsExpression = CallBuilder.build(this.context()).receiver(this.translatedReceiver).callee(this.translatedCallee).args(this.argumentsInfo.getTranslateArguments()).resolvedCall(this.getResolvedCall()).type(this.callType).translate();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallExpressionTranslator", "translate"));
        }
        return jsExpression;
    }

    private void prepareToBuildCall() {
        this.argumentsInfo = CallArgumentTranslator.translate(this.resolvedCall, this.receiver, this.context());
        this.translatedReceiver = this.getReceiver();
        this.translatedCallee = this.getCalleeExpression();
    }

    @NotNull
    private ResolvedCall<?> getResolvedCall() {
        if (this.resolvedCall instanceof VariableAsFunctionResolvedCall) {
            ResolvedCallWithTrace<FunctionDescriptor> resolvedCallWithTrace = ((VariableAsFunctionResolvedCall)this.resolvedCall).getFunctionCall();
            if (resolvedCallWithTrace == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallExpressionTranslator", "getResolvedCall"));
            }
            return resolvedCallWithTrace;
        }
        ResolvedCall resolvedCall = this.resolvedCall;
        if (resolvedCall == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallExpressionTranslator", "getResolvedCall"));
        }
        return resolvedCall;
    }

    @Nullable
    private JsExpression getReceiver() {
        assert (this.argumentsInfo != null) : "the results of this function depends on the argumentsInfo";
        if (this.receiver == null) {
            return null;
        }
        if (this.argumentsInfo.getCachedReceiver() != null) {
            return this.argumentsInfo.getCachedReceiver().assignmentExpression();
        }
        return this.receiver;
    }

    @Nullable
    private JsExpression getCalleeExpression() {
        assert (this.argumentsInfo != null) : "the results of this function depends on the argumentsInfo";
        if (this.isNativeFunctionCall && this.argumentsInfo.isHasSpreadOperator()) {
            String functionName = this.resolvedCall.getCandidateDescriptor().getOriginal().getName().getIdentifier();
            return new JsNameRef("apply", functionName);
        }
        Object candidateDescriptor = this.resolvedCall.getCandidateDescriptor();
        if (candidateDescriptor instanceof ExpressionAsFunctionDescriptor) {
            return this.translateExpressionAsFunction();
        }
        if (this.resolvedCall instanceof VariableAsFunctionResolvedCall) {
            return this.translateVariableForVariableAsFunctionResolvedCall();
        }
        return null;
    }

    @NotNull
    private JsExpression translateVariableForVariableAsFunctionResolvedCall() {
        JetExpression callee = PsiUtils.getCallee(this.expression);
        if (callee instanceof JetSimpleNameExpression) {
            JsExpression jsExpression = ReferenceTranslator.getAccessTranslator((JetSimpleNameExpression)callee, this.receiver, this.context()).translateAsGet();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallExpressionTranslator", "translateVariableForVariableAsFunctionResolvedCall"));
            }
            return jsExpression;
        }
        assert (this.receiver != null);
        JsExpression jsExpression = Translation.translateAsExpression(callee, this.context());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallExpressionTranslator", "translateVariableForVariableAsFunctionResolvedCall"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression translateExpressionAsFunction() {
        JsExpression jsExpression = Translation.translateAsExpression(PsiUtils.getCallee(this.expression), this.context());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallExpressionTranslator", "translateExpressionAsFunction"));
        }
        return jsExpression;
    }
}

