/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.HasArguments;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsNew;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.util.ExpressionAsFunctionDescriptor;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.k2js.translate.reference.CallParameters;
import org.jetbrains.k2js.translate.reference.CallParametersResolver;
import org.jetbrains.k2js.translate.reference.CallType;
import org.jetbrains.k2js.translate.reference.ReferenceTranslator;
import org.jetbrains.k2js.translate.utils.AnnotationsUtils;
import org.jetbrains.k2js.translate.utils.ErrorReportingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class CallTranslator
extends AbstractTranslator {
    @NotNull
    private final List<JsExpression> arguments;
    @NotNull
    private final ResolvedCall<?> resolvedCall;
    @NotNull
    private final CallableDescriptor descriptor;
    @NotNull
    private final CallType callType;
    @NotNull
    private final CallParameters callParameters;

    CallTranslator(@Nullable JsExpression receiver, @Nullable JsExpression callee, @NotNull List<JsExpression> arguments, @NotNull ResolvedCall<? extends CallableDescriptor> resolvedCall, @NotNull CallableDescriptor descriptorToCall, @NotNull CallType callType, @NotNull TranslationContext context) {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/k2js/translate/reference/CallTranslator", "<init>"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/k2js/translate/reference/CallTranslator", "<init>"));
        }
        if (descriptorToCall == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/k2js/translate/reference/CallTranslator", "<init>"));
        }
        if (callType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "org/jetbrains/k2js/translate/reference/CallTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "org/jetbrains/k2js/translate/reference/CallTranslator", "<init>"));
        }
        super(context);
        this.arguments = arguments;
        this.resolvedCall = resolvedCall;
        this.callType = callType;
        this.descriptor = descriptorToCall;
        this.callParameters = CallParametersResolver.resolveCallParameters(receiver, callee, this.descriptor, resolvedCall, context);
    }

    @NotNull
    public ResolvedCall<? extends CallableDescriptor> getResolvedCall() {
        ResolvedCall<?> resolvedCall = this.resolvedCall;
        if (resolvedCall == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallTranslator", "getResolvedCall"));
        }
        return resolvedCall;
    }

    @NotNull
    public CallParameters getCallParameters() {
        CallParameters callParameters = this.callParameters;
        if (callParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallTranslator", "getCallParameters"));
        }
        return callParameters;
    }

    @NotNull
    JsExpression translate() {
        JsExpression result = this.intrinsicInvocation();
        if (result != null) {
            JsExpression jsExpression = result;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallTranslator", "translate"));
            }
            return jsExpression;
        }
        if (this.descriptor instanceof ConstructorDescriptor) {
            HasArguments hasArguments = this.createConstructorCallExpression(this.translateAsFunctionWithNoThisObject(this.descriptor));
            if (hasArguments == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallTranslator", "translate"));
            }
            return hasArguments;
        }
        if (this.resolvedCall.getReceiverArgument().exists()) {
            if (AnnotationsUtils.isNativeObject(this.descriptor)) {
                JsExpression jsExpression = this.nativeExtensionCall();
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallTranslator", "translate"));
                }
                return jsExpression;
            }
            JsExpression jsExpression = this.extensionFunctionCall(!(this.descriptor instanceof ExpressionAsFunctionDescriptor));
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallTranslator", "translate"));
            }
            return jsExpression;
        }
        if (this.isExpressionAsFunction()) {
            JsExpression jsExpression = this.expressionAsFunctionCall();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallTranslator", "translate"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = this.methodCall(this.getThisObjectOrQualifier());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallTranslator", "translate"));
        }
        return jsExpression;
    }

    private boolean isExpressionAsFunction() {
        return this.descriptor instanceof ExpressionAsFunctionDescriptor || this.resolvedCall instanceof VariableAsFunctionResolvedCall;
    }

    @NotNull
    private JsExpression expressionAsFunctionCall() {
        JsExpression jsExpression = this.methodCall(null);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallTranslator", "expressionAsFunctionCall"));
        }
        return jsExpression;
    }

    @Nullable
    private JsExpression intrinsicInvocation() {
        if (this.descriptor instanceof FunctionDescriptor) {
            try {
                FunctionIntrinsic intrinsic = this.context().intrinsics().getFunctionIntrinsics().getIntrinsic((FunctionDescriptor)this.descriptor);
                if (intrinsic.exists()) {
                    return intrinsic.apply(this, this.arguments, this.context());
                }
            }
            catch (RuntimeException e) {
                throw ErrorReportingUtils.reportErrorWithLocation(e, this.descriptor, this.bindingContext());
            }
        }
        return null;
    }

    @NotNull
    public HasArguments createConstructorCallExpression(@NotNull JsExpression constructorReference) {
        if (constructorReference == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/CallTranslator", "createConstructorCallExpression"));
        }
        JsNew jsNew = new JsNew(constructorReference, this.arguments);
        if (jsNew == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallTranslator", "createConstructorCallExpression"));
        }
        return jsNew;
    }

    @NotNull
    private JsExpression translateAsFunctionWithNoThisObject(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/CallTranslator", "translateAsFunctionWithNoThisObject"));
        }
        JsExpression jsExpression = ReferenceTranslator.translateAsFQReference(descriptor, this.context());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallTranslator", "translateAsFunctionWithNoThisObject"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression nativeExtensionCall() {
        JsExpression jsExpression = this.methodCall(this.callParameters.getReceiver());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallTranslator", "nativeExtensionCall"));
        }
        return jsExpression;
    }

    @NotNull
    public JsExpression explicitInvokeCall() {
        JsExpression jsExpression = this.callType.constructCall(this.callParameters.getThisObject(), new CallType.CallConstructor(){

            @Override
            @NotNull
            public JsExpression construct(@Nullable JsExpression receiver) {
                JsInvocation jsInvocation = new JsInvocation(receiver, CallTranslator.this.arguments);
                if (jsInvocation == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallTranslator$1", "construct"));
                }
                return jsInvocation;
            }
        }, this.context());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallTranslator", "explicitInvokeCall"));
        }
        return jsExpression;
    }

    @NotNull
    public JsExpression extensionFunctionCall(final boolean useThis) {
        JsExpression jsExpression = this.callType.constructCall(this.callParameters.getReceiver(), new CallType.CallConstructor(){

            @Override
            @NotNull
            public JsExpression construct(@Nullable JsExpression receiver) {
                assert (receiver != null) : "Could not be null for extensions";
                JsExpression functionReference = CallTranslator.this.callParameters.getFunctionReference();
                if (useThis) {
                    JsAstUtils.setQualifier(functionReference, CallTranslator.this.getThisObjectOrQualifier());
                }
                JsInvocation jsInvocation = new JsInvocation(CallTranslator.this.callParameters.getFunctionReference(), CallTranslator.this.generateCallArgumentList(receiver));
                if (jsInvocation == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallTranslator$2", "construct"));
                }
                return jsInvocation;
            }
        }, this.context());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallTranslator", "extensionFunctionCall"));
        }
        return jsExpression;
    }

    @NotNull
    private List<JsExpression> generateCallArgumentList(@NotNull JsExpression receiver) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/CallTranslator", "generateCallArgumentList"));
        }
        List<JsExpression> list = TranslationUtils.generateInvocationArguments(receiver, this.arguments);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallTranslator", "generateCallArgumentList"));
        }
        return list;
    }

    @NotNull
    private JsExpression methodCall(@Nullable JsExpression receiver) {
        JsExpression jsExpression = this.callType.constructCall(receiver, new CallType.CallConstructor(){

            @Override
            @NotNull
            public JsExpression construct(@Nullable JsExpression receiver) {
                JsExpression qualifiedCallee = CallTranslator.this.getQualifiedCallee(receiver);
                if (CallTranslator.this.isDirectPropertyAccess()) {
                    JsExpression jsExpression = CallTranslator.this.directPropertyAccess(qualifiedCallee);
                    if (jsExpression == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallTranslator$3", "construct"));
                    }
                    return jsExpression;
                }
                JsInvocation jsInvocation = new JsInvocation(qualifiedCallee, CallTranslator.this.arguments);
                if (jsInvocation == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallTranslator$3", "construct"));
                }
                return jsInvocation;
            }
        }, this.context());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallTranslator", "methodCall"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression directPropertyAccess(@NotNull JsExpression callee) {
        if (callee == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/CallTranslator", "directPropertyAccess"));
        }
        if (this.descriptor instanceof PropertyGetterDescriptor) {
            assert (this.arguments.isEmpty());
            JsExpression jsExpression = callee;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallTranslator", "directPropertyAccess"));
            }
            return jsExpression;
        }
        assert (this.descriptor instanceof PropertySetterDescriptor);
        assert (this.arguments.size() == 1);
        JsExpression jsExpression = JsAstUtils.assignment(callee, this.arguments.get(0));
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallTranslator", "directPropertyAccess"));
        }
        return jsExpression;
    }

    private boolean isDirectPropertyAccess() {
        return this.descriptor instanceof PropertyAccessorDescriptor;
    }

    @NotNull
    private JsExpression getQualifiedCallee(@Nullable JsExpression receiver) {
        JsExpression callee = this.callParameters.getFunctionReference();
        if (receiver != null) {
            JsAstUtils.setQualifier(callee, receiver);
        }
        JsExpression jsExpression = callee;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallTranslator", "getQualifiedCallee"));
        }
        return jsExpression;
    }

    @Nullable
    private JsExpression getThisObjectOrQualifier() {
        JsExpression thisObject = this.callParameters.getThisObject();
        if (thisObject != null) {
            return thisObject;
        }
        return this.context().getQualifierForDescriptor(this.descriptor);
    }
}

