/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils;

import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptorForObject;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetOperationExpression;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.k2js.translate.utils.ErrorReportingUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;

public final class BindingUtils {
    private BindingUtils() {
    }

    @NotNull
    private static <E extends PsiElement, D extends DeclarationDescriptor> D getDescriptorForExpression(@NotNull BindingContext context, @NotNull E expression, Class<D> descriptorClass) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/BindingUtils", "getDescriptorForExpression"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/BindingUtils", "getDescriptorForExpression"));
        }
        DeclarationDescriptor descriptor = context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, expression);
        assert (descriptor != null);
        assert (descriptorClass.isInstance(descriptor)) : ErrorReportingUtils.message(expression, ((Object)expression).toString() + " expected to have of type" + descriptorClass.toString());
        DeclarationDescriptor declarationDescriptor = descriptor;
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/BindingUtils", "getDescriptorForExpression"));
        }
        return (D)declarationDescriptor;
    }

    @NotNull
    public static ClassDescriptor getClassDescriptor(@NotNull BindingContext context, @NotNull JetClassOrObject declaration) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/BindingUtils", "getClassDescriptor"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/BindingUtils", "getClassDescriptor"));
        }
        ClassDescriptor classDescriptor = BindingContextUtils.getNotNull(context, BindingContext.CLASS, declaration);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/BindingUtils", "getClassDescriptor"));
        }
        return classDescriptor;
    }

    @NotNull
    public static FunctionDescriptor getFunctionDescriptor(@NotNull BindingContext context, @NotNull JetDeclarationWithBody declaration) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/BindingUtils", "getFunctionDescriptor"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/BindingUtils", "getFunctionDescriptor"));
        }
        FunctionDescriptor functionDescriptor = BindingUtils.getDescriptorForExpression(context, declaration, FunctionDescriptor.class);
        if (functionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/BindingUtils", "getFunctionDescriptor"));
        }
        return functionDescriptor;
    }

    @NotNull
    public static PropertyDescriptor getPropertyDescriptor(@NotNull BindingContext context, @NotNull JetProperty declaration) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/BindingUtils", "getPropertyDescriptor"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/BindingUtils", "getPropertyDescriptor"));
        }
        PropertyDescriptor propertyDescriptor = BindingUtils.getDescriptorForExpression(context, declaration, PropertyDescriptor.class);
        if (propertyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/BindingUtils", "getPropertyDescriptor"));
        }
        return propertyDescriptor;
    }

    @NotNull
    public static JetFunction getFunctionForDescriptor(@NotNull BindingContext context, @NotNull SimpleFunctionDescriptor descriptor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/BindingUtils", "getFunctionForDescriptor"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/BindingUtils", "getFunctionForDescriptor"));
        }
        PsiElement result = BindingContextUtils.callableDescriptorToDeclaration(context, descriptor);
        assert (result instanceof JetFunction) : ErrorReportingUtils.message(context, descriptor, "SimpleFunctionDescriptor should have declaration of type JetFunction");
        JetFunction jetFunction = (JetFunction)result;
        if (jetFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/BindingUtils", "getFunctionForDescriptor"));
        }
        return jetFunction;
    }

    @NotNull
    private static JetParameter getParameterForDescriptor(@NotNull BindingContext context, @NotNull ValueParameterDescriptor descriptor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/BindingUtils", "getParameterForDescriptor"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/BindingUtils", "getParameterForDescriptor"));
        }
        PsiElement result = BindingContextUtils.descriptorToDeclaration(context, descriptor);
        assert (result instanceof JetParameter) : ErrorReportingUtils.message(context, descriptor, "ValueParameterDescriptor should have corresponding JetParameter");
        JetParameter jetParameter = (JetParameter)result;
        if (jetParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/BindingUtils", "getParameterForDescriptor"));
        }
        return jetParameter;
    }

    public static boolean hasAncestorClass(@NotNull BindingContext context, @NotNull JetClassOrObject classDeclaration) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/BindingUtils", "hasAncestorClass"));
        }
        if (classDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/BindingUtils", "hasAncestorClass"));
        }
        ClassDescriptor classDescriptor = BindingUtils.getClassDescriptor(context, classDeclaration);
        List<ClassDescriptor> superclassDescriptors = DescriptorUtils.getSuperclassDescriptors(classDescriptor);
        return JsDescriptorUtils.findAncestorClass(superclassDescriptors) != null;
    }

    public static boolean isStatement(@NotNull BindingContext context, @NotNull JetExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/BindingUtils", "isStatement"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/BindingUtils", "isStatement"));
        }
        return BindingContextUtils.getNotNull(context, BindingContext.STATEMENT, expression);
    }

    @NotNull
    public static JetType getTypeByReference(@NotNull BindingContext context, @NotNull JetTypeReference typeReference) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/BindingUtils", "getTypeByReference"));
        }
        if (typeReference == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/BindingUtils", "getTypeByReference"));
        }
        JetType jetType = BindingContextUtils.getNotNull(context, BindingContext.TYPE, typeReference);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/BindingUtils", "getTypeByReference"));
        }
        return jetType;
    }

    @NotNull
    public static ClassDescriptor getClassDescriptorForTypeReference(@NotNull BindingContext context, @NotNull JetTypeReference typeReference) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/BindingUtils", "getClassDescriptorForTypeReference"));
        }
        if (typeReference == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/BindingUtils", "getClassDescriptorForTypeReference"));
        }
        ClassDescriptor classDescriptor = DescriptorUtils.getClassDescriptorForType(BindingUtils.getTypeByReference(context, typeReference));
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/BindingUtils", "getClassDescriptorForTypeReference"));
        }
        return classDescriptor;
    }

    @Nullable
    public static PropertyDescriptor getPropertyDescriptorForConstructorParameter(@NotNull BindingContext context, @NotNull JetParameter parameter) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/BindingUtils", "getPropertyDescriptorForConstructorParameter"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/BindingUtils", "getPropertyDescriptorForConstructorParameter"));
        }
        return context.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
    }

    @Nullable
    public static DeclarationDescriptor getDescriptorForReferenceExpression(@NotNull BindingContext context, @NotNull JetReferenceExpression reference) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/BindingUtils", "getDescriptorForReferenceExpression"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/BindingUtils", "getDescriptorForReferenceExpression"));
        }
        if (BindingContextUtils.isExpressionWithValidReference(reference, context)) {
            return BindingContextUtils.getNotNull(context, BindingContext.REFERENCE_TARGET, reference);
        }
        return null;
    }

    @Nullable
    public static DeclarationDescriptor getNullableDescriptorForReferenceExpression(@NotNull BindingContext context, @NotNull JetReferenceExpression reference) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/BindingUtils", "getNullableDescriptorForReferenceExpression"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/BindingUtils", "getNullableDescriptorForReferenceExpression"));
        }
        return context.get(BindingContext.REFERENCE_TARGET, reference);
    }

    @NotNull
    public static ResolvedCall<?> getResolvedCall(@NotNull BindingContext context, @NotNull JetExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/BindingUtils", "getResolvedCall"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/BindingUtils", "getResolvedCall"));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall = context.get(BindingContext.RESOLVED_CALL, expression);
        assert (resolvedCall != null) : ErrorReportingUtils.message(expression, expression.getText() + " must resolve to a call");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = resolvedCall;
        if (resolvedCall2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/BindingUtils", "getResolvedCall"));
        }
        return resolvedCall2;
    }

    @NotNull
    public static ResolvedCall<?> getResolvedCallForProperty(@NotNull BindingContext context, @NotNull JetExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/BindingUtils", "getResolvedCallForProperty"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/BindingUtils", "getResolvedCallForProperty"));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall = context.get(BindingContext.RESOLVED_CALL, expression);
        assert (resolvedCall != null) : ErrorReportingUtils.message(expression, expression.getText() + "must resolve to a call");
        if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
            ResolvedCallWithTrace<VariableDescriptor> resolvedCallWithTrace = ((VariableAsFunctionResolvedCall)resolvedCall).getVariableCall();
            if (resolvedCallWithTrace == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/BindingUtils", "getResolvedCallForProperty"));
            }
            return resolvedCallWithTrace;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = resolvedCall;
        if (resolvedCall2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/BindingUtils", "getResolvedCallForProperty"));
        }
        return resolvedCall2;
    }

    @NotNull
    public static ResolvedCall<?> getResolvedCallForCallExpression(@NotNull BindingContext context, @NotNull JetCallExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/BindingUtils", "getResolvedCallForCallExpression"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/BindingUtils", "getResolvedCallForCallExpression"));
        }
        JetExpression calleeExpression = PsiUtils.getCallee(expression);
        ResolvedCall<?> resolvedCall = BindingUtils.getResolvedCall(context, calleeExpression);
        if (resolvedCall == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/BindingUtils", "getResolvedCallForCallExpression"));
        }
        return resolvedCall;
    }

    public static boolean isVariableReassignment(@NotNull BindingContext context, @NotNull JetExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/BindingUtils", "isVariableReassignment"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/BindingUtils", "isVariableReassignment"));
        }
        return BindingContextUtils.getNotNull(context, BindingContext.VARIABLE_REASSIGNMENT, expression);
    }

    @Nullable
    public static FunctionDescriptor getFunctionDescriptorForOperationExpression(@NotNull BindingContext context, @NotNull JetOperationExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/BindingUtils", "getFunctionDescriptorForOperationExpression"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/BindingUtils", "getFunctionDescriptorForOperationExpression"));
        }
        DeclarationDescriptor descriptorForReferenceExpression = BindingUtils.getNullableDescriptorForReferenceExpression(context, expression.getOperationReference());
        if (descriptorForReferenceExpression == null) {
            return null;
        }
        assert (descriptorForReferenceExpression instanceof FunctionDescriptor) : ErrorReportingUtils.message(expression.getOperationReference(), "Operation should resolve to function descriptor");
        return (FunctionDescriptor)descriptorForReferenceExpression;
    }

    @NotNull
    public static DeclarationDescriptor getDescriptorForElement(@NotNull BindingContext context, @NotNull PsiElement element) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/BindingUtils", "getDescriptorForElement"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/BindingUtils", "getDescriptorForElement"));
        }
        DeclarationDescriptor declarationDescriptor = BindingContextUtils.getNotNull(context, BindingContext.DECLARATION_TO_DESCRIPTOR, element);
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/BindingUtils", "getDescriptorForElement"));
        }
        return declarationDescriptor;
    }

    @Nullable
    public static Object getCompileTimeValue(@NotNull BindingContext context, @NotNull JetExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/BindingUtils", "getCompileTimeValue"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/BindingUtils", "getCompileTimeValue"));
        }
        CompileTimeConstant<?> compileTimeValue = context.get(BindingContext.COMPILE_TIME_VALUE, expression);
        if (compileTimeValue != null) {
            return compileTimeValue.getValue();
        }
        return null;
    }

    @NotNull
    public static JetExpression getDefaultArgument(@NotNull BindingContext context, @NotNull ValueParameterDescriptor parameterDescriptor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/BindingUtils", "getDefaultArgument"));
        }
        if (parameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/BindingUtils", "getDefaultArgument"));
        }
        ValueParameterDescriptor descriptorWhichDeclaresDefaultValue = BindingUtils.getOriginalDescriptorWhichDeclaresDefaultValue(context, parameterDescriptor);
        JetParameter psiParameter = BindingUtils.getParameterForDescriptor(context, descriptorWhichDeclaresDefaultValue);
        JetExpression defaultValue = psiParameter.getDefaultValue();
        assert (defaultValue != null) : ErrorReportingUtils.message(context, parameterDescriptor, "No default value found in PSI");
        JetExpression jetExpression = defaultValue;
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/BindingUtils", "getDefaultArgument"));
        }
        return jetExpression;
    }

    private static ValueParameterDescriptor getOriginalDescriptorWhichDeclaresDefaultValue(BindingContext context, @NotNull ValueParameterDescriptor parameterDescriptor) {
        if (parameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/BindingUtils", "getOriginalDescriptorWhichDeclaresDefaultValue"));
        }
        ValueParameterDescriptor result = parameterDescriptor;
        assert (result.hasDefaultValue()) : ErrorReportingUtils.message(context, parameterDescriptor, "Unsupplied parameter must have default value");
        while (!result.declaresDefaultValue()) {
            result = result.getOverriddenDescriptors().iterator().next();
        }
        return result;
    }

    @NotNull
    public static ResolvedCall<FunctionDescriptor> getIteratorFunction(@NotNull BindingContext context, @NotNull JetExpression rangeExpression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/BindingUtils", "getIteratorFunction"));
        }
        if (rangeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/BindingUtils", "getIteratorFunction"));
        }
        ResolvedCall<FunctionDescriptor> resolvedCall = BindingContextUtils.getNotNull(context, BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, rangeExpression);
        if (resolvedCall == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/BindingUtils", "getIteratorFunction"));
        }
        return resolvedCall;
    }

    @NotNull
    public static ResolvedCall<FunctionDescriptor> getNextFunction(@NotNull BindingContext context, @NotNull JetExpression rangeExpression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/BindingUtils", "getNextFunction"));
        }
        if (rangeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/BindingUtils", "getNextFunction"));
        }
        ResolvedCall<FunctionDescriptor> resolvedCall = BindingContextUtils.getNotNull(context, BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL, rangeExpression);
        if (resolvedCall == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/BindingUtils", "getNextFunction"));
        }
        return resolvedCall;
    }

    @NotNull
    public static ResolvedCall<FunctionDescriptor> getHasNextCallable(@NotNull BindingContext context, @NotNull JetExpression rangeExpression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/BindingUtils", "getHasNextCallable"));
        }
        if (rangeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/BindingUtils", "getHasNextCallable"));
        }
        ResolvedCall<FunctionDescriptor> resolvedCall = BindingContextUtils.getNotNull(context, BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL, rangeExpression);
        if (resolvedCall == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/BindingUtils", "getHasNextCallable"));
        }
        return resolvedCall;
    }

    @NotNull
    public static JetType getTypeForExpression(@NotNull BindingContext context, @NotNull JetExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/BindingUtils", "getTypeForExpression"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/BindingUtils", "getTypeForExpression"));
        }
        JetType jetType = BindingContextUtils.getNotNull(context, BindingContext.EXPRESSION_TYPE, expression);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/BindingUtils", "getTypeForExpression"));
        }
        return jetType;
    }

    @NotNull
    public static ResolvedCall<FunctionDescriptor> getResolvedCallForArrayAccess(@NotNull BindingContext context, @NotNull JetArrayAccessExpression arrayAccessExpression, boolean isGet) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/BindingUtils", "getResolvedCallForArrayAccess"));
        }
        if (arrayAccessExpression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/BindingUtils", "getResolvedCallForArrayAccess"));
        }
        ResolvedCall<FunctionDescriptor> resolvedCall = BindingContextUtils.getNotNull(context, isGet ? BindingContext.INDEXED_LVALUE_GET : BindingContext.INDEXED_LVALUE_SET, arrayAccessExpression);
        if (resolvedCall == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/BindingUtils", "getResolvedCallForArrayAccess"));
        }
        return resolvedCall;
    }

    public static ConstructorDescriptor getConstructor(@NotNull BindingContext bindingContext, @NotNull JetClassOrObject declaration) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/BindingUtils", "getConstructor"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/BindingUtils", "getConstructor"));
        }
        ConstructorDescriptor primaryConstructor = BindingUtils.getClassDescriptor(bindingContext, declaration).getUnsubstitutedPrimaryConstructor();
        assert (primaryConstructor != null) : ErrorReportingUtils.message(declaration, "Traits do not have initialize methods");
        return primaryConstructor;
    }

    @Nullable
    public static SimpleFunctionDescriptor getNullableDescriptorForFunction(@NotNull BindingContext bindingContext, @NotNull JetNamedFunction function) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/BindingUtils", "getNullableDescriptorForFunction"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/BindingUtils", "getNullableDescriptorForFunction"));
        }
        return bindingContext.get(BindingContext.FUNCTION, function);
    }

    public static boolean isObjectDeclaration(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/BindingUtils", "isObjectDeclaration"));
        }
        return propertyDescriptor instanceof VariableDescriptorForObject;
    }
}

