/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsReturn;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.mutator.LastExpressionMutator;
import org.jetbrains.k2js.translate.utils.mutator.Mutator;

public final class FunctionBodyTranslator
extends AbstractTranslator {
    @NotNull
    private final FunctionDescriptor descriptor;
    @NotNull
    private final JetDeclarationWithBody declaration;

    @NotNull
    public static JsBlock translateFunctionBody(@NotNull FunctionDescriptor descriptor, @NotNull JetDeclarationWithBody declarationWithBody, @NotNull TranslationContext functionBodyContext) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator", "translateFunctionBody"));
        }
        if (declarationWithBody == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator", "translateFunctionBody"));
        }
        if (functionBodyContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator", "translateFunctionBody"));
        }
        JsBlock jsBlock = new FunctionBodyTranslator(descriptor, declarationWithBody, functionBodyContext).translate();
        if (jsBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator", "translateFunctionBody"));
        }
        return jsBlock;
    }

    private FunctionBodyTranslator(@NotNull FunctionDescriptor descriptor, @NotNull JetDeclarationWithBody declaration, @NotNull TranslationContext context) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator", "<init>"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator", "<init>"));
        }
        super(context);
        this.descriptor = descriptor;
        this.declaration = declaration;
    }

    @NotNull
    private JsBlock translate() {
        JetExpression jetBodyExpression = this.declaration.getBodyExpression();
        assert (jetBodyExpression != null) : "Cannot translate a body of an abstract function.";
        JsBlock jsBlock = this.mayBeWrapWithReturn(Translation.translateExpression(jetBodyExpression, this.context()));
        if (jsBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator", "translate"));
        }
        return jsBlock;
    }

    @NotNull
    private JsBlock mayBeWrapWithReturn(@NotNull JsNode body) {
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator", "mayBeWrapWithReturn"));
        }
        if (!this.mustAddReturnToGeneratedFunctionBody()) {
            JsBlock jsBlock = JsAstUtils.convertToBlock(body);
            if (jsBlock == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator", "mayBeWrapWithReturn"));
            }
            return jsBlock;
        }
        JsBlock jsBlock = JsAstUtils.convertToBlock(FunctionBodyTranslator.lastExpressionReturned(body));
        if (jsBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator", "mayBeWrapWithReturn"));
        }
        return jsBlock;
    }

    private boolean mustAddReturnToGeneratedFunctionBody() {
        JetType functionReturnType = this.descriptor.getReturnType();
        assert (functionReturnType != null) : "Function return typed type must be resolved.";
        return !this.declaration.hasBlockBody() && !KotlinBuiltIns.getInstance().isUnit(functionReturnType);
    }

    @NotNull
    private static JsNode lastExpressionReturned(@NotNull JsNode body) {
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator", "lastExpressionReturned"));
        }
        JsStatement jsStatement = LastExpressionMutator.mutateLastExpression(body, new Mutator(){

            @Override
            @NotNull
            public JsNode mutate(@NotNull JsNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator$1", "mutate"));
                }
                if (!(node instanceof JsExpression)) {
                    JsNode jsNode = node;
                    if (jsNode == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator$1", "mutate"));
                    }
                    return jsNode;
                }
                JsReturn jsReturn = new JsReturn((JsExpression)node);
                if (jsReturn == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator$1", "mutate"));
                }
                return jsReturn;
            }
        });
        if (jsStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator", "lastExpressionReturned"));
        }
        return jsStatement;
    }
}

