/* The following code was generated by JFlex 1.4.3 on 25.05.13 15:08 */

package org.jetbrains.jet.lexer;

import com.intellij.lexer.FlexLexer;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.3
 * on 25.05.13 15:08 from the specification file
 * <tt>/Users/factitious/Documents/kotlin/compiler/frontend/src/org/jetbrains/jet/lexer/Jet.flex</tt>
 */
class _JetLexer implements FlexLexer {
  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int STRING = 2;
  public static final int BLOCK_COMMENT = 8;
  public static final int YYINITIAL = 0;
  public static final int LONG_TEMPLATE_ENTRY = 12;
  public static final int DOC_COMMENT = 10;
  public static final int RAW_STRING = 4;
  public static final int SHORT_TEMPLATE_ENTRY = 6;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  4,  4,  5, 5
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\3\1\7\1\0\1\3\23\0\1\3\1\14\1\26\1\13"+
    "\1\10\1\70\1\66\1\24\1\74\1\75\1\36\1\65\1\77\1\22"+
    "\1\20\1\12\1\15\11\1\1\71\1\76\1\61\1\63\1\62\1\64"+
    "\1\11\1\2\1\17\2\2\1\21\1\2\11\4\1\23\3\4\1\56"+
    "\3\4\1\16\2\4\1\72\1\25\1\73\1\0\1\4\1\6\1\44"+
    "\1\50\1\37\1\60\1\42\1\54\1\46\1\33\1\34\1\51\1\45"+
    "\1\53\1\4\1\41\1\40\1\43\1\4\1\47\1\35\1\32\1\27"+
    "\1\57\1\52\1\16\1\55\1\4\1\30\1\67\1\31\54\0\1\4"+
    "\12\0\1\4\4\0\1\4\5\0\27\4\1\0\37\4\1\0\u013f\4"+
    "\31\0\162\4\4\0\14\4\16\0\5\4\11\0\1\4\213\0\1\4"+
    "\13\0\1\4\1\0\3\4\1\0\1\4\1\0\24\4\1\0\54\4"+
    "\1\0\46\4\1\0\5\4\4\0\202\4\10\0\105\4\1\0\46\4"+
    "\2\0\2\4\6\0\20\4\41\0\46\4\2\0\1\4\7\0\47\4"+
    "\110\0\33\4\5\0\3\4\56\0\32\4\5\0\13\4\25\0\12\5"+
    "\4\0\2\4\1\0\143\4\1\0\1\4\17\0\2\4\7\0\2\4"+
    "\12\5\3\4\2\0\1\4\20\0\1\4\1\0\36\4\35\0\3\4"+
    "\60\0\46\4\13\0\1\4\u0152\0\66\4\3\0\1\4\22\0\1\4"+
    "\7\0\12\4\4\0\12\5\25\0\10\4\2\0\2\4\2\0\26\4"+
    "\1\0\7\4\1\0\1\4\3\0\4\4\3\0\1\4\36\0\2\4"+
    "\1\0\3\4\4\0\12\5\2\4\23\0\6\4\4\0\2\4\2\0"+
    "\26\4\1\0\7\4\1\0\2\4\1\0\2\4\1\0\2\4\37\0"+
    "\4\4\1\0\1\4\7\0\12\5\2\0\3\4\20\0\11\4\1\0"+
    "\3\4\1\0\26\4\1\0\7\4\1\0\2\4\1\0\5\4\3\0"+
    "\1\4\22\0\1\4\17\0\2\4\4\0\12\5\25\0\10\4\2\0"+
    "\2\4\2\0\26\4\1\0\7\4\1\0\2\4\1\0\5\4\3\0"+
    "\1\4\36\0\2\4\1\0\3\4\4\0\12\5\1\0\1\4\21\0"+
    "\1\4\1\0\6\4\3\0\3\4\1\0\4\4\3\0\2\4\1\0"+
    "\1\4\1\0\2\4\3\0\2\4\3\0\3\4\3\0\10\4\1\0"+
    "\3\4\55\0\11\5\25\0\10\4\1\0\3\4\1\0\27\4\1\0"+
    "\12\4\1\0\5\4\46\0\2\4\4\0\12\5\25\0\10\4\1\0"+
    "\3\4\1\0\27\4\1\0\12\4\1\0\5\4\3\0\1\4\40\0"+
    "\1\4\1\0\2\4\4\0\12\5\25\0\10\4\1\0\3\4\1\0"+
    "\27\4\1\0\20\4\46\0\2\4\4\0\12\5\25\0\22\4\3\0"+
    "\30\4\1\0\11\4\1\0\1\4\2\0\7\4\72\0\60\4\1\0"+
    "\2\4\14\0\7\4\11\0\12\5\47\0\2\4\1\0\1\4\2\0"+
    "\2\4\1\0\1\4\2\0\1\4\6\0\4\4\1\0\7\4\1\0"+
    "\3\4\1\0\1\4\1\0\1\4\2\0\2\4\1\0\4\4\1\0"+
    "\2\4\11\0\1\4\2\0\5\4\1\0\1\4\11\0\12\5\2\0"+
    "\2\4\42\0\1\4\37\0\12\5\26\0\10\4\1\0\42\4\35\0"+
    "\4\4\164\0\42\4\1\0\5\4\1\0\2\4\25\0\12\5\6\0"+
    "\6\4\112\0\46\4\12\0\51\4\7\0\132\4\5\0\104\4\5\0"+
    "\122\4\6\0\7\4\1\0\77\4\1\0\1\4\1\0\4\4\2\0"+
    "\7\4\1\0\1\4\1\0\4\4\2\0\47\4\1\0\1\4\1\0"+
    "\4\4\2\0\37\4\1\0\1\4\1\0\4\4\2\0\7\4\1\0"+
    "\1\4\1\0\4\4\2\0\7\4\1\0\7\4\1\0\27\4\1\0"+
    "\37\4\1\0\1\4\1\0\4\4\2\0\7\4\1\0\47\4\1\0"+
    "\23\4\16\0\11\5\56\0\125\4\14\0\u026c\4\2\0\10\4\12\0"+
    "\32\4\5\0\113\4\25\0\15\4\1\0\4\4\16\0\22\4\16\0"+
    "\22\4\16\0\15\4\1\0\3\4\17\0\64\4\43\0\1\4\4\0"+
    "\1\4\3\0\12\5\46\0\12\5\6\0\130\4\10\0\51\4\127\0"+
    "\35\4\51\0\12\5\36\4\2\0\5\4\u038b\0\154\4\224\0\234\4"+
    "\4\0\132\4\6\0\26\4\2\0\6\4\2\0\46\4\2\0\6\4"+
    "\2\0\10\4\1\0\1\4\1\0\1\4\1\0\1\4\1\0\37\4"+
    "\2\0\65\4\1\0\7\4\1\0\1\4\3\0\3\4\1\0\7\4"+
    "\3\0\4\4\2\0\6\4\4\0\15\4\5\0\3\4\1\0\7\4"+
    "\164\0\1\4\15\0\1\4\202\0\1\4\4\0\1\4\2\0\12\4"+
    "\1\0\1\4\3\0\5\4\6\0\1\4\1\0\1\4\1\0\1\4"+
    "\1\0\4\4\1\0\3\4\1\0\7\4\3\0\3\4\5\0\5\4"+
    "\u0ebb\0\2\4\52\0\5\4\5\0\2\4\4\0\126\4\6\0\3\4"+
    "\1\0\132\4\1\0\4\4\5\0\50\4\4\0\136\4\21\0\30\4"+
    "\70\0\20\4\u0200\0\u19b6\4\112\0\u51a6\4\132\0\u048d\4\u0773\0\u2ba4\4"+
    "\u215c\0\u012e\4\2\0\73\4\225\0\7\4\14\0\5\4\5\0\1\4"+
    "\1\0\12\4\1\0\15\4\1\0\5\4\1\0\1\4\1\0\2\4"+
    "\1\0\2\4\1\0\154\4\41\0\u016b\4\22\0\100\4\2\0\66\4"+
    "\50\0\14\4\164\0\5\4\1\0\207\4\23\0\12\5\7\0\32\4"+
    "\6\0\32\4\13\0\131\4\3\0\6\4\2\0\6\4\2\0\6\4"+
    "\2\0\3\4\43\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\6\0\1\1\1\2\1\3\1\4\2\1\1\5\1\6"+
    "\1\7\1\10\1\2\1\11\1\12\1\13\1\14\1\15"+
    "\1\16\3\3\1\17\15\3\1\20\1\21\1\22\1\23"+
    "\1\24\2\1\1\25\1\26\1\27\1\30\1\31\1\32"+
    "\1\33\1\34\1\35\1\36\1\35\1\0\1\37\2\35"+
    "\1\40\1\0\1\40\3\41\1\42\1\43\1\0\1\44"+
    "\1\0\1\45\1\0\1\46\1\0\1\47\1\50\1\51"+
    "\1\52\1\53\1\0\1\54\1\44\2\2\1\44\1\55"+
    "\1\56\1\57\1\60\2\13\1\0\3\3\1\61\1\62"+
    "\1\63\1\3\1\64\6\3\1\65\10\3\1\66\1\0"+
    "\1\67\1\0\1\70\1\71\1\72\1\73\1\74\1\75"+
    "\1\76\1\77\1\100\1\101\1\0\1\102\2\103\2\0"+
    "\1\40\1\104\1\105\1\106\1\44\1\3\2\0\1\107"+
    "\1\110\1\111\1\112\4\0\1\113\4\3\1\114\10\3"+
    "\1\115\4\3\1\116\1\117\2\3\1\120\1\121\1\122"+
    "\1\123\1\124\2\0\2\40\1\45\1\46\1\125\1\126"+
    "\1\44\1\0\1\127\1\3\1\130\1\3\1\131\4\3"+
    "\1\132\1\133\4\3\1\134\1\3\1\135\1\101\1\0"+
    "\1\136\1\137\1\140\1\141\1\3\1\142\3\3\1\143"+
    "\1\144\1\145\1\0\1\3\1\146\1\3\1\147\1\3"+
    "\1\150\1\151";

  private static int [] zzUnpackAction() {
    int [] result = new int[232];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\100\0\200\0\300\0\u0100\0\u0140\0\u0180\0\u01c0"+
    "\0\u0200\0\u0240\0\u0280\0\u02c0\0\u0300\0\u0340\0\u0380\0\u03c0"+
    "\0\u0400\0\u0440\0\u0480\0\u04c0\0\u0500\0\u0180\0\u0180\0\u0540"+
    "\0\u0580\0\u05c0\0\u0600\0\u0640\0\u0680\0\u06c0\0\u0700\0\u0740"+
    "\0\u0780\0\u07c0\0\u0800\0\u0840\0\u0880\0\u08c0\0\u0900\0\u0940"+
    "\0\u0980\0\u09c0\0\u0a00\0\u0180\0\u0a40\0\u0a80\0\u0ac0\0\u0b00"+
    "\0\u0b40\0\u0180\0\u0180\0\u0180\0\u0180\0\u0180\0\u0180\0\u0b80"+
    "\0\u0180\0\u0bc0\0\u0c00\0\u0180\0\u0180\0\u0c40\0\u0c80\0\u0cc0"+
    "\0\u0d00\0\u0180\0\u0d40\0\u0d80\0\u0180\0\u0180\0\u0dc0\0\u0e00"+
    "\0\u0e40\0\u0e80\0\u0ec0\0\u0f00\0\u0f40\0\u0180\0\u0f80\0\u0fc0"+
    "\0\u0180\0\u1000\0\u1040\0\u1080\0\u10c0\0\u1100\0\u1140\0\u1180"+
    "\0\u0180\0\u0180\0\u0180\0\u0180\0\u0180\0\u11c0\0\u1200\0\u1240"+
    "\0\u1280\0\u12c0\0\u0200\0\u0200\0\u0200\0\u1300\0\u0180\0\u1340"+
    "\0\u1380\0\u13c0\0\u1400\0\u1440\0\u1480\0\u14c0\0\u1500\0\u1540"+
    "\0\u1580\0\u15c0\0\u1600\0\u1640\0\u1680\0\u16c0\0\u0200\0\u1700"+
    "\0\u0180\0\u1740\0\u0180\0\u0180\0\u1780\0\u0180\0\u0180\0\u0180"+
    "\0\u0180\0\u0180\0\u0180\0\u17c0\0\u1800\0\u0180\0\u0180\0\u1840"+
    "\0\u1880\0\u18c0\0\u1900\0\u0180\0\u0180\0\u0180\0\u1940\0\u0180"+
    "\0\u1980\0\u19c0\0\u1a00\0\u1a40\0\u1a40\0\u0180\0\u1a80\0\u1ac0"+
    "\0\u1b00\0\u1b40\0\u0180\0\u1b80\0\u1bc0\0\u1c00\0\u1c40\0\u0200"+
    "\0\u1c80\0\u1cc0\0\u1d00\0\u1d40\0\u1d80\0\u1dc0\0\u1e00\0\u1e40"+
    "\0\u0180\0\u1e80\0\u1ec0\0\u1f00\0\u1f40\0\u0200\0\u0200\0\u1f80"+
    "\0\u1fc0\0\u0200\0\u0200\0\u0180\0\u0180\0\u0180\0\u2000\0\u2040"+
    "\0\u0180\0\u2080\0\u0180\0\u0180\0\u0180\0\u0180\0\u20c0\0\u1940"+
    "\0\u0200\0\u2100\0\u0200\0\u2140\0\u0200\0\u2180\0\u21c0\0\u2200"+
    "\0\u2240\0\u0200\0\u0200\0\u2280\0\u22c0\0\u2300\0\u2340\0\u0200"+
    "\0\u2380\0\u0200\0\u0180\0\u23c0\0\u0c80\0\u0200\0\u0200\0\u0200"+
    "\0\u2400\0\u0200\0\u2440\0\u2480\0\u24c0\0\u0200\0\u0200\0\u0200"+
    "\0\u2500\0\u2540\0\u0200\0\u2580\0\u0200\0\u25c0\0\u0200\0\u0200";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[232];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\7\1\10\1\11\1\12\1\11\1\7\1\13\1\12"+
    "\1\14\1\15\1\16\1\17\1\20\1\21\2\11\1\22"+
    "\1\11\1\23\1\11\1\24\1\7\1\25\1\11\1\26"+
    "\1\27\1\30\1\11\1\31\1\32\1\33\1\34\1\35"+
    "\1\36\1\37\1\40\1\41\2\11\1\42\1\43\1\11"+
    "\1\44\1\11\1\45\1\11\1\46\1\47\1\50\1\51"+
    "\1\52\1\53\1\54\1\55\1\56\1\57\1\60\1\61"+
    "\1\62\1\63\1\64\1\65\1\66\1\67\7\70\1\71"+
    "\1\72\14\70\1\73\1\74\60\70\1\75\1\72\14\70"+
    "\1\75\1\76\51\70\2\0\1\77\1\0\1\77\1\0"+
    "\1\100\7\0\2\77\1\0\1\77\1\0\1\77\3\0"+
    "\1\77\2\0\1\101\3\77\1\0\22\77\17\0\12\102"+
    "\1\103\23\102\1\104\41\102\1\7\1\10\1\11\1\12"+
    "\1\11\1\7\1\13\1\12\1\14\1\15\1\16\1\17"+
    "\1\20\1\21\2\11\1\22\1\11\1\23\1\11\1\24"+
    "\1\7\1\25\1\11\1\105\1\106\1\30\1\11\1\31"+
    "\1\32\1\33\1\34\1\35\1\36\1\37\1\40\1\41"+
    "\2\11\1\42\1\43\1\11\1\44\1\11\1\45\1\11"+
    "\1\46\1\47\1\50\1\51\1\52\1\53\1\54\1\55"+
    "\1\56\1\57\1\60\1\61\1\62\1\63\1\64\1\65"+
    "\1\66\1\67\101\0\1\10\13\0\1\10\2\0\1\107"+
    "\1\110\20\0\1\110\36\0\2\11\1\0\2\11\7\0"+
    "\3\11\1\0\1\11\1\0\1\11\3\0\1\11\2\0"+
    "\4\11\1\0\22\11\22\0\1\12\3\0\1\12\70\0"+
    "\6\111\2\0\70\111\2\0\1\112\1\0\1\112\1\0"+
    "\1\113\7\0\2\112\1\0\1\112\1\0\1\112\3\0"+
    "\1\112\2\0\4\112\1\0\22\112\21\0\1\114\1\0"+
    "\1\114\1\0\1\115\2\0\1\116\4\0\2\114\1\0"+
    "\1\114\1\0\1\114\3\0\1\114\2\0\4\114\1\0"+
    "\22\114\31\0\1\117\23\0\1\120\24\0\1\121\30\0"+
    "\1\122\117\0\1\123\26\0\1\124\15\0\1\125\13\0"+
    "\1\125\1\126\1\127\1\107\1\110\20\0\1\110\5\0"+
    "\1\127\30\0\1\130\13\0\1\130\2\0\1\131\101\0"+
    "\1\132\37\0\1\133\1\134\14\0\7\24\1\0\14\24"+
    "\1\135\1\136\52\24\26\0\1\137\52\0\2\11\1\0"+
    "\2\11\7\0\3\11\1\0\1\11\1\0\1\11\3\0"+
    "\1\11\2\0\1\11\1\140\2\11\1\0\10\11\1\141"+
    "\5\11\1\142\3\11\20\0\2\11\1\0\2\11\7\0"+
    "\3\11\1\0\1\11\1\0\1\11\3\0\1\11\2\0"+
    "\3\11\1\143\1\0\2\11\1\144\12\11\1\145\4\11"+
    "\20\0\2\11\1\0\2\11\7\0\3\11\1\0\1\11"+
    "\1\0\1\11\3\0\1\146\2\0\4\11\1\0\22\11"+
    "\102\0\1\147\15\0\2\11\1\0\2\11\7\0\3\11"+
    "\1\0\1\11\1\0\1\11\3\0\1\11\2\0\4\11"+
    "\1\0\1\11\1\150\12\11\1\151\5\11\20\0\2\11"+
    "\1\0\2\11\7\0\3\11\1\0\1\11\1\0\1\11"+
    "\3\0\1\11\2\0\4\11\1\0\11\11\1\152\10\11"+
    "\20\0\2\11\1\0\2\11\7\0\3\11\1\0\1\11"+
    "\1\0\1\11\3\0\1\153\2\0\4\11\1\0\22\11"+
    "\20\0\2\11\1\0\2\11\7\0\3\11\1\0\1\11"+
    "\1\0\1\11\3\0\1\11\2\0\4\11\1\0\14\11"+
    "\1\154\5\11\20\0\2\11\1\0\2\11\7\0\3\11"+
    "\1\0\1\11\1\0\1\11\3\0\1\11\2\0\4\11"+
    "\1\0\5\11\1\155\14\11\20\0\2\11\1\0\2\11"+
    "\7\0\3\11\1\0\1\11\1\0\1\11\3\0\1\11"+
    "\2\0\3\11\1\156\1\0\22\11\20\0\2\11\1\0"+
    "\2\11\7\0\3\11\1\0\1\11\1\0\1\11\3\0"+
    "\1\11\2\0\4\11\1\0\3\11\1\157\16\11\20\0"+
    "\2\11\1\0\2\11\7\0\3\11\1\0\1\11\1\0"+
    "\1\11\3\0\1\11\2\0\4\11\1\0\10\11\1\160"+
    "\11\11\20\0\2\11\1\0\2\11\7\0\3\11\1\0"+
    "\1\11\1\0\1\11\3\0\1\11\2\0\1\11\1\161"+
    "\2\11\1\0\22\11\20\0\2\11\1\0\2\11\7\0"+
    "\3\11\1\0\1\11\1\0\1\11\3\0\1\162\2\0"+
    "\4\11\1\0\1\11\1\163\3\11\1\164\14\11\20\0"+
    "\2\11\1\0\2\11\7\0\3\11\1\0\1\11\1\0"+
    "\1\11\3\0\1\11\2\0\1\11\1\165\2\11\1\0"+
    "\22\11\20\0\2\11\1\0\2\11\7\0\3\11\1\0"+
    "\1\11\1\0\1\11\3\0\1\11\2\0\4\11\1\0"+
    "\5\11\1\166\14\11\20\0\2\11\1\0\2\11\7\0"+
    "\3\11\1\0\1\11\1\0\1\11\3\0\1\11\2\0"+
    "\4\11\1\0\1\11\1\167\20\11\32\0\1\170\47\0"+
    "\1\171\27\0\1\172\47\0\1\173\76\0\1\174\1\175"+
    "\77\0\1\176\1\0\1\177\100\0\1\200\100\0\1\201"+
    "\73\0\1\202\105\0\1\203\6\0\7\70\2\0\14\70"+
    "\2\0\51\70\2\0\1\204\1\0\1\204\1\0\1\205"+
    "\7\0\2\204\1\0\1\204\1\0\1\204\3\0\1\204"+
    "\1\206\1\0\4\204\1\0\22\204\17\0\7\207\1\0"+
    "\17\207\1\210\50\207\26\0\1\211\52\0\2\77\1\0"+
    "\2\77\7\0\3\77\1\0\1\77\1\0\1\77\3\0"+
    "\1\77\2\0\4\77\1\0\22\77\17\0\6\212\2\0"+
    "\70\212\1\0\2\77\1\0\2\77\7\0\3\77\1\0"+
    "\1\77\1\0\1\77\3\0\1\77\2\0\1\77\1\213"+
    "\2\77\1\0\22\77\55\0\1\214\53\0\1\215\66\0"+
    "\1\130\13\0\1\130\2\0\1\216\60\0\1\217\13\0"+
    "\1\217\4\0\1\217\42\0\1\217\12\0\6\111\1\220"+
    "\1\0\70\111\1\0\2\112\1\0\2\112\7\0\3\112"+
    "\1\0\1\112\1\0\1\112\3\0\1\112\2\0\4\112"+
    "\1\0\22\112\17\0\6\221\2\0\70\221\1\0\2\114"+
    "\1\0\2\114\7\0\3\114\1\0\1\114\1\0\1\114"+
    "\3\0\1\114\2\0\4\114\1\0\22\114\17\0\6\222"+
    "\2\0\70\222\7\117\1\0\70\117\36\0\1\223\41\0"+
    "\7\122\1\0\70\122\35\0\1\224\3\0\1\225\121\0"+
    "\1\226\15\0\1\125\13\0\1\125\2\0\1\227\1\110"+
    "\20\0\1\110\36\0\2\126\12\0\1\126\1\0\1\126"+
    "\1\230\1\126\1\0\1\231\13\0\1\126\2\0\1\126"+
    "\1\231\1\126\3\0\1\126\3\0\1\126\3\0\1\126"+
    "\20\0\1\127\13\0\1\127\2\0\1\232\60\0\1\130"+
    "\13\0\1\130\3\0\1\110\20\0\1\110\35\0\7\24"+
    "\1\0\70\24\26\0\1\233\52\0\2\11\1\0\2\11"+
    "\7\0\3\11\1\0\1\11\1\0\1\11\3\0\1\11"+
    "\2\0\2\11\1\234\1\11\1\0\10\11\1\235\11\11"+
    "\20\0\2\11\1\0\2\11\7\0\3\11\1\0\1\11"+
    "\1\0\1\11\3\0\1\236\2\0\4\11\1\0\5\11"+
    "\1\237\10\11\1\240\3\11\20\0\2\11\1\0\2\11"+
    "\7\0\3\11\1\0\1\11\1\0\1\11\3\0\1\11"+
    "\2\0\4\11\1\0\4\11\1\241\15\11\20\0\2\11"+
    "\1\0\2\11\7\0\3\11\1\0\1\11\1\0\1\11"+
    "\3\0\1\11\2\0\4\11\1\0\4\11\1\242\15\11"+
    "\20\0\2\11\1\0\2\11\7\0\3\11\1\0\1\11"+
    "\1\0\1\11\3\0\1\11\2\0\4\11\1\0\2\11"+
    "\1\243\17\11\20\0\2\11\1\0\2\11\7\0\3\11"+
    "\1\0\1\11\1\0\1\11\3\0\1\11\2\0\4\11"+
    "\1\0\5\11\1\244\14\11\20\0\2\11\1\0\2\11"+
    "\7\0\3\11\1\0\1\11\1\0\1\11\3\0\1\11"+
    "\2\0\4\11\1\0\12\11\1\245\7\11\20\0\2\11"+
    "\1\0\2\11\7\0\3\11\1\0\1\11\1\0\1\11"+
    "\3\0\1\11\2\0\4\11\1\0\14\11\1\246\5\11"+
    "\20\0\2\11\1\0\2\11\7\0\3\11\1\0\1\11"+
    "\1\0\1\11\3\0\1\11\2\0\3\11\1\247\1\0"+
    "\22\11\20\0\2\11\1\0\2\11\7\0\3\11\1\0"+
    "\1\11\1\0\1\11\3\0\1\11\2\0\4\11\1\0"+
    "\1\250\21\11\20\0\2\11\1\0\2\11\7\0\3\11"+
    "\1\0\1\11\1\0\1\11\3\0\1\11\2\0\4\11"+
    "\1\0\22\11\3\0\1\251\14\0\2\11\1\0\2\11"+
    "\7\0\3\11\1\0\1\11\1\0\1\11\3\0\1\11"+
    "\2\0\1\252\3\11\1\0\22\11\20\0\2\11\1\0"+
    "\2\11\7\0\3\11\1\0\1\11\1\0\1\11\3\0"+
    "\1\11\2\0\4\11\1\0\3\11\1\253\16\11\20\0"+
    "\2\11\1\0\2\11\7\0\3\11\1\0\1\11\1\0"+
    "\1\11\3\0\1\11\2\0\2\11\1\254\1\11\1\0"+
    "\3\11\1\255\16\11\20\0\2\11\1\0\2\11\7\0"+
    "\3\11\1\0\1\11\1\0\1\11\3\0\1\11\2\0"+
    "\4\11\1\0\2\11\1\256\17\11\20\0\2\11\1\0"+
    "\2\11\7\0\3\11\1\0\1\11\1\0\1\11\3\0"+
    "\1\11\2\0\4\11\1\0\10\11\1\257\11\11\20\0"+
    "\2\11\1\0\2\11\7\0\3\11\1\0\1\11\1\0"+
    "\1\11\3\0\1\11\2\0\4\11\1\0\14\11\1\260"+
    "\5\11\20\0\2\11\1\0\2\11\7\0\3\11\1\0"+
    "\1\11\1\0\1\11\3\0\1\11\2\0\2\11\1\261"+
    "\1\11\1\0\22\11\20\0\2\11\1\0\2\11\7\0"+
    "\3\11\1\0\1\11\1\0\1\11\3\0\1\11\2\0"+
    "\4\11\1\0\10\11\1\262\3\11\1\263\5\11\100\0"+
    "\1\264\100\0\1\265\100\0\1\266\15\0\2\204\1\0"+
    "\2\204\7\0\3\204\1\0\1\204\1\0\1\204\3\0"+
    "\1\204\2\0\4\204\1\0\22\204\17\0\6\267\2\0"+
    "\70\267\1\0\2\270\12\0\1\270\1\0\1\270\1\0"+
    "\1\270\15\0\1\270\2\0\1\270\1\0\1\270\3\0"+
    "\1\270\3\0\1\270\3\0\1\270\45\0\1\74\51\0"+
    "\6\212\1\271\1\0\70\212\1\0\2\77\1\0\2\77"+
    "\7\0\3\77\1\0\1\77\1\0\1\77\3\0\1\77"+
    "\2\0\2\77\1\272\1\77\1\0\22\77\20\0\1\217"+
    "\13\0\1\217\62\0\6\221\1\273\1\0\70\221\6\222"+
    "\1\274\1\0\70\222\12\0\1\275\66\0\2\276\1\0"+
    "\2\276\7\0\3\276\1\0\1\276\1\0\1\276\3\0"+
    "\1\276\2\0\4\276\1\0\22\276\20\0\1\130\13\0"+
    "\1\130\63\0\2\277\12\0\1\277\1\0\1\277\1\216"+
    "\1\277\15\0\1\277\2\0\1\277\1\0\1\277\3\0"+
    "\1\277\3\0\1\277\3\0\1\277\20\0\1\217\13\0"+
    "\1\217\4\0\1\300\42\0\1\300\32\0\1\216\60\0"+
    "\2\11\1\0\2\11\7\0\3\11\1\0\1\11\1\0"+
    "\1\11\3\0\1\11\2\0\3\11\1\301\1\0\22\11"+
    "\20\0\2\11\1\0\2\11\7\0\3\11\1\0\1\11"+
    "\1\0\1\11\3\0\1\11\2\0\4\11\1\0\1\11"+
    "\1\302\20\11\20\0\2\11\1\0\2\11\7\0\3\11"+
    "\1\0\1\11\1\0\1\11\3\0\1\11\2\0\4\11"+
    "\1\0\3\11\1\303\16\11\20\0\2\11\1\0\2\11"+
    "\7\0\3\11\1\0\1\11\1\0\1\11\3\0\1\11"+
    "\2\0\2\11\1\304\1\11\1\0\22\11\20\0\2\11"+
    "\1\0\2\11\7\0\3\11\1\0\1\11\1\0\1\11"+
    "\3\0\1\11\2\0\4\11\1\0\3\11\1\305\16\11"+
    "\20\0\2\11\1\0\2\11\7\0\3\11\1\0\1\11"+
    "\1\0\1\11\3\0\1\11\2\0\4\11\1\0\3\11"+
    "\1\306\16\11\20\0\2\11\1\0\2\11\7\0\3\11"+
    "\1\0\1\11\1\0\1\11\3\0\1\11\2\0\1\307"+
    "\3\11\1\0\22\11\20\0\2\11\1\0\2\11\7\0"+
    "\3\11\1\0\1\11\1\0\1\11\3\0\1\11\2\0"+
    "\3\11\1\310\1\0\22\11\20\0\2\11\1\0\2\11"+
    "\7\0\3\11\1\0\1\11\1\0\1\11\3\0\1\11"+
    "\2\0\4\11\1\0\3\11\1\311\16\11\20\0\2\11"+
    "\1\0\2\11\7\0\3\11\1\0\1\11\1\0\1\11"+
    "\3\0\1\11\2\0\4\11\1\0\14\11\1\312\5\11"+
    "\20\0\2\11\1\0\2\11\7\0\3\11\1\0\1\11"+
    "\1\0\1\11\3\0\1\11\2\0\4\11\1\0\3\11"+
    "\1\313\16\11\20\0\2\11\1\0\2\11\7\0\3\11"+
    "\1\0\1\11\1\0\1\11\3\0\1\11\2\0\4\11"+
    "\1\0\6\11\1\314\13\11\20\0\2\11\1\0\2\11"+
    "\7\0\3\11\1\0\1\11\1\0\1\11\3\0\1\315"+
    "\2\0\4\11\1\0\22\11\20\0\2\11\1\0\2\11"+
    "\7\0\3\11\1\0\1\11\1\0\1\11\3\0\1\11"+
    "\2\0\4\11\1\0\5\11\1\316\14\11\20\0\2\11"+
    "\1\0\2\11\7\0\3\11\1\0\1\11\1\0\1\11"+
    "\3\0\1\11\2\0\4\11\1\0\14\11\1\317\5\11"+
    "\20\0\2\11\1\0\2\11\7\0\3\11\1\0\1\11"+
    "\1\0\1\11\3\0\1\11\2\0\4\11\1\0\2\11"+
    "\1\320\17\11\20\0\2\11\1\0\2\11\7\0\3\11"+
    "\1\0\1\11\1\0\1\11\3\0\1\11\2\0\3\11"+
    "\1\321\1\0\22\11\20\0\2\11\1\0\2\11\7\0"+
    "\3\11\1\0\1\11\1\0\1\11\3\0\1\11\2\0"+
    "\3\11\1\322\1\0\22\11\17\0\6\267\1\323\1\0"+
    "\70\267\1\0\2\324\12\0\1\324\1\0\1\324\1\0"+
    "\1\324\15\0\1\324\2\0\1\324\1\0\1\324\3\0"+
    "\1\324\3\0\1\324\3\0\1\324\20\0\2\77\1\0"+
    "\2\77\7\0\3\77\1\0\1\77\1\0\1\77\3\0"+
    "\1\77\2\0\3\77\1\325\1\0\22\77\20\0\2\277"+
    "\12\0\1\277\1\0\1\277\1\0\1\277\1\0\1\231"+
    "\13\0\1\277\2\0\1\277\1\231\1\277\3\0\1\277"+
    "\3\0\1\277\3\0\1\277\20\0\2\11\1\0\2\11"+
    "\7\0\3\11\1\0\1\11\1\0\1\11\3\0\1\11"+
    "\2\0\4\11\1\0\13\11\1\326\6\11\20\0\2\11"+
    "\1\0\2\11\7\0\3\11\1\0\1\11\1\0\1\11"+
    "\3\0\1\11\2\0\1\327\3\11\1\0\22\11\20\0"+
    "\2\11\1\0\2\11\7\0\3\11\1\0\1\11\1\0"+
    "\1\11\3\0\1\11\2\0\4\11\1\0\10\11\1\330"+
    "\11\11\20\0\2\11\1\0\2\11\7\0\3\11\1\0"+
    "\1\11\1\0\1\11\3\0\1\11\2\0\2\11\1\331"+
    "\1\11\1\0\22\11\20\0\2\11\1\0\2\11\7\0"+
    "\3\11\1\0\1\11\1\0\1\11\3\0\1\11\2\0"+
    "\3\11\1\332\1\0\22\11\20\0\2\11\1\0\2\11"+
    "\7\0\3\11\1\0\1\11\1\0\1\11\3\0\1\11"+
    "\2\0\4\11\1\0\1\333\21\11\20\0\2\11\1\0"+
    "\2\11\7\0\3\11\1\0\1\11\1\0\1\11\3\0"+
    "\1\11\2\0\4\11\1\0\5\11\1\334\14\11\20\0"+
    "\2\11\1\0\2\11\7\0\3\11\1\0\1\11\1\0"+
    "\1\11\3\0\1\11\2\0\4\11\1\0\10\11\1\335"+
    "\11\11\20\0\2\11\1\0\2\11\7\0\3\11\1\0"+
    "\1\11\1\0\1\11\3\0\1\11\2\0\4\11\1\0"+
    "\6\11\1\336\13\11\20\0\2\11\1\0\2\11\7\0"+
    "\3\11\1\0\1\11\1\0\1\11\3\0\1\11\2\0"+
    "\4\11\1\0\3\11\1\337\16\11\20\0\2\11\1\0"+
    "\2\11\7\0\3\11\1\0\1\11\1\0\1\11\3\0"+
    "\1\11\2\0\4\11\1\0\3\11\1\340\16\11\20\0"+
    "\2\341\12\0\1\341\1\0\1\341\1\0\1\341\15\0"+
    "\1\341\2\0\1\341\1\0\1\341\3\0\1\341\3\0"+
    "\1\341\3\0\1\341\20\0\2\11\1\0\2\11\7\0"+
    "\3\11\1\0\1\11\1\0\1\11\3\0\1\11\2\0"+
    "\4\11\1\0\2\11\1\342\17\11\20\0\2\11\1\0"+
    "\2\11\7\0\3\11\1\0\1\11\1\0\1\11\3\0"+
    "\1\11\2\0\1\343\3\11\1\0\22\11\20\0\2\11"+
    "\1\0\2\11\7\0\3\11\1\0\1\11\1\0\1\11"+
    "\3\0\1\11\2\0\4\11\1\0\7\11\1\344\12\11"+
    "\20\0\2\11\1\0\2\11\7\0\3\11\1\0\1\11"+
    "\1\0\1\11\3\0\1\11\2\0\4\11\1\0\2\11"+
    "\1\345\17\11\20\0\2\207\12\0\1\207\1\0\1\207"+
    "\1\0\1\207\15\0\1\207\2\0\1\207\1\0\1\207"+
    "\3\0\1\207\3\0\1\207\3\0\1\207\20\0\2\11"+
    "\1\0\2\11\7\0\3\11\1\0\1\11\1\0\1\11"+
    "\3\0\1\346\2\0\4\11\1\0\22\11\20\0\2\11"+
    "\1\0\2\11\7\0\3\11\1\0\1\11\1\0\1\11"+
    "\3\0\1\11\2\0\4\11\1\0\3\11\1\347\16\11"+
    "\20\0\2\11\1\0\2\11\7\0\3\11\1\0\1\11"+
    "\1\0\1\11\3\0\1\11\2\0\4\11\1\0\3\11"+
    "\1\350\16\11\17\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[9728];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;
  private static final char[] EMPTY_BUFFER = new char[0];
  private static final int YYEOF = -1;
  private static java.io.Reader zzReader = null; // Fake

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\6\0\1\11\16\1\2\11\24\1\1\11\5\1\6\11"+
    "\1\1\1\11\1\1\1\0\2\11\2\1\1\0\1\1"+
    "\1\11\2\1\2\11\1\0\1\1\1\0\1\1\1\0"+
    "\1\1\1\0\1\11\2\1\1\11\1\1\1\0\5\1"+
    "\5\11\1\1\1\0\7\1\1\11\20\1\1\0\1\11"+
    "\1\0\2\11\1\1\6\11\1\1\1\0\2\11\1\1"+
    "\2\0\1\1\3\11\1\1\1\11\2\0\3\1\1\11"+
    "\4\0\1\11\15\1\1\11\12\1\3\11\2\0\1\11"+
    "\1\1\4\11\1\1\1\0\22\1\1\11\1\0\14\1"+
    "\1\0\7\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[232];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private CharSequence zzBuffer = "";

  /** this buffer may contains the current text array to be matched when it is cheap to acquire it */
  private char[] zzBufferArray;

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /**
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
    private static final class State {
        final int lBraceCount;
        final int state;

        public State(int state, int lBraceCount) {
            this.state = state;
            this.lBraceCount = lBraceCount;
        }

        @Override
        public String toString() {
            return "yystate = " + state + (lBraceCount == 0 ? "" : "lBraceCount = " + lBraceCount);
        }
    }

    private final Stack<State> states = new Stack<State>();
    private int lBraceCount;
    
    private int commentStart;
    private int commentDepth;

    private void pushState(int state) {
        states.push(new State(yystate(), lBraceCount));
        lBraceCount = 0;
        yybegin(state);
    }

    private void popState() {
        State state = states.pop();
        lBraceCount = state.lBraceCount;
        yybegin(state.state);
    }

    private IElementType commentStateToTokenType(int state) {
        switch (state) {
            case BLOCK_COMMENT:
                return JetTokens.BLOCK_COMMENT;
            case DOC_COMMENT:
                return JetTokens.DOC_COMMENT;
            default:
                throw new IllegalArgumentException("Unexpected state: " + state);
        }
    }


  _JetLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  _JetLexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1326) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }

  public final int getTokenStart(){
    return zzStartRead;
  }

  public final int getTokenEnd(){
    return getTokenStart() + yylength();
  }

  public void reset(CharSequence buffer, int start, int end,int initialState){
    zzBuffer = buffer;
    zzBufferArray = com.intellij.util.text.CharArrayUtil.fromSequenceWithoutCopying(buffer);
    zzCurrentPos = zzMarkedPos = zzStartRead = start;
    zzPushbackPos = 0;
    zzAtEOF  = false;
    zzAtBOL = true;
    zzEndRead = end;
    yybegin(initialState);
  }

  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   *
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {
    return true;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final CharSequence yytext() {
    return zzBuffer.subSequence(zzStartRead, zzMarkedPos);
  }


  /**
   * Returns the character at position <tt>pos</tt> from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBufferArray != null ? zzBufferArray[zzStartRead+pos]:zzBuffer.charAt(zzStartRead+pos);
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() {
    if (!zzEOFDone) {
      zzEOFDone = true;
      return;

    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public IElementType advance() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    CharSequence zzBufferL = zzBuffer;
    char[] zzBufferArrayL = zzBufferArray;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL)
            zzInput = (zzBufferArrayL != null ? zzBufferArrayL[zzCurrentPosL++] : zzBufferL.charAt(zzCurrentPosL++));
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = (zzBufferArrayL != null ? zzBufferArrayL[zzCurrentPosL++] : zzBufferL.charAt(zzCurrentPosL++));
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 3: 
          { return JetTokens.IDENTIFIER;
          }
        case 106: break;
        case 12: 
          { pushState(STRING); return JetTokens.OPEN_QUOTE;
          }
        case 107: break;
        case 79: 
          { return JetTokens.FOR_KEYWORD ;
          }
        case 108: break;
        case 103: 
          { return JetTokens.RETURN_KEYWORD ;
          }
        case 109: break;
        case 90: 
          { return JetTokens.NULL_KEYWORD ;
          }
        case 110: break;
        case 35: 
          { if (lBraceCount == 0) {
                                             popState();
                                             return JetTokens.LONG_TEMPLATE_ENTRY_END;
                                           }
                                           lBraceCount--;
                                           return JetTokens.RBRACE;
          }
        case 111: break;
        case 16: 
          { return JetTokens.LT        ;
          }
        case 112: break;
        case 54: 
          { return JetTokens.DO_KEYWORD ;
          }
        case 113: break;
        case 20: 
          { return JetTokens.PLUS      ;
          }
        case 114: break;
        case 59: 
          { return JetTokens.PLUSEQ    ;
          }
        case 115: break;
        case 94: 
          { popState(); return JetTokens.THIS_KEYWORD;
          }
        case 116: break;
        case 28: 
          { return JetTokens.COMMA     ;
          }
        case 117: break;
        case 17: 
          { return JetTokens.GT        ;
          }
        case 118: break;
        case 4: 
          { return JetTokens.WHITE_SPACE;
          }
        case 119: break;
        case 26: 
          { return JetTokens.RPAR      ;
          }
        case 120: break;
        case 57: 
          { return JetTokens.DOUBLE_ARROW;
          }
        case 121: break;
        case 88: 
          { return JetTokens.TRUE_KEYWORD ;
          }
        case 122: break;
        case 82: 
          { return JetTokens.IDE_TEMPLATE_START    ;
          }
        case 123: break;
        case 37: 
          { return JetTokens.FIELD_IDENTIFIER;
          }
        case 124: break;
        case 61: 
          { return JetTokens.ANDAND    ;
          }
        case 125: break;
        case 66: 
          { pushState(LONG_TEMPLATE_ENTRY); return JetTokens.LONG_TEMPLATE_ENTRY_START;
          }
        case 126: break;
        case 36: 
          { return JetTokens.FLOAT_LITERAL;
          }
        case 127: break;
        case 40: 
          { return JetTokens.EOL_COMMENT;
          }
        case 128: break;
        case 92: 
          { return JetTokens.WHEN_KEYWORD ;
          }
        case 129: break;
        case 75: 
          { pushState(RAW_STRING); return JetTokens.OPEN_QUOTE;
          }
        case 130: break;
        case 22: 
          { return JetTokens.COLON     ;
          }
        case 131: break;
        case 55: 
          { return JetTokens.LTEQ      ;
          }
        case 132: break;
        case 47: 
          { return JetTokens.ARROW     ;
          }
        case 133: break;
        case 32: 
          { popState(); return JetTokens.IDENTIFIER;
          }
        case 134: break;
        case 23: 
          { return JetTokens.LBRACKET  ;
          }
        case 135: break;
        case 70: 
          { yypushback(2); return JetTokens.INTEGER_LITERAL;
          }
        case 136: break;
        case 11: 
          { return JetTokens.CHARACTER_LITERAL;
          }
        case 137: break;
        case 80: 
          { return JetTokens.VAR_KEYWORD ;
          }
        case 138: break;
        case 56: 
          { return JetTokens.GTEQ      ;
          }
        case 139: break;
        case 2: 
          { return JetTokens.INTEGER_LITERAL;
          }
        case 140: break;
        case 14: 
          { return JetTokens.RBRACE    ;
          }
        case 141: break;
        case 98: 
          { return JetTokens.CLASS_KEYWORD ;
          }
        case 142: break;
        case 76: 
          { return JetTokens.TRY_KEYWORD ;
          }
        case 143: break;
        case 8: 
          { return JetTokens.EXCL      ;
          }
        case 144: break;
        case 44: 
          { return JetTokens.EXCLEQ    ;
          }
        case 145: break;
        case 48: 
          { return JetTokens.MINUSEQ   ;
          }
        case 146: break;
        case 104: 
          { return JetTokens.PACKAGE_KEYWORD ;
          }
        case 147: break;
        case 95: 
          { return JetTokens.THROW_KEYWORD ;
          }
        case 148: break;
        case 97: 
          { return JetTokens.SUPER_KEYWORD ;
          }
        case 149: break;
        case 69: 
          { if (commentDepth > 0) {
            commentDepth--;
        }
        else {
             int state = yystate();
             popState();
             zzStartRead = commentStart;
             return commentStateToTokenType(state);
        }
          }
        case 150: break;
        case 100: 
          { return JetTokens.WHILE_KEYWORD ;
          }
        case 151: break;
        case 46: 
          { return JetTokens.MINUSMINUS;
          }
        case 152: break;
        case 105: 
          { return JetTokens.CONTINUE_KEYWORD ;
          }
        case 153: break;
        case 73: 
          { return JetTokens.NOT_IN;
          }
        case 154: break;
        case 39: 
          { return JetTokens.ATAT      ;
          }
        case 155: break;
        case 6: 
          { return JetTokens.DIV       ;
          }
        case 156: break;
        case 83: 
          { return JetTokens.IDE_TEMPLATE_END    ;
          }
        case 157: break;
        case 38: 
          { return JetTokens.LABEL_IDENTIFIER;
          }
        case 158: break;
        case 29: 
          { return JetTokens.REGULAR_STRING_PART;
          }
        case 159: break;
        case 19: 
          { return JetTokens.QUEST     ;
          }
        case 160: break;
        case 71: 
          { pushState(DOC_COMMENT);
    commentDepth = 0;
    commentStart = getTokenStart();
          }
        case 161: break;
        case 62: 
          { return JetTokens.OROR      ;
          }
        case 162: break;
        case 21: 
          { return JetTokens.PERC      ;
          }
        case 163: break;
        case 74: 
          { return JetTokens.EXCLEQEQEQ;
          }
        case 164: break;
        case 63: 
          { return JetTokens.PERCEQ    ;
          }
        case 165: break;
        case 45: 
          { return JetTokens.RANGE     ;
          }
        case 166: break;
        case 1: 
          { return TokenType.BAD_CHARACTER;
          }
        case 167: break;
        case 65: 
          { pushState(SHORT_TEMPLATE_ENTRY);
                                                        yypushback(yylength() - 1);
                                                        return JetTokens.SHORT_TEMPLATE_ENTRY_START;
          }
        case 168: break;
        case 72: 
          { return JetTokens.NOT_IS;
          }
        case 169: break;
        case 15: 
          { return JetTokens.MUL       ;
          }
        case 170: break;
        case 24: 
          { return JetTokens.RBRACKET  ;
          }
        case 171: break;
        case 60: 
          { return JetTokens.PLUSPLUS  ;
          }
        case 172: break;
        case 41: 
          { pushState(BLOCK_COMMENT);
    commentDepth = 0;
    commentStart = getTokenStart();
          }
        case 173: break;
        case 87: 
          { return JetTokens.THIS_KEYWORD ;
          }
        case 174: break;
        case 9: 
          { return JetTokens.DOT       ;
          }
        case 175: break;
        case 27: 
          { return JetTokens.SEMICOLON ;
          }
        case 176: break;
        case 51: 
          { return JetTokens.IF_KEYWORD ;
          }
        case 177: break;
        case 67: 
          { return JetTokens.ESCAPE_SEQUENCE;
          }
        case 178: break;
        case 31: 
          { popState(); return JetTokens.CLOSING_QUOTE;
          }
        case 179: break;
        case 18: 
          { return JetTokens.EQ        ;
          }
        case 180: break;
        case 5: 
          { return JetTokens.AT        ;
          }
        case 181: break;
        case 77: 
          { return JetTokens.AS_SAFE;
          }
        case 182: break;
        case 25: 
          { return JetTokens.LPAR      ;
          }
        case 183: break;
        case 10: 
          { return JetTokens.MINUS     ;
          }
        case 184: break;
        case 101: 
          { return JetTokens.FALSE_KEYWORD ;
          }
        case 185: break;
        case 89: 
          { return JetTokens.TYPE_KEYWORD ;
          }
        case 186: break;
        case 68: 
          { commentDepth++;
          }
        case 187: break;
        case 78: 
          { return JetTokens.FUN_KEYWORD ;
          }
        case 188: break;
        case 49: 
          { return JetTokens.IS_KEYWORD ;
          }
        case 189: break;
        case 30: 
          { popState(); yypushback(1); return JetTokens.DANGLING_NEWLINE;
          }
        case 190: break;
        case 34: 
          { lBraceCount++; return JetTokens.LBRACE;
          }
        case 191: break;
        case 86: 
          { yypushback(3); return JetTokens.EXCL;
          }
        case 192: break;
        case 42: 
          { return JetTokens.DIVEQ     ;
          }
        case 193: break;
        case 91: 
          { return JetTokens.ELSE_KEYWORD ;
          }
        case 194: break;
        case 53: 
          { return JetTokens.AS_KEYWORD ;
          }
        case 195: break;
        case 50: 
          { return JetTokens.IN_KEYWORD ;
          }
        case 196: break;
        case 58: 
          { return JetTokens.EQEQ      ;
          }
        case 197: break;
        case 84: 
          { return JetTokens.EQEQEQ    ;
          }
        case 198: break;
        case 81: 
          { return JetTokens.VAL_KEYWORD ;
          }
        case 199: break;
        case 93: 
          { return JetTokens.CAPITALIZED_THIS_KEYWORD ;
          }
        case 200: break;
        case 52: 
          { return JetTokens.MULTEQ    ;
          }
        case 201: break;
        case 43: 
          { if (zzCurrentPos == 0) {
                return JetTokens.SHEBANG_COMMENT;
            }
            else {
                yypushback(yylength() - 1);
                return JetTokens.HASH;
            }
          }
        case 202: break;
        case 13: 
          { return JetTokens.LBRACE    ;
          }
        case 203: break;
        case 102: 
          { return JetTokens.OBJECT_KEYWORD ;
          }
        case 204: break;
        case 99: 
          { return JetTokens.BREAK_KEYWORD ;
          }
        case 205: break;
        case 85: 
          { return JetTokens.BLOCK_COMMENT;
          }
        case 206: break;
        case 96: 
          { return JetTokens.TRAIT_KEYWORD ;
          }
        case 207: break;
        case 64: 
          { return JetTokens.COLONCOLON;
          }
        case 208: break;
        case 33: 
          { 
          }
        case 209: break;
        case 7: 
          { return JetTokens.HASH      ;
          }
        case 210: break;
        default:
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
            switch (zzLexicalState) {
            case BLOCK_COMMENT: {
              int state = yystate();
        popState();
        zzStartRead = commentStart;
        return commentStateToTokenType(state);
            }
            case 233: break;
            case DOC_COMMENT: {
              int state = yystate();
        popState();
        zzStartRead = commentStart;
        return commentStateToTokenType(state);
            }
            case 234: break;
            default:
            return null;
            }
          }
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
