/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsCatchScope;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.SourceInfoAwareJsNode;

public class JsCatch
extends SourceInfoAwareJsNode {
    protected final JsCatchScope scope;
    private JsBlock body;
    private JsExpression condition;
    private JsParameter param;

    public JsCatch(JsScope parent, String ident) {
        assert (parent != null);
        this.scope = new JsCatchScope(parent, ident);
        this.param = new JsParameter(this.scope.findName(ident));
    }

    public JsBlock getBody() {
        return this.body;
    }

    public JsExpression getCondition() {
        return this.condition;
    }

    public JsParameter getParameter() {
        return this.param;
    }

    public void setBody(JsBlock body) {
        this.body = body;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitCatch(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor) {
        visitor.accept(this.param);
        if (this.condition != null) {
            visitor.accept(this.condition);
        }
        visitor.accept(this.body);
    }
}

