/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileMoveEvent
extends VirtualFileEvent {
    private final VirtualFile myOldParent;
    private final VirtualFile myNewParent;

    public VirtualFileMoveEvent(@Nullable Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile oldParent, @NotNull VirtualFile newParent) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/VirtualFileMoveEvent", "<init>"));
        }
        if (oldParent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/VirtualFileMoveEvent", "<init>"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/vfs/VirtualFileMoveEvent", "<init>"));
        }
        super(requestor, file, file.getName(), file.getParent());
        this.myOldParent = oldParent;
        this.myNewParent = newParent;
    }

    @NotNull
    public VirtualFile getOldParent() {
        VirtualFile virtualFile = this.myOldParent;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VirtualFileMoveEvent", "getOldParent"));
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile getNewParent() {
        VirtualFile virtualFile = this.myNewParent;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VirtualFileMoveEvent", "getNewParent"));
        }
        return virtualFile;
    }
}

