/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.TimedReference;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarHandlerBase {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.vfs.impl.jar.JarHandlerBase");
    private final TimedReference<JarFile> myJarFile;
    private Reference<Map<String, EntryInfo>> myRelPathsToEntries;
    private final Object lock;
    protected final String myBasePath;

    public JarHandlerBase(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "<init>"));
        }
        this.myJarFile = new TimedReference(null);
        this.myRelPathsToEntries = new SoftReference<Object>(null);
        this.lock = new Object();
        this.myBasePath = path;
    }

    public File getMirrorFile(@NotNull File originalFile) {
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getMirrorFile"));
        }
        return originalFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public JarFile getJar() {
        JarFile jar = this.myJarFile.get();
        if (jar == null) {
            Object object = this.lock;
            synchronized (object) {
                jar = this.myJarFile.get();
                if (jar == null && (jar = this.createJarFile()) != null) {
                    this.myJarFile.set(jar);
                }
            }
        }
        return jar;
    }

    @Nullable
    protected JarFile createJarFile() {
        File originalFile = this.getOriginalFile();
        try {
            final ZipFile zipFile = new ZipFile(this.getMirrorFile(originalFile));
            return new JarFile(){

                @Override
                public JarFile.JarEntry getEntry(String name) {
                    try {
                        ZipEntry entry = zipFile.getEntry(name);
                        if (entry != null) {
                            class MyJarEntry
                            implements JarFile.JarEntry {
                                private final ZipEntry myEntry;

                                MyJarEntry(ZipEntry entry) {
                                    this.myEntry = entry;
                                }

                                @Override
                                public String getName() {
                                    return this.myEntry.getName();
                                }

                                @Override
                                public long getSize() {
                                    return this.myEntry.getSize();
                                }

                                @Override
                                public long getTime() {
                                    return this.myEntry.getTime();
                                }
                            }
                            return new MyJarEntry(entry);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        LOG.warn(e);
                    }
                    return null;
                }

                @Override
                public InputStream getInputStream(JarFile.JarEntry entry) throws IOException {
                    return zipFile.getInputStream(((MyJarEntry)entry).myEntry);
                }

                @Override
                public Enumeration<? extends JarFile.JarEntry> entries() {
                    return new Enumeration<JarFile.JarEntry>(){
                        private final Enumeration<? extends ZipEntry> entries;
                        {
                            this.entries = zipFile.entries();
                        }

                        @Override
                        public boolean hasMoreElements() {
                            return this.entries.hasMoreElements();
                        }

                        @Override
                        public JarFile.JarEntry nextElement() {
                            try {
                                ZipEntry entry = this.entries.nextElement();
                                if (entry != null) {
                                    return new MyJarEntry(entry);
                                }
                            }
                            catch (IllegalArgumentException e) {
                                LOG.warn(e);
                            }
                            return null;
                        }
                    };
                }
            };
        }
        catch (IOException e) {
            LOG.warn(e.getMessage() + ": " + originalFile.getPath(), e);
            return null;
        }
    }

    @NotNull
    protected File getOriginalFile() {
        File file = new File(this.myBasePath);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getOriginalFile"));
        }
        return file;
    }

    @NotNull
    private static EntryInfo getOrCreate(@NotNull String entryName, boolean isDirectory, @NotNull Map<String, EntryInfo> map) {
        if (entryName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getOrCreate"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getOrCreate"));
        }
        EntryInfo info = map.get(entryName);
        if (info == null) {
            String shortName;
            int idx = entryName.lastIndexOf(47);
            String parentEntryName = idx > 0 ? entryName.substring(0, idx) : "";
            String string = shortName = idx > 0 ? entryName.substring(idx + 1) : entryName;
            if (".".equals(shortName)) {
                EntryInfo entryInfo = JarHandlerBase.getOrCreate(parentEntryName, true, map);
                if (entryInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getOrCreate"));
                }
                return entryInfo;
            }
            info = new EntryInfo(shortName, JarHandlerBase.getOrCreate(parentEntryName, true, map), isDirectory);
            map.put(entryName, info);
        }
        EntryInfo entryInfo = info;
        if (entryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getOrCreate"));
        }
        return entryInfo;
    }

    public EntryInfo getEntryInfo(@NotNull String parentPath) {
        if (parentPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getEntryInfo"));
        }
        return this.getEntriesMap().get(parentPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected Map<String, EntryInfo> getEntriesMap() {
        Object object = this.lock;
        // MONITORENTER : object
        Map<String, EntryInfo> map2 = SoftReference.dereference(this.myRelPathsToEntries);
        if (map2 == null) {
            JarFile zip = this.getJar();
            if (zip == null) {
                map2 = Collections.emptyMap();
            } else {
                LogUtil.debug(LOG, "mapping %s", this.myBasePath);
                map2 = new THashMap<String, EntryInfo>();
                map2.put("", new EntryInfo("", null, true));
                Enumeration<? extends JarFile.JarEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    JarFile.JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    boolean isDirectory = StringUtil.endsWithChar(name, '/');
                    JarHandlerBase.getOrCreate(isDirectory ? name.substring(0, name.length() - 1) : name, isDirectory, map2);
                }
                this.myRelPathsToEntries = new SoftReference<Map<String, EntryInfo>>(map2);
            }
        }
        Map<String, EntryInfo> map = map2;
        // MONITOREXIT : object
        if (map != null) return map;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getEntriesMap"));
    }

    @NotNull
    private String getRelativePath(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getRelativePath"));
        }
        String path = file.getPath().substring(this.myBasePath.length() + 1);
        String string = StringUtil.startsWithChar(path, '/') ? path.substring(1) : path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getRelativePath"));
        }
        return string;
    }

    @Nullable
    private JarFile.JarEntry convertToEntry(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "convertToEntry"));
        }
        String path = this.getRelativePath(file);
        JarFile jar = this.getJar();
        return jar == null ? null : jar.getEntry(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLength(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getLength"));
        }
        JarFile.JarEntry entry = this.convertToEntry(file);
        Object object = this.lock;
        synchronized (object) {
            return entry == null ? 0L : entry.getSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file) throws IOException {
        byte[] byArray;
        InputStream stream;
        block11: {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "contentsToByteArray"));
            }
            JarFile.JarEntry entry = this.convertToEntry(file);
            if (entry == null) {
                if (ArrayUtil.EMPTY_BYTE_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "contentsToByteArray"));
                }
                return ArrayUtil.EMPTY_BYTE_ARRAY;
            }
            Object object = this.lock;
            synchronized (object) {
                JarFile jar = this.getJar();
                assert (jar != null) : file;
                stream = jar.getInputStream(entry);
                assert (stream != null) : file;
                byArray = FileUtil.loadBytes(stream, (int)entry.getSize());
                // MONITOREXIT @DISABLED, blocks:[1, 3] lbl18 : MonitorExitStatement: MONITOREXIT : var3_3
                if (byArray != null) break block11;
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "contentsToByteArray"));
        }
        return byArray;
        {
            finally {
                stream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeStamp(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getTimeStamp"));
        }
        if (file.getParent() == null) {
            return this.getOriginalFile().lastModified();
        }
        JarFile.JarEntry entry = this.convertToEntry(file);
        Object object = this.lock;
        synchronized (object) {
            return entry == null ? -1L : entry.getTime();
        }
    }

    protected static class EntryInfo {
        protected final boolean isDirectory;
        protected final String shortName;
        protected final EntryInfo parent;

        public EntryInfo(@NotNull String shortName, EntryInfo parent, boolean directory) {
            if (shortName == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase$EntryInfo", "<init>"));
            }
            this.shortName = shortName;
            this.parent = parent;
            this.isDirectory = directory;
        }
    }
}

