/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;

public class PsiFileImplUtil {
    private PsiFileImplUtil() {
    }

    public static PsiFile setName(PsiFile file, String newName) throws IncorrectOperationException {
        VirtualFile vFile = file.getViewProvider().getVirtualFile();
        PsiManagerImpl manager = (PsiManagerImpl)file.getManager();
        try {
            FileDocumentManager fdm;
            Document doc;
            FileType newFileType = FileTypeRegistry.getInstance().getFileTypeByFileName(newName);
            if ((UnknownFileType.INSTANCE.equals(newFileType) || newFileType.isBinary()) && (doc = (fdm = FileDocumentManager.getInstance()).getCachedDocument(vFile)) != null) {
                fdm.saveDocumentAsIs(doc);
            }
            vFile.rename(manager, newName);
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e.toString(), e);
        }
        return file.getViewProvider().isPhysical() ? manager.findFile(vFile) : file;
    }

    public static void checkSetName(PsiFile file, String name) throws IncorrectOperationException {
        VirtualFile vFile = file.getVirtualFile();
        VirtualFile parentFile = vFile.getParent();
        if (parentFile == null) {
            return;
        }
        VirtualFile child = parentFile.findChild(name);
        if (child != null && !child.equals(vFile)) {
            throw new IncorrectOperationException("File " + child.getPresentableUrl() + " already exists.");
        }
    }

    public static void doDelete(PsiFile file) throws IncorrectOperationException {
        PsiManagerImpl manager = (PsiManagerImpl)file.getManager();
        VirtualFile vFile = file.getVirtualFile();
        try {
            vFile.delete(manager);
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e.toString(), e);
        }
    }
}

