/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.checkers;

import com.google.common.collect.Maps;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactory;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetSuperExpression;
import org.jetbrains.jet.lang.psi.JetTreeVisitorVoid;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lexer.JetTokens;

public class DebugInfoUtil {
    private static final TokenSet EXCLUDED = TokenSet.create(JetTokens.COLON, JetTokens.AS_KEYWORD, JetTokens.AS_SAFE, JetTokens.IS_KEYWORD, JetTokens.NOT_IS, JetTokens.OROR, JetTokens.ANDAND, JetTokens.EQ, JetTokens.EQEQEQ, JetTokens.EXCLEQEQEQ, JetTokens.ELVIS, JetTokens.EXCLEXCL, JetTokens.IN_KEYWORD, JetTokens.NOT_IN);

    public static void markDebugAnnotations(@NotNull PsiElement root, final @NotNull BindingContext bindingContext, final @NotNull DebugInfoReporter debugInfoReporter) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/checkers/DebugInfoUtil", "markDebugAnnotations"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/checkers/DebugInfoUtil", "markDebugAnnotations"));
        }
        if (debugInfoReporter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/checkers/DebugInfoUtil", "markDebugAnnotations"));
        }
        final HashMap<JetReferenceExpression, DiagnosticFactory> markedWithErrorElements = Maps.newHashMap();
        for (Diagnostic diagnostic : bindingContext.getDiagnostics()) {
            DiagnosticFactory factory = diagnostic.getFactory();
            if (Errors.UNRESOLVED_REFERENCE_DIAGNOSTICS.contains(diagnostic.getFactory())) {
                markedWithErrorElements.put((JetReferenceExpression)diagnostic.getPsiElement(), factory);
                continue;
            }
            if (factory == Errors.SUPER_IS_NOT_AN_EXPRESSION || factory == Errors.SUPER_NOT_AVAILABLE) {
                JetSuperExpression superExpression = (JetSuperExpression)diagnostic.getPsiElement();
                markedWithErrorElements.put(superExpression.getInstanceReference(), factory);
                continue;
            }
            if (factory == Errors.EXPRESSION_EXPECTED_NAMESPACE_FOUND) {
                markedWithErrorElements.put((JetSimpleNameExpression)diagnostic.getPsiElement(), factory);
                continue;
            }
            if (factory != Errors.UNSUPPORTED) continue;
            for (JetReferenceExpression reference : PsiTreeUtil.findChildrenOfType(diagnostic.getPsiElement(), JetReferenceExpression.class)) {
                markedWithErrorElements.put(reference, factory);
            }
        }
        root.acceptChildren(new JetTreeVisitorVoid(){

            @Override
            public void visitReferenceExpression(JetReferenceExpression expression) {
                Collection<? extends PsiElement> labelTargets;
                Collection<? extends DeclarationDescriptor> declarationDescriptors;
                PsiElement labelTarget;
                super.visitReferenceExpression(expression);
                if (!BindingContextUtils.isExpressionWithValidReference(expression, bindingContext)) {
                    return;
                }
                if (expression instanceof JetSimpleNameExpression) {
                    JetSimpleNameExpression nameExpression = (JetSimpleNameExpression)expression;
                    IElementType elementType = expression.getNode().getElementType();
                    if (elementType == JetNodeTypes.OPERATION_REFERENCE) {
                        IElementType referencedNameElementType = nameExpression.getReferencedNameElementType();
                        if (EXCLUDED.contains(referencedNameElementType)) {
                            return;
                        }
                        if (JetTokens.LABELS.contains(referencedNameElementType)) {
                            return;
                        }
                    } else if (nameExpression.getReferencedNameElementType() == JetTokens.THIS_KEYWORD) {
                        return;
                    }
                }
                String target = null;
                DeclarationDescriptor declarationDescriptor = bindingContext.get(BindingContext.REFERENCE_TARGET, expression);
                if (declarationDescriptor != null) {
                    target = declarationDescriptor.toString();
                }
                if (target == null && (labelTarget = bindingContext.get(BindingContext.LABEL_TARGET, expression)) != null) {
                    target = labelTarget.getText();
                }
                if (target == null && (declarationDescriptors = bindingContext.get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, expression)) != null) {
                    target = "[" + declarationDescriptors.size() + " descriptors]";
                }
                if (target == null && (labelTargets = bindingContext.get(BindingContext.AMBIGUOUS_LABEL_TARGET, expression)) != null) {
                    target = "[" + labelTargets.size() + " elements]";
                }
                boolean resolved = target != null;
                boolean markedWithError = markedWithErrorElements.containsKey(expression);
                JetType expressionType = bindingContext.get(BindingContext.EXPRESSION_TYPE, expression);
                DiagnosticFactory factory = (DiagnosticFactory)markedWithErrorElements.get(expression);
                if (declarationDescriptor != null && (ErrorUtils.isError(declarationDescriptor) || ErrorUtils.containsErrorType(expressionType)) && factory != Errors.EXPRESSION_EXPECTED_NAMESPACE_FOUND) {
                    debugInfoReporter.reportElementWithErrorType(expression);
                }
                if (resolved && markedWithError) {
                    if (Errors.UNRESOLVED_REFERENCE_DIAGNOSTICS.contains(factory)) {
                        debugInfoReporter.reportUnresolvedWithTarget(expression, target);
                    }
                } else if (!resolved && !markedWithError) {
                    debugInfoReporter.reportMissingUnresolved(expression);
                }
            }
        });
    }

    public static interface DebugInfoReporter {
        public void reportElementWithErrorType(@NotNull JetReferenceExpression var1);

        public void reportMissingUnresolved(@NotNull JetReferenceExpression var1);

        public void reportUnresolvedWithTarget(@NotNull JetReferenceExpression var1, @NotNull String var2);
    }
}

