/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.intrinsics;

import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.InstructionAdapter;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;

public class Increment
implements IntrinsicMethod {
    private final int myDelta;

    public Increment(int delta) {
        this.myDelta = delta;
    }

    @Override
    public StackValue generate(ExpressionCodegen codegen, InstructionAdapter v, @NotNull Type expectedType, PsiElement element, List<JetExpression> arguments, StackValue receiver, @NotNull GenerationState state) {
        boolean nullable;
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/codegen/intrinsics/Increment", "generate"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "org/jetbrains/jet/codegen/intrinsics/Increment", "generate"));
        }
        boolean bl = nullable = expectedType.getSort() == 10;
        if (nullable) {
            expectedType = AsmUtil.unboxType(expectedType);
        }
        if (arguments.size() > 0) {
            int index;
            JetExpression operand = arguments.get(0);
            while (operand instanceof JetParenthesizedExpression) {
                operand = ((JetParenthesizedExpression)operand).getExpression();
            }
            if (operand instanceof JetReferenceExpression && expectedType == Type.INT_TYPE && (index = codegen.indexOfLocal((JetReferenceExpression)operand)) >= 0) {
                return StackValue.preIncrement(index, this.myDelta);
            }
            StackValue value = codegen.genQualified(receiver, operand);
            value.dupReceiver(v);
            value.dupReceiver(v);
            value.put(expectedType, v);
            AsmUtil.genIncrement(expectedType, this.myDelta, v);
            value.store(expectedType, v);
            value.put(expectedType, v);
        } else {
            receiver.put(expectedType, v);
            AsmUtil.genIncrement(expectedType, this.myDelta, v);
        }
        return StackValue.onStack(expectedType);
    }
}

