/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics.rendering;

import java.text.MessageFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.diagnostics.DiagnosticWithParameters3;
import org.jetbrains.jet.lang.diagnostics.rendering.DiagnosticRenderer;
import org.jetbrains.jet.lang.diagnostics.rendering.DiagnosticRendererUtil;
import org.jetbrains.jet.renderer.Renderer;

public class DiagnosticWithParameters3Renderer<A, B, C>
implements DiagnosticRenderer<DiagnosticWithParameters3<?, A, B, C>> {
    private final MessageFormat messageFormat;
    private final Renderer<? super A> rendererForA;
    private final Renderer<? super B> rendererForB;
    private final Renderer<? super C> rendererForC;

    public DiagnosticWithParameters3Renderer(@NotNull String message, @Nullable Renderer<? super A> rendererForA, @Nullable Renderer<? super B> rendererForB, @Nullable Renderer<? super C> rendererForC) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/diagnostics/rendering/DiagnosticWithParameters3Renderer", "<init>"));
        }
        this.messageFormat = new MessageFormat(message);
        this.rendererForA = rendererForA;
        this.rendererForB = rendererForB;
        this.rendererForC = rendererForC;
    }

    @Override
    @NotNull
    public String render(@NotNull DiagnosticWithParameters3<?, A, B, C> diagnostic) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/diagnostics/rendering/DiagnosticWithParameters3Renderer", "render"));
        }
        String string = this.messageFormat.format(new Object[]{DiagnosticRendererUtil.renderParameter(diagnostic.getA(), this.rendererForA), DiagnosticRendererUtil.renderParameter(diagnostic.getB(), this.rendererForB), DiagnosticRendererUtil.renderParameter(diagnostic.getC(), this.rendererForC)});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/DiagnosticWithParameters3Renderer", "render"));
        }
        return string;
    }
}

