/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetDeclarationImpl;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetStatementExpression;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;

public class JetClassInitializer
extends JetDeclarationImpl
implements JetStatementExpression {
    public JetClassInitializer(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetClassInitializer", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetClassInitializer", "accept"));
        }
        visitor.visitAnonymousInitializer(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetClassInitializer", "accept"));
        }
        return visitor.visitAnonymousInitializer(this, data);
    }

    @NotNull
    public JetExpression getBody() {
        JetExpression body = this.findChildByClass(JetExpression.class);
        assert (body != null);
        JetExpression jetExpression = body;
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetClassInitializer", "getBody"));
        }
        return jetExpression;
    }

    @Nullable
    public PsiElement getOpenBraceNode() {
        JetExpression body = this.getBody();
        return body instanceof JetBlockExpression ? ((JetBlockExpression)body).getLBrace() : null;
    }
}

