/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotated;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetAnnotationEntry;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetConstructorCalleeExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetModifierListOwner;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateExpression;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.AnnotationUtils;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.CallResolver;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.util.CallMaker;
import org.jetbrains.jet.lang.resolve.constants.AnnotationValue;
import org.jetbrains.jet.lang.resolve.constants.ArrayValue;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.EnumValue;
import org.jetbrains.jet.lang.resolve.constants.JavaClassValue;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class AnnotationResolver {
    private ExpressionTypingServices expressionTypingServices;
    private CallResolver callResolver;

    public void setExpressionTypingServices(ExpressionTypingServices expressionTypingServices) {
        this.expressionTypingServices = expressionTypingServices;
    }

    public void setCallResolver(CallResolver callResolver) {
        this.callResolver = callResolver;
    }

    @NotNull
    public List<AnnotationDescriptor> resolveAnnotationsWithoutArguments(@NotNull JetScope scope, @Nullable JetModifierList modifierList, @NotNull BindingTrace trace) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationsWithoutArguments"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationsWithoutArguments"));
        }
        List<AnnotationDescriptor> list = this.resolveAnnotations(scope, modifierList, trace, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationsWithoutArguments"));
        }
        return list;
    }

    @NotNull
    public List<AnnotationDescriptor> resolveAnnotationsWithArguments(@NotNull JetScope scope, @Nullable JetModifierList modifierList, @NotNull BindingTrace trace) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationsWithArguments"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationsWithArguments"));
        }
        List<AnnotationDescriptor> list = this.resolveAnnotations(scope, modifierList, trace, true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationsWithArguments"));
        }
        return list;
    }

    @NotNull
    public List<AnnotationDescriptor> resolveAnnotationsWithArguments(@NotNull JetScope scope, @NotNull List<JetAnnotationEntry> annotationEntries, @NotNull BindingTrace trace) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationsWithArguments"));
        }
        if (annotationEntries == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationsWithArguments"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationsWithArguments"));
        }
        List<AnnotationDescriptor> list = this.resolveAnnotationEntries(scope, annotationEntries, trace, true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationsWithArguments"));
        }
        return list;
    }

    private List<AnnotationDescriptor> resolveAnnotations(@NotNull JetScope scope, @Nullable JetModifierList modifierList, @NotNull BindingTrace trace, boolean shouldResolveArguments) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotations"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotations"));
        }
        if (modifierList == null) {
            return Collections.emptyList();
        }
        List<JetAnnotationEntry> annotationEntryElements = modifierList.getAnnotationEntries();
        return this.resolveAnnotationEntries(scope, annotationEntryElements, trace, shouldResolveArguments);
    }

    private List<AnnotationDescriptor> resolveAnnotationEntries(@NotNull JetScope scope, @NotNull List<JetAnnotationEntry> annotationEntryElements, @NotNull BindingTrace trace, boolean shouldResolveArguments) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationEntries"));
        }
        if (annotationEntryElements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationEntries"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationEntries"));
        }
        if (annotationEntryElements.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AnnotationDescriptor> result = Lists.newArrayList();
        for (JetAnnotationEntry entryElement : annotationEntryElements) {
            AnnotationDescriptor descriptor = trace.get(BindingContext.ANNOTATION, entryElement);
            if (descriptor == null) {
                descriptor = new AnnotationDescriptor();
                this.resolveAnnotationStub(scope, entryElement, descriptor, trace);
                trace.record(BindingContext.ANNOTATION, entryElement, descriptor);
            }
            if (shouldResolveArguments) {
                this.resolveAnnotationArguments(entryElement, scope, trace);
            }
            result.add(descriptor);
        }
        return result;
    }

    public void resolveAnnotationStub(@NotNull JetScope scope, @NotNull JetAnnotationEntry entryElement, @NotNull AnnotationDescriptor annotationDescriptor, @NotNull BindingTrace trace) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationStub"));
        }
        if (entryElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationStub"));
        }
        if (annotationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationStub"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationStub"));
        }
        TemporaryBindingTrace temporaryBindingTrace = new TemporaryBindingTrace(trace, "Trace for resolve annotation type");
        OverloadResolutionResults<FunctionDescriptor> results = this.resolveAnnotationCall(entryElement, scope, temporaryBindingTrace);
        if (results.isSingleResult()) {
            FunctionDescriptor descriptor = results.getResultingDescriptor();
            if (!ErrorUtils.isError(descriptor)) {
                if (descriptor instanceof ConstructorDescriptor) {
                    ConstructorDescriptor constructor = (ConstructorDescriptor)descriptor;
                    ClassDescriptor classDescriptor = constructor.getContainingDeclaration();
                    if (classDescriptor.getKind() != ClassKind.ANNOTATION_CLASS) {
                        trace.report(Errors.NOT_AN_ANNOTATION_CLASS.on(entryElement, classDescriptor.getName().asString()));
                    }
                } else {
                    trace.report(Errors.NOT_AN_ANNOTATION_CLASS.on(entryElement, descriptor.getName().asString()));
                }
            }
            JetType annotationType = results.getResultingDescriptor().getReturnType();
            annotationDescriptor.setAnnotationType(annotationType);
        } else {
            JetConstructorCalleeExpression calleeExpression = entryElement.getCalleeExpression();
            annotationDescriptor.setAnnotationType(ErrorUtils.createErrorType("Unresolved annotation type: " + (calleeExpression == null ? "null" : calleeExpression.getText())));
        }
    }

    private OverloadResolutionResults<FunctionDescriptor> resolveAnnotationCall(JetAnnotationEntry annotationEntry, JetScope scope, BindingTrace trace) {
        return this.callResolver.resolveFunctionCall(trace, scope, CallMaker.makeCall(ReceiverValue.NO_RECEIVER, null, annotationEntry), TypeUtils.NO_EXPECTED_TYPE, DataFlowInfo.EMPTY);
    }

    public void resolveAnnotationsArguments(@NotNull JetScope scope, @Nullable JetModifierList modifierList, @NotNull BindingTrace trace) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationsArguments"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationsArguments"));
        }
        if (modifierList == null) {
            return;
        }
        for (JetAnnotationEntry annotationEntry : modifierList.getAnnotationEntries()) {
            this.resolveAnnotationArguments(annotationEntry, scope, trace);
        }
    }

    public void resolveAnnotationsArguments(@NotNull Annotated descriptor, @NotNull BindingTrace trace, @NotNull JetScope scope) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationsArguments"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationsArguments"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationsArguments"));
        }
        for (AnnotationDescriptor annotationDescriptor : descriptor.getAnnotations()) {
            JetAnnotationEntry annotationEntry = trace.getBindingContext().get(BindingContext.ANNOTATION_DESCRIPTOR_TO_PSI_ELEMENT, annotationDescriptor);
            assert (annotationEntry != null) : "Cannot find annotation entry: " + annotationDescriptor;
            this.resolveAnnotationArguments(annotationEntry, scope, trace);
        }
    }

    private void resolveAnnotationArguments(@NotNull JetAnnotationEntry annotationEntry, @NotNull JetScope scope, @NotNull BindingTrace trace) {
        if (annotationEntry == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationArguments"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationArguments"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationArguments"));
        }
        OverloadResolutionResults<FunctionDescriptor> results = this.resolveAnnotationCall(annotationEntry, scope, trace);
        if (results.isSingleResult()) {
            AnnotationDescriptor annotationDescriptor = trace.getBindingContext().get(BindingContext.ANNOTATION, annotationEntry);
            assert (annotationDescriptor != null) : "Annotation descriptor should be created before resolving arguments for " + annotationEntry.getText();
            this.resolveAnnotationArgument(annotationDescriptor, results.getResultingCall(), trace);
        }
    }

    private void resolveAnnotationArgument(@NotNull AnnotationDescriptor annotationDescriptor, @NotNull ResolvedCall<? extends CallableDescriptor> call, @NotNull BindingTrace trace) {
        if (annotationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationArgument"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationArgument"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveAnnotationArgument"));
        }
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> descriptorToArgument : call.getValueArguments().entrySet()) {
            ValueParameterDescriptor parameterDescriptor = descriptorToArgument.getKey();
            JetType varargElementType = parameterDescriptor.getVarargElementType();
            List<CompileTimeConstant<?>> constants = this.resolveValueArguments(descriptorToArgument.getValue(), parameterDescriptor.getType(), trace);
            if (varargElementType == null) {
                for (CompileTimeConstant<?> constant : constants) {
                    annotationDescriptor.setValueArgument(parameterDescriptor, constant);
                }
                continue;
            }
            JetType arrayType = KotlinBuiltIns.getInstance().getPrimitiveArrayJetTypeByPrimitiveJetType(varargElementType);
            if (arrayType == null) {
                arrayType = KotlinBuiltIns.getInstance().getArrayType(varargElementType);
            }
            annotationDescriptor.setValueArgument(parameterDescriptor, new ArrayValue(constants, arrayType));
        }
    }

    @NotNull
    private List<CompileTimeConstant<?>> resolveValueArguments(@NotNull ResolvedValueArgument resolvedValueArgument, @NotNull JetType expectedType, @NotNull BindingTrace trace) {
        if (resolvedValueArgument == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveValueArguments"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveValueArguments"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveValueArguments"));
        }
        ArrayList<CompileTimeConstant<?>> constants = Lists.newArrayList();
        for (ValueArgument argument : resolvedValueArgument.getArguments()) {
            CompileTimeConstant<?> constant;
            JetExpression argumentExpression = argument.getArgumentExpression();
            if (argumentExpression == null || (constant = this.resolveExpressionToCompileTimeValue(argumentExpression, expectedType, trace)) == null) continue;
            constants.add(constant);
        }
        ArrayList<CompileTimeConstant<?>> arrayList = constants;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveValueArguments"));
        }
        return arrayList;
    }

    @Nullable
    public CompileTimeConstant<?> resolveExpressionToCompileTimeValue(@NotNull JetExpression expression, final @NotNull JetType expectedType, final @NotNull BindingTrace trace) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveExpressionToCompileTimeValue"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveExpressionToCompileTimeValue"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "resolveExpressionToCompileTimeValue"));
        }
        JetVisitor visitor = new JetVisitor<CompileTimeConstant<?>, Void>(){

            @Override
            public CompileTimeConstant<?> visitConstantExpression(@NotNull JetConstantExpression expression, Void nothing) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/AnnotationResolver$1", "visitConstantExpression"));
                }
                JetType type = AnnotationResolver.this.expressionTypingServices.getType(JetScope.EMPTY, expression, expectedType, DataFlowInfo.EMPTY, trace);
                if (type == null) {
                    // empty if block
                }
                return trace.get(BindingContext.COMPILE_TIME_VALUE, expression);
            }

            @Override
            public CompileTimeConstant<?> visitParenthesizedExpression(@NotNull JetParenthesizedExpression expression, Void nothing) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/AnnotationResolver$1", "visitParenthesizedExpression"));
                }
                JetExpression innerExpression = expression.getExpression();
                if (innerExpression == null) {
                    return null;
                }
                return (CompileTimeConstant)innerExpression.accept(this, null);
            }

            @Override
            public CompileTimeConstant<?> visitStringTemplateExpression(@NotNull JetStringTemplateExpression expression, Void nothing) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/AnnotationResolver$1", "visitStringTemplateExpression"));
                }
                return trace.get(BindingContext.COMPILE_TIME_VALUE, expression);
            }

            @Override
            public CompileTimeConstant<?> visitSimpleNameExpression(@NotNull JetSimpleNameExpression expression, Void data) {
                CallableDescriptor callableDescriptor;
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/AnnotationResolver$1", "visitSimpleNameExpression"));
                }
                ResolvedCall<? extends CallableDescriptor> resolvedCall = trace.getBindingContext().get(BindingContext.RESOLVED_CALL, expression);
                if (resolvedCall != null && (callableDescriptor = resolvedCall.getResultingDescriptor()) instanceof PropertyDescriptor) {
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)callableDescriptor;
                    if (AnnotationResolver.isEnumProperty(propertyDescriptor)) {
                        return new EnumValue(propertyDescriptor);
                    }
                    if (AnnotationUtils.isPropertyAcceptableAsAnnotationParameter(propertyDescriptor)) {
                        return trace.getBindingContext().get(BindingContext.COMPILE_TIME_INITIALIZER, propertyDescriptor);
                    }
                }
                return null;
            }

            @Override
            public CompileTimeConstant<?> visitQualifiedExpression(@NotNull JetQualifiedExpression expression, Void data) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/AnnotationResolver$1", "visitQualifiedExpression"));
                }
                JetExpression selectorExpression = expression.getSelectorExpression();
                if (selectorExpression != null) {
                    return (CompileTimeConstant)selectorExpression.accept(this, null);
                }
                return (CompileTimeConstant)super.visitQualifiedExpression(expression, data);
            }

            @Override
            public CompileTimeConstant<?> visitCallExpression(@NotNull JetCallExpression expression, Void data) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/AnnotationResolver$1", "visitCallExpression"));
                }
                ResolvedCall<? extends CallableDescriptor> call = trace.getBindingContext().get(BindingContext.RESOLVED_CALL, expression.getCalleeExpression());
                if (call != null) {
                    CallableDescriptor resultingDescriptor = call.getResultingDescriptor();
                    if (AnnotationUtils.isArrayMethodCall(call)) {
                        JetType type = resultingDescriptor.getValueParameters().iterator().next().getVarargElementType();
                        ArrayList<CompileTimeConstant<?>> arguments = Lists.newArrayList();
                        for (ResolvedValueArgument descriptorToArgument : call.getValueArguments().values()) {
                            arguments.addAll(AnnotationResolver.this.resolveValueArguments(descriptorToArgument, type, trace));
                        }
                        return new ArrayValue(arguments, resultingDescriptor.getReturnType());
                    }
                    if (resultingDescriptor instanceof ConstructorDescriptor) {
                        JetType constructorReturnType = resultingDescriptor.getReturnType();
                        assert (constructorReturnType != null) : "Constructor should have return type";
                        if (DescriptorUtils.isAnnotationClass(constructorReturnType.getConstructor().getDeclarationDescriptor())) {
                            AnnotationDescriptor descriptor = new AnnotationDescriptor();
                            descriptor.setAnnotationType(constructorReturnType);
                            AnnotationResolver.this.resolveAnnotationArgument(descriptor, call, trace);
                            return new AnnotationValue(descriptor);
                        }
                    }
                    if (AnnotationUtils.isJavaClassMethodCall(call)) {
                        return new JavaClassValue(resultingDescriptor.getReturnType());
                    }
                }
                return null;
            }

            @Override
            public CompileTimeConstant<?> visitJetElement(@NotNull JetElement element, Void nothing) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/AnnotationResolver$1", "visitJetElement"));
                }
                return null;
            }
        };
        return (CompileTimeConstant)expression.accept(visitor, null);
    }

    private static boolean isEnumProperty(@NotNull PropertyDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "isEnumProperty"));
        }
        ClassifierDescriptor classifier = descriptor.getType().getConstructor().getDeclarationDescriptor();
        return classifier != null && DescriptorUtils.isEnumClass(classifier) && DescriptorUtils.isEnumClassObject(descriptor.getContainingDeclaration());
    }

    @NotNull
    public List<AnnotationDescriptor> getResolvedAnnotations(@Nullable JetModifierList modifierList, BindingTrace trace) {
        if (modifierList == null) {
            List<AnnotationDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "getResolvedAnnotations"));
            }
            return list;
        }
        List<AnnotationDescriptor> list = this.getResolvedAnnotations(modifierList.getAnnotationEntries(), trace);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "getResolvedAnnotations"));
        }
        return list;
    }

    @NotNull
    public List<AnnotationDescriptor> getResolvedAnnotations(List<JetAnnotationEntry> annotations, BindingTrace trace) {
        ArrayList<AnnotationDescriptor> result = Lists.newArrayList();
        for (JetAnnotationEntry annotation : annotations) {
            AnnotationDescriptor annotationDescriptor = trace.get(BindingContext.ANNOTATION, annotation);
            if (annotationDescriptor == null) {
                throw new IllegalStateException("Annotation for annotation should have been resolved: " + annotation);
            }
            result.add(annotationDescriptor);
        }
        ArrayList<AnnotationDescriptor> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "getResolvedAnnotations"));
        }
        return arrayList;
    }

    public static void reportUnsupportedAnnotationForTypeParameter(@NotNull JetModifierListOwner modifierListOwner, BindingTrace trace) {
        if (modifierListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/AnnotationResolver", "reportUnsupportedAnnotationForTypeParameter"));
        }
        JetModifierList modifierList = modifierListOwner.getModifierList();
        if (modifierList == null) {
            return;
        }
        for (JetAnnotationEntry annotationEntry : modifierList.getAnnotationEntries()) {
            trace.report(Errors.UNSUPPORTED.on(annotationEntry, "Annotations for type parameters are not supported yet"));
        }
    }
}

