/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorNonRoot;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptorForObject;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetUserType;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.Importer;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

public class QualifiedExpressionResolver {
    @NotNull
    public Collection<? extends DeclarationDescriptor> analyseImportReference(@NotNull JetImportDirective importDirective, @NotNull JetScope scope, @NotNull BindingTrace trace, @NotNull ModuleDescriptor module) {
        if (importDirective == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "analyseImportReference"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "analyseImportReference"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "analyseImportReference"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "analyseImportReference"));
        }
        Collection<? extends DeclarationDescriptor> collection = this.processImportReference(importDirective, scope, scope, Importer.DO_NOTHING, trace, module, LookupMode.EVERYTHING);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "analyseImportReference"));
        }
        return collection;
    }

    @NotNull
    public Collection<? extends DeclarationDescriptor> processImportReference(@NotNull JetImportDirective importDirective, @NotNull JetScope scope, @NotNull JetScope scopeToCheckVisibility, @NotNull Importer importer, @NotNull BindingTrace trace, @NotNull ModuleDescriptor module, @NotNull LookupMode lookupMode) {
        Collection<? extends DeclarationDescriptor> descriptors;
        if (importDirective == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "processImportReference"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "processImportReference"));
        }
        if (scopeToCheckVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "processImportReference"));
        }
        if (importer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "processImportReference"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "processImportReference"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "processImportReference"));
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "processImportReference"));
        }
        if (importDirective.isAbsoluteInRootNamespace()) {
            trace.report(Errors.UNSUPPORTED.on(importDirective, "TypeHierarchyResolver"));
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "processImportReference"));
            }
            return list;
        }
        JetExpression importedReference = importDirective.getImportedReference();
        if (importedReference == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "processImportReference"));
            }
            return list;
        }
        if (importedReference instanceof JetQualifiedExpression) {
            descriptors = this.lookupDescriptorsForQualifiedExpression((JetQualifiedExpression)importedReference, scope, scopeToCheckVisibility, trace, lookupMode, lookupMode == LookupMode.EVERYTHING);
        } else {
            assert (importedReference instanceof JetSimpleNameExpression);
            descriptors = this.lookupDescriptorsForSimpleNameReference((JetSimpleNameExpression)importedReference, scope, scopeToCheckVisibility, trace, lookupMode, true, lookupMode == LookupMode.EVERYTHING);
        }
        JetSimpleNameExpression referenceExpression = JetPsiUtil.getLastReference(importedReference);
        if (importDirective.isAllUnder()) {
            if (referenceExpression == null || !this.canImportMembersFrom(descriptors, referenceExpression, trace, lookupMode)) {
                List list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "processImportReference"));
                }
                return list;
            }
            for (DeclarationDescriptor declarationDescriptor : descriptors) {
                importer.addAllUnderImport(declarationDescriptor, module.getPlatformToKotlinClassMap());
            }
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "processImportReference"));
            }
            return list;
        }
        Name aliasName = JetPsiUtil.getAliasName(importDirective);
        if (aliasName == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "processImportReference"));
            }
            return list;
        }
        for (DeclarationDescriptor declarationDescriptor : descriptors) {
            importer.addAliasImport(declarationDescriptor, aliasName);
        }
        Collection<? extends DeclarationDescriptor> collection = descriptors;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "processImportReference"));
        }
        return collection;
    }

    private boolean canImportMembersFrom(@NotNull Collection<? extends DeclarationDescriptor> descriptors, @NotNull JetSimpleNameExpression reference, @NotNull BindingTrace trace, @NotNull LookupMode lookupMode) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "canImportMembersFrom"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "canImportMembersFrom"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "canImportMembersFrom"));
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "canImportMembersFrom"));
        }
        if (lookupMode == LookupMode.ONLY_CLASSES) {
            return true;
        }
        if (descriptors.size() == 1) {
            return this.canImportMembersFrom(descriptors.iterator().next(), reference, trace, lookupMode);
        }
        TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(trace, "trace to find out if members can be imported from", reference);
        boolean canImport = false;
        for (DeclarationDescriptor declarationDescriptor : descriptors) {
            canImport |= this.canImportMembersFrom(declarationDescriptor, reference, (BindingTrace)temporaryTrace, lookupMode);
        }
        if (!canImport) {
            temporaryTrace.commit();
        }
        return canImport;
    }

    private boolean canImportMembersFrom(@NotNull DeclarationDescriptor descriptor, @NotNull JetSimpleNameExpression reference, @NotNull BindingTrace trace, @NotNull LookupMode lookupMode) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "canImportMembersFrom"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "canImportMembersFrom"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "canImportMembersFrom"));
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "canImportMembersFrom"));
        }
        assert (lookupMode == LookupMode.EVERYTHING);
        if (descriptor instanceof NamespaceDescriptor) {
            return true;
        }
        if (descriptor instanceof ClassDescriptor && !((ClassDescriptor)descriptor).getKind().isObject()) {
            return true;
        }
        trace.report(Errors.CANNOT_IMPORT_FROM_ELEMENT.on(reference, descriptor));
        return false;
    }

    @NotNull
    public Collection<? extends DeclarationDescriptor> lookupDescriptorsForUserType(@NotNull JetUserType userType, @NotNull JetScope outerScope, @NotNull BindingTrace trace) {
        if (userType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForUserType"));
        }
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForUserType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForUserType"));
        }
        if (userType.isAbsoluteInRootNamespace()) {
            trace.report(Errors.UNSUPPORTED.on(userType, "package"));
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForUserType"));
            }
            return list;
        }
        JetSimpleNameExpression referenceExpression = userType.getReferenceExpression();
        if (referenceExpression == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForUserType"));
            }
            return list;
        }
        JetUserType qualifier = userType.getQualifier();
        if (qualifier == null) {
            Collection<? extends DeclarationDescriptor> collection = this.lookupDescriptorsForSimpleNameReference(referenceExpression, outerScope, outerScope, trace, LookupMode.ONLY_CLASSES, false, true);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForUserType"));
            }
            return collection;
        }
        Collection<? extends DeclarationDescriptor> declarationDescriptors = this.lookupDescriptorsForUserType(qualifier, outerScope, trace);
        Collection<? extends DeclarationDescriptor> collection = this.lookupSelectorDescriptors(referenceExpression, declarationDescriptors, trace, outerScope, LookupMode.ONLY_CLASSES, true);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForUserType"));
        }
        return collection;
    }

    @NotNull
    public Collection<? extends DeclarationDescriptor> lookupDescriptorsForQualifiedExpression(@NotNull JetQualifiedExpression importedReference, @NotNull JetScope outerScope, @NotNull JetScope scopeToCheckVisibility, @NotNull BindingTrace trace, @NotNull LookupMode lookupMode, boolean storeResult) {
        Collection<? extends DeclarationDescriptor> declarationDescriptors;
        if (importedReference == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForQualifiedExpression"));
        }
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForQualifiedExpression"));
        }
        if (scopeToCheckVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForQualifiedExpression"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForQualifiedExpression"));
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForQualifiedExpression"));
        }
        JetExpression receiverExpression = importedReference.getReceiverExpression();
        if (receiverExpression instanceof JetQualifiedExpression) {
            declarationDescriptors = this.lookupDescriptorsForQualifiedExpression((JetQualifiedExpression)receiverExpression, outerScope, scopeToCheckVisibility, trace, lookupMode, storeResult);
        } else {
            assert (receiverExpression instanceof JetSimpleNameExpression);
            declarationDescriptors = this.lookupDescriptorsForSimpleNameReference((JetSimpleNameExpression)receiverExpression, outerScope, scopeToCheckVisibility, trace, lookupMode, true, storeResult);
        }
        JetExpression selectorExpression = importedReference.getSelectorExpression();
        if (!(selectorExpression instanceof JetSimpleNameExpression)) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForQualifiedExpression"));
            }
            return list;
        }
        JetSimpleNameExpression selector = (JetSimpleNameExpression)selectorExpression;
        JetSimpleNameExpression lastReference = JetPsiUtil.getLastReference(receiverExpression);
        if (lastReference == null || !this.canImportMembersFrom(declarationDescriptors, lastReference, trace, lookupMode)) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForQualifiedExpression"));
            }
            return list;
        }
        Collection<? extends DeclarationDescriptor> collection = this.lookupSelectorDescriptors(selector, declarationDescriptors, trace, scopeToCheckVisibility, lookupMode, storeResult);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForQualifiedExpression"));
        }
        return collection;
    }

    @NotNull
    private Collection<? extends DeclarationDescriptor> lookupSelectorDescriptors(@NotNull JetSimpleNameExpression selector, @NotNull Collection<? extends DeclarationDescriptor> declarationDescriptors, @NotNull BindingTrace trace, @NotNull JetScope scopeToCheckVisibility, @NotNull LookupMode lookupMode, boolean storeResult) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupSelectorDescriptors"));
        }
        if (declarationDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupSelectorDescriptors"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupSelectorDescriptors"));
        }
        if (scopeToCheckVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupSelectorDescriptors"));
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupSelectorDescriptors"));
        }
        HashSet<SuccessfulLookupResult> results = Sets.newHashSet();
        for (DeclarationDescriptor declarationDescriptor : declarationDescriptors) {
            if (declarationDescriptor instanceof NamespaceDescriptor) {
                this.addResult(results, this.lookupSimpleNameReference(selector, ((NamespaceDescriptor)declarationDescriptor).getMemberScope(), lookupMode, true));
            }
            if (!(declarationDescriptor instanceof ClassDescriptor)) continue;
            this.addResult(results, this.lookupSimpleNameReference(selector, this.getAppropriateScope((ClassDescriptor)declarationDescriptor, lookupMode), lookupMode, false));
            ClassDescriptor classObjectDescriptor = ((ClassDescriptor)declarationDescriptor).getClassObjectDescriptor();
            if (classObjectDescriptor == null) continue;
            this.addResult(results, this.lookupSimpleNameReference(selector, this.getAppropriateScope(classObjectDescriptor, lookupMode), lookupMode, false));
        }
        Collection<? extends DeclarationDescriptor> collection = this.filterAndStoreResolutionResult(results, selector, trace, scopeToCheckVisibility, lookupMode, storeResult);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupSelectorDescriptors"));
        }
        return collection;
    }

    @NotNull
    private JetScope getAppropriateScope(@NotNull ClassDescriptor classDescriptor, @NotNull LookupMode lookupMode) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "getAppropriateScope"));
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "getAppropriateScope"));
        }
        JetScope jetScope = lookupMode == LookupMode.ONLY_CLASSES ? classDescriptor.getUnsubstitutedInnerClassesScope() : classDescriptor.getDefaultType().getMemberScope();
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "getAppropriateScope"));
        }
        return jetScope;
    }

    private void addResult(@NotNull Set<SuccessfulLookupResult> results, @NotNull LookupResult result) {
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "addResult"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "addResult"));
        }
        if (result == LookupResult.EMPTY) {
            return;
        }
        results.add((SuccessfulLookupResult)result);
    }

    @NotNull
    public Collection<? extends DeclarationDescriptor> lookupDescriptorsForSimpleNameReference(@NotNull JetSimpleNameExpression referenceExpression, @NotNull JetScope outerScope, @NotNull JetScope scopeToCheckVisibility, @NotNull BindingTrace trace, @NotNull LookupMode lookupMode, boolean namespaceLevel, boolean storeResult) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForSimpleNameReference"));
        }
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForSimpleNameReference"));
        }
        if (scopeToCheckVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForSimpleNameReference"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForSimpleNameReference"));
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForSimpleNameReference"));
        }
        LookupResult lookupResult = this.lookupSimpleNameReference(referenceExpression, outerScope, lookupMode, namespaceLevel);
        if (lookupResult == LookupResult.EMPTY) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForSimpleNameReference"));
            }
            return list;
        }
        Collection<? extends DeclarationDescriptor> collection = this.filterAndStoreResolutionResult(Collections.singletonList((SuccessfulLookupResult)lookupResult), referenceExpression, trace, scopeToCheckVisibility, lookupMode, storeResult);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForSimpleNameReference"));
        }
        return collection;
    }

    @NotNull
    private LookupResult lookupSimpleNameReference(@NotNull JetSimpleNameExpression referenceExpression, @NotNull JetScope outerScope, @NotNull LookupMode lookupMode, boolean namespaceLevel) {
        ClassifierDescriptor classifierDescriptor;
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupSimpleNameReference"));
        }
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupSimpleNameReference"));
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupSimpleNameReference"));
        }
        Name referencedName = referenceExpression.getReferencedNameAsName();
        HashSet<DeclarationDescriptorNonRoot> descriptors = Sets.newHashSet();
        NamespaceDescriptor namespaceDescriptor = outerScope.getNamespace(referencedName);
        if (namespaceDescriptor != null) {
            descriptors.add(namespaceDescriptor);
        }
        if ((classifierDescriptor = outerScope.getClassifier(referencedName)) != null) {
            descriptors.add(classifierDescriptor);
        }
        if (lookupMode == LookupMode.ONLY_CLASSES) {
            ClassDescriptor objectDescriptor = outerScope.getObjectDescriptor(referencedName);
            if (objectDescriptor != null) {
                descriptors.add(objectDescriptor);
            }
        } else {
            descriptors.addAll(outerScope.getFunctions(referencedName));
            descriptors.addAll(outerScope.getProperties(referencedName));
            VariableDescriptor localVariable = outerScope.getLocalVariable(referencedName);
            if (localVariable != null) {
                descriptors.add(localVariable);
            }
        }
        SuccessfulLookupResult successfulLookupResult = new SuccessfulLookupResult(descriptors, outerScope, namespaceLevel);
        if (successfulLookupResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupSimpleNameReference"));
        }
        return successfulLookupResult;
    }

    @NotNull
    private Collection<? extends DeclarationDescriptor> filterAndStoreResolutionResult(@NotNull Collection<SuccessfulLookupResult> lookupResults, @NotNull JetSimpleNameExpression referenceExpression, @NotNull BindingTrace trace, @NotNull JetScope scopeToCheckVisibility, @NotNull LookupMode lookupMode, boolean storeResult) {
        Collection<Object> filteredDescriptors;
        if (lookupResults == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "filterAndStoreResolutionResult"));
        }
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "filterAndStoreResolutionResult"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "filterAndStoreResolutionResult"));
        }
        if (scopeToCheckVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "filterAndStoreResolutionResult"));
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "filterAndStoreResolutionResult"));
        }
        if (lookupResults.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "filterAndStoreResolutionResult"));
            }
            return list;
        }
        LinkedHashSet<? extends DeclarationDescriptor> descriptors = Sets.newLinkedHashSet();
        for (SuccessfulLookupResult lookupResult : lookupResults) {
            descriptors.addAll(lookupResult.descriptors);
        }
        ArrayList<JetScope> possibleResolutionScopes = Lists.newArrayList();
        for (SuccessfulLookupResult lookupResult : lookupResults) {
            if (lookupResult.descriptors.isEmpty()) continue;
            possibleResolutionScopes.add(lookupResult.resolutionScope);
        }
        if (possibleResolutionScopes.isEmpty()) {
            for (SuccessfulLookupResult lookupResult : lookupResults) {
                possibleResolutionScopes.add(lookupResult.resolutionScope);
            }
        }
        if (lookupMode == LookupMode.ONLY_CLASSES) {
            filteredDescriptors = Collections2.filter(descriptors, new Predicate<DeclarationDescriptor>(){

                @Override
                public boolean apply(@Nullable DeclarationDescriptor descriptor) {
                    return descriptor instanceof ClassifierDescriptor || descriptor instanceof NamespaceDescriptor;
                }
            });
        } else {
            filteredDescriptors = Sets.newLinkedHashSet();
            for (SuccessfulLookupResult lookupResult : lookupResults) {
                if (lookupResult.namespaceLevel) {
                    filteredDescriptors.addAll(lookupResult.descriptors);
                    continue;
                }
                filteredDescriptors.addAll(Collections2.filter(lookupResult.descriptors, new Predicate<DeclarationDescriptor>(){

                    @Override
                    public boolean apply(@Nullable DeclarationDescriptor descriptor) {
                        return descriptor instanceof NamespaceDescriptor || descriptor instanceof ClassifierDescriptor || descriptor instanceof VariableDescriptorForObject;
                    }
                }));
            }
        }
        if (storeResult) {
            this.storeResolutionResult(descriptors, filteredDescriptors, referenceExpression, possibleResolutionScopes, trace, scopeToCheckVisibility);
        }
        Collection<Object> collection = filteredDescriptors;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "filterAndStoreResolutionResult"));
        }
        return collection;
    }

    private void storeResolutionResult(@NotNull Collection<? extends DeclarationDescriptor> descriptors, @NotNull Collection<? extends DeclarationDescriptor> canBeImportedDescriptors, @NotNull JetSimpleNameExpression referenceExpression, @NotNull Collection<JetScope> possibleResolutionScopes, @NotNull BindingTrace trace, @NotNull JetScope scopeToCheckVisibility) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "storeResolutionResult"));
        }
        if (canBeImportedDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "storeResolutionResult"));
        }
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "storeResolutionResult"));
        }
        if (possibleResolutionScopes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "storeResolutionResult"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "storeResolutionResult"));
        }
        if (scopeToCheckVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "storeResolutionResult"));
        }
        assert (canBeImportedDescriptors.size() <= descriptors.size());
        assert (!possibleResolutionScopes.isEmpty());
        JetScope resolutionScope = possibleResolutionScopes.iterator().next();
        if (this.resolveClassNamespaceAmbiguity(canBeImportedDescriptors, referenceExpression, resolutionScope, trace, scopeToCheckVisibility)) {
            return;
        }
        if (descriptors.isEmpty()) {
            trace.record(BindingContext.RESOLUTION_SCOPE, referenceExpression, resolutionScope);
            trace.report(Errors.UNRESOLVED_REFERENCE.on(referenceExpression, referenceExpression));
            return;
        }
        DeclarationDescriptor descriptor = null;
        if (descriptors.size() == 1) {
            descriptor = descriptors.iterator().next();
            assert (canBeImportedDescriptors.size() <= 1);
        } else if (canBeImportedDescriptors.size() == 1) {
            descriptor = canBeImportedDescriptors.iterator().next();
        }
        if (descriptor != null) {
            trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, descriptors.iterator().next());
            trace.record(BindingContext.RESOLUTION_SCOPE, referenceExpression, resolutionScope);
            if (descriptor instanceof DeclarationDescriptorWithVisibility) {
                this.checkVisibility((DeclarationDescriptorWithVisibility)descriptor, trace, referenceExpression, scopeToCheckVisibility);
            }
        }
        if (canBeImportedDescriptors.isEmpty()) {
            assert (descriptors.size() >= 1);
            trace.report(Errors.CANNOT_BE_IMPORTED.on(referenceExpression, descriptors.iterator().next()));
            return;
        }
        if (canBeImportedDescriptors.size() > 1) {
            trace.record(BindingContext.AMBIGUOUS_REFERENCE_TARGET, referenceExpression, descriptors);
        }
    }

    private boolean resolveClassNamespaceAmbiguity(@NotNull Collection<? extends DeclarationDescriptor> filteredDescriptors, @NotNull JetSimpleNameExpression referenceExpression, @NotNull JetScope resolutionScope, @NotNull BindingTrace trace, @NotNull JetScope scopeToCheckVisibility) {
        if (filteredDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "resolveClassNamespaceAmbiguity"));
        }
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "resolveClassNamespaceAmbiguity"));
        }
        if (resolutionScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "resolveClassNamespaceAmbiguity"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "resolveClassNamespaceAmbiguity"));
        }
        if (scopeToCheckVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "resolveClassNamespaceAmbiguity"));
        }
        if (filteredDescriptors.size() == 2) {
            NamespaceDescriptor namespaceDescriptor = null;
            ClassDescriptor classDescriptor = null;
            for (DeclarationDescriptor declarationDescriptor : filteredDescriptors) {
                if (declarationDescriptor instanceof NamespaceDescriptor) {
                    namespaceDescriptor = (NamespaceDescriptor)declarationDescriptor;
                    continue;
                }
                if (!(declarationDescriptor instanceof ClassDescriptor)) continue;
                classDescriptor = (ClassDescriptor)declarationDescriptor;
            }
            if (namespaceDescriptor != null && classDescriptor != null && DescriptorUtils.getFQName(namespaceDescriptor).equalsTo(DescriptorUtils.getFQName(classDescriptor))) {
                trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, classDescriptor);
                trace.record(BindingContext.RESOLUTION_SCOPE, referenceExpression, resolutionScope);
                this.checkVisibility(classDescriptor, trace, referenceExpression, scopeToCheckVisibility);
                return true;
            }
        }
        return false;
    }

    private void checkVisibility(@NotNull DeclarationDescriptorWithVisibility descriptor, @NotNull BindingTrace trace, @NotNull JetSimpleNameExpression referenceExpression, @NotNull JetScope scopeToCheckVisibility) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "checkVisibility"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "checkVisibility"));
        }
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "checkVisibility"));
        }
        if (scopeToCheckVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "checkVisibility"));
        }
        if (!Visibilities.isVisible(descriptor, scopeToCheckVisibility.getContainingDeclaration())) {
            trace.report(Errors.INVISIBLE_REFERENCE.on(referenceExpression, descriptor, descriptor.getVisibility(), descriptor.getContainingDeclaration()));
        }
    }

    private static class SuccessfulLookupResult
    implements LookupResult {
        final Collection<? extends DeclarationDescriptor> descriptors;
        final JetScope resolutionScope;
        final boolean namespaceLevel;

        private SuccessfulLookupResult(Collection<? extends DeclarationDescriptor> descriptors, JetScope resolutionScope, boolean namespaceLevel) {
            this.descriptors = descriptors;
            this.resolutionScope = resolutionScope;
            this.namespaceLevel = namespaceLevel;
        }
    }

    private static interface LookupResult {
        public static final LookupResult EMPTY = new LookupResult(){};
    }

    public static enum LookupMode {
        ONLY_CLASSES,
        EVERYTHING;

    }
}

