/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.autocasts;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.calls.autocasts.AutoCastService;
import org.jetbrains.jet.lang.resolve.calls.autocasts.AutoCastUtils;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;

public class AutoCastServiceImpl
implements AutoCastService {
    private final DataFlowInfo dataFlowInfo;
    private final BindingContext bindingContext;

    public AutoCastServiceImpl(DataFlowInfo dataFlowInfo, BindingContext bindingContext) {
        this.dataFlowInfo = dataFlowInfo;
        this.bindingContext = bindingContext;
    }

    @Override
    @NotNull
    public List<ReceiverValue> getVariantsForReceiver(@NotNull ReceiverValue receiverValue) {
        if (receiverValue == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastServiceImpl", "getVariantsForReceiver"));
        }
        ArrayList<ReceiverValue> variants = Lists.newArrayList(AutoCastUtils.getAutoCastVariants(this.bindingContext, this.dataFlowInfo, receiverValue));
        variants.add(receiverValue);
        ArrayList<ReceiverValue> arrayList = variants;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastServiceImpl", "getVariantsForReceiver"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public DataFlowInfo getDataFlowInfo() {
        DataFlowInfo dataFlowInfo = this.dataFlowInfo;
        if (dataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastServiceImpl", "getDataFlowInfo"));
        }
        return dataFlowInfo;
    }

    @Override
    public boolean isNotNull(@NotNull ReceiverValue receiver) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastServiceImpl", "isNotNull"));
        }
        if (!receiver.getType().isNullable()) {
            return true;
        }
        List<ReceiverValue> autoCastVariants = AutoCastUtils.getAutoCastVariants(this.bindingContext, this.dataFlowInfo, receiver);
        for (ReceiverValue autoCastVariant : autoCastVariants) {
            if (autoCastVariant.getType().isNullable()) continue;
            return true;
        }
        return false;
    }
}

