/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.model;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.DelegatingBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.model.DataFlowInfoForArguments;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.calls.results.ResolutionStatus;
import org.jetbrains.jet.lang.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.JetType;

public class VariableAsFunctionResolvedCall
implements ResolvedCallWithTrace<FunctionDescriptor> {
    private final ResolvedCallWithTrace<FunctionDescriptor> functionCall;
    private final ResolvedCallWithTrace<VariableDescriptor> variableCall;

    public VariableAsFunctionResolvedCall(@NotNull ResolvedCallWithTrace<FunctionDescriptor> functionCall, @NotNull ResolvedCallWithTrace<VariableDescriptor> variableCall) {
        if (functionCall == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/model/VariableAsFunctionResolvedCall", "<init>"));
        }
        if (variableCall == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/calls/model/VariableAsFunctionResolvedCall", "<init>"));
        }
        this.functionCall = functionCall;
        this.variableCall = variableCall;
    }

    public ResolvedCallWithTrace<FunctionDescriptor> getFunctionCall() {
        return this.functionCall;
    }

    public ResolvedCallWithTrace<VariableDescriptor> getVariableCall() {
        return this.variableCall;
    }

    @Override
    @NotNull
    public FunctionDescriptor getCandidateDescriptor() {
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)this.functionCall.getResultingDescriptor();
        if (functionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/VariableAsFunctionResolvedCall", "getCandidateDescriptor"));
        }
        return functionDescriptor;
    }

    @Override
    @NotNull
    public FunctionDescriptor getResultingDescriptor() {
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)this.functionCall.getResultingDescriptor();
        if (functionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/VariableAsFunctionResolvedCall", "getResultingDescriptor"));
        }
        return functionDescriptor;
    }

    @Override
    @NotNull
    public ReceiverValue getReceiverArgument() {
        ReceiverValue receiverValue = this.variableCall.getReceiverArgument();
        if (receiverValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/VariableAsFunctionResolvedCall", "getReceiverArgument"));
        }
        return receiverValue;
    }

    @Override
    @NotNull
    public ReceiverValue getThisObject() {
        ReceiverValue receiverValue = this.variableCall.getThisObject();
        if (receiverValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/VariableAsFunctionResolvedCall", "getThisObject"));
        }
        return receiverValue;
    }

    @Override
    @NotNull
    public ExplicitReceiverKind getExplicitReceiverKind() {
        ExplicitReceiverKind explicitReceiverKind = this.variableCall.getExplicitReceiverKind();
        if (explicitReceiverKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/VariableAsFunctionResolvedCall", "getExplicitReceiverKind"));
        }
        return explicitReceiverKind;
    }

    @Override
    @NotNull
    public Map<ValueParameterDescriptor, ResolvedValueArgument> getValueArguments() {
        Map<ValueParameterDescriptor, ResolvedValueArgument> map = this.functionCall.getValueArguments();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/VariableAsFunctionResolvedCall", "getValueArguments"));
        }
        return map;
    }

    @Override
    @NotNull
    public List<ResolvedValueArgument> getValueArgumentsByIndex() {
        List<ResolvedValueArgument> list = this.functionCall.getValueArgumentsByIndex();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/VariableAsFunctionResolvedCall", "getValueArgumentsByIndex"));
        }
        return list;
    }

    @Override
    @NotNull
    public Map<TypeParameterDescriptor, JetType> getTypeArguments() {
        Map<TypeParameterDescriptor, JetType> map = this.functionCall.getTypeArguments();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/VariableAsFunctionResolvedCall", "getTypeArguments"));
        }
        return map;
    }

    @Override
    @NotNull
    public ResolutionStatus getStatus() {
        if (this.variableCall.getStatus() == ResolutionStatus.SUCCESS) {
            ResolutionStatus resolutionStatus = this.functionCall.getStatus();
            if (resolutionStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/VariableAsFunctionResolvedCall", "getStatus"));
            }
            return resolutionStatus;
        }
        ResolutionStatus resolutionStatus = this.variableCall.getStatus();
        if (resolutionStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/VariableAsFunctionResolvedCall", "getStatus"));
        }
        return resolutionStatus;
    }

    @Override
    public boolean isDirty() {
        return this.functionCall.isDirty();
    }

    @Override
    public DelegatingBindingTrace getTrace() {
        return this.variableCall.getTrace();
    }

    @Override
    public boolean isSafeCall() {
        return this.variableCall.isSafeCall();
    }

    @Override
    public boolean hasIncompleteTypeParameters() {
        return this.variableCall.hasIncompleteTypeParameters();
    }

    @Override
    @NotNull
    public ResolvedCallImpl<FunctionDescriptor> getCallToCompleteTypeArgumentInference() {
        ResolvedCallImpl<FunctionDescriptor> resolvedCallImpl = this.functionCall.getCallToCompleteTypeArgumentInference();
        if (resolvedCallImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/VariableAsFunctionResolvedCall", "getCallToCompleteTypeArgumentInference"));
        }
        return resolvedCallImpl;
    }

    @Override
    @NotNull
    public DataFlowInfoForArguments getDataFlowInfoForArguments() {
        DataFlowInfoForArguments dataFlowInfoForArguments = this.functionCall.getDataFlowInfoForArguments();
        if (dataFlowInfoForArguments == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/VariableAsFunctionResolvedCall", "getDataFlowInfoForArguments"));
        }
        return dataFlowInfoForArguments;
    }
}

