/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.constants;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class BooleanValue
implements CompileTimeConstant<Boolean> {
    public static final BooleanValue FALSE = new BooleanValue(false);
    public static final BooleanValue TRUE = new BooleanValue(true);
    private final boolean value;

    private BooleanValue(boolean value) {
        this.value = value;
    }

    @NotNull
    public static BooleanValue valueOf(boolean value) {
        BooleanValue booleanValue = value ? TRUE : FALSE;
        if (booleanValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/BooleanValue", "valueOf"));
        }
        return booleanValue;
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
        if (kotlinBuiltIns == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/constants/BooleanValue", "getType"));
        }
        JetType jetType = kotlinBuiltIns.getBooleanType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/BooleanValue", "getType"));
        }
        return jetType;
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor, D data) {
        return visitor.visitBooleanValue(this, data);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

