/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.constants;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class CharValue
implements CompileTimeConstant<Character> {
    private final char value;

    public CharValue(char value) {
        this.value = value;
    }

    @Override
    public Character getValue() {
        return Character.valueOf(this.value);
    }

    @Override
    @NotNull
    public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
        if (kotlinBuiltIns == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/constants/CharValue", "getType"));
        }
        JetType jetType = kotlinBuiltIns.getCharType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CharValue", "getType"));
        }
        return jetType;
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor, D data) {
        return visitor.visitCharValue(this, data);
    }

    public String toString() {
        return "#" + this.value + "(" + this.value + ")";
    }
}

