/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.java.resolver.ErrorReporter;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.jet.lang.resolve.kotlin.VirtualFileKotlinClass;
import org.jetbrains.jet.util.slicedmap.BasicWritableSlice;
import org.jetbrains.jet.util.slicedmap.Slices;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public class TraceBasedErrorReporter
implements ErrorReporter {
    private static final Logger LOG = Logger.getInstance(TraceBasedErrorReporter.class);
    public static final WritableSlice<VirtualFileKotlinClass, Integer> ABI_VERSION_ERRORS = new BasicWritableSlice<VirtualFileKotlinClass, Integer>(Slices.ONLY_REWRITE_TO_EQUAL, true);
    private BindingTrace trace;

    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    @Override
    public void reportIncompatibleAbiVersion(@NotNull KotlinJvmBinaryClass kotlinClass, int actualVersion) {
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedErrorReporter", "reportIncompatibleAbiVersion"));
        }
        this.trace.record(ABI_VERSION_ERRORS, (VirtualFileKotlinClass)kotlinClass, actualVersion);
    }

    @Override
    public void reportCannotInferVisibility(@NotNull CallableMemberDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedErrorReporter", "reportCannotInferVisibility"));
        }
        PsiElement element = BindingContextUtils.descriptorToDeclaration(this.trace.getBindingContext(), descriptor);
        if (element instanceof JetDeclaration) {
            this.trace.report(Errors.CANNOT_INFER_VISIBILITY.on((JetDeclaration)element));
        }
    }

    @Override
    public void reportAnnotationLoadingError(@NotNull String message, @Nullable Exception exception) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedErrorReporter", "reportAnnotationLoadingError"));
        }
        LOG.error(message, exception);
    }
}

