/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin.header;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.AbiVersionUtil;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.jet.lang.resolve.kotlin.header.IncompatibleAnnotationHeader;
import org.jetbrains.jet.lang.resolve.kotlin.header.KotlinClassHeader;
import org.jetbrains.jet.lang.resolve.kotlin.header.PackageFragmentClassHeader;
import org.jetbrains.jet.lang.resolve.kotlin.header.SerializedDataHeader;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

class ReadKotlinClassHeaderAnnotationVisitor
implements KotlinJvmBinaryClass.AnnotationVisitor {
    private int version = -1;
    @Nullable
    private String[] annotationData = null;
    @Nullable
    private HeaderType foundType = null;

    private ReadKotlinClassHeaderAnnotationVisitor() {
    }

    @Nullable
    public static KotlinClassHeader read(@NotNull KotlinJvmBinaryClass kotlinClass) {
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "read"));
        }
        ReadKotlinClassHeaderAnnotationVisitor visitor = new ReadKotlinClassHeaderAnnotationVisitor();
        kotlinClass.loadClassAnnotations(visitor);
        return visitor.createHeader();
    }

    @Nullable
    public KotlinClassHeader createHeader() {
        if (this.foundType == null) {
            return null;
        }
        if (!AbiVersionUtil.isAbiVersionCompatible(this.version)) {
            return new IncompatibleAnnotationHeader(this.version);
        }
        switch (this.foundType) {
            case CLASS: {
                return this.serializedDataHeader(SerializedDataHeader.Kind.CLASS);
            }
            case PACKAGE: {
                return this.serializedDataHeader(SerializedDataHeader.Kind.PACKAGE);
            }
            case PACKAGE_FRAGMENT: {
                return new PackageFragmentClassHeader(this.version);
            }
        }
        throw new UnsupportedOperationException("Unknown compatible HeaderType: " + (Object)((Object)this.foundType));
    }

    @Nullable
    private SerializedDataHeader serializedDataHeader(@NotNull SerializedDataHeader.Kind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "serializedDataHeader"));
        }
        if (this.annotationData == null) {
            return null;
        }
        return new SerializedDataHeader(this.version, this.annotationData, kind);
    }

    @Override
    @Nullable
    public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull JvmClassName annotationClassName) {
        if (annotationClassName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "visitAnnotation"));
        }
        HeaderType newType = HeaderType.byClassName(annotationClassName);
        if (newType == null) {
            return null;
        }
        if (this.foundType != null) {
            return null;
        }
        this.foundType = newType;
        if (newType == HeaderType.CLASS || newType == HeaderType.PACKAGE) {
            return this.kotlinClassOrPackageVisitor(annotationClassName);
        }
        if (newType == HeaderType.PACKAGE_FRAGMENT) {
            return this.kotlinPackageFragmentVisitor(annotationClassName);
        }
        return null;
    }

    @Override
    public void visitEnd() {
    }

    @NotNull
    private KotlinJvmBinaryClass.AnnotationArgumentVisitor kotlinClassOrPackageVisitor(final @NotNull JvmClassName annotationClassName) {
        if (annotationClassName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "kotlinClassOrPackageVisitor"));
        }
        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = new KotlinJvmBinaryClass.AnnotationArgumentVisitor(){

            @Override
            public void visit(@Nullable Name name, @Nullable Object value) {
                ReadKotlinClassHeaderAnnotationVisitor.this.visitIntValueForSupportedAnnotation(name, value, annotationClassName);
            }

            @Override
            public void visitEnum(@NotNull Name name, @NotNull JvmClassName enumClassName, @NotNull Name enumEntryName) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$1", "visitEnum"));
                }
                if (enumClassName == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$1", "visitEnum"));
                }
                if (enumEntryName == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$1", "visitEnum"));
                }
                ReadKotlinClassHeaderAnnotationVisitor.this.unexpectedArgument(name, annotationClassName);
            }

            @Override
            @Nullable
            public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitArray(@NotNull Name name) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$1", "visitArray"));
                }
                if (name.asString().equals("data")) {
                    return this.stringArrayVisitor();
                }
                if (AbiVersionUtil.isAbiVersionCompatible(ReadKotlinClassHeaderAnnotationVisitor.this.version)) {
                    throw new IllegalStateException("Unexpected array argument " + name + " for annotation " + annotationClassName);
                }
                return null;
            }

            @NotNull
            private KotlinJvmBinaryClass.AnnotationArgumentVisitor stringArrayVisitor() {
                final ArrayList strings = new ArrayList(1);
                KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = new KotlinJvmBinaryClass.AnnotationArgumentVisitor(){

                    @Override
                    public void visit(@Nullable Name name, @Nullable Object value) {
                        if (!(value instanceof String)) {
                            throw new IllegalStateException("Unexpected argument value: " + value);
                        }
                        strings.add((String)value);
                    }

                    @Override
                    public void visitEnum(@NotNull Name name, @NotNull JvmClassName enumClassName, @NotNull Name enumEntryName) {
                        if (name == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$1$1", "visitEnum"));
                        }
                        if (enumClassName == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$1$1", "visitEnum"));
                        }
                        if (enumEntryName == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$1$1", "visitEnum"));
                        }
                        ReadKotlinClassHeaderAnnotationVisitor.this.unexpectedArgument(name, annotationClassName);
                    }

                    @Override
                    @Nullable
                    public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitArray(@NotNull Name name) {
                        if (name == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$1$1", "visitArray"));
                        }
                        return ReadKotlinClassHeaderAnnotationVisitor.this.unexpectedArgument(name, annotationClassName);
                    }

                    @Override
                    public void visitEnd() {
                        ReadKotlinClassHeaderAnnotationVisitor.access$402(ReadKotlinClassHeaderAnnotationVisitor.this, strings.toArray(new String[strings.size()]));
                    }
                };
                if (annotationArgumentVisitor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$1", "stringArrayVisitor"));
                }
                return annotationArgumentVisitor;
            }

            @Override
            public void visitEnd() {
            }
        };
        if (annotationArgumentVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "kotlinClassOrPackageVisitor"));
        }
        return annotationArgumentVisitor;
    }

    @NotNull
    private KotlinJvmBinaryClass.AnnotationArgumentVisitor kotlinPackageFragmentVisitor(final @NotNull JvmClassName annotationClassName) {
        if (annotationClassName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "kotlinPackageFragmentVisitor"));
        }
        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = new KotlinJvmBinaryClass.AnnotationArgumentVisitor(){

            @Override
            public void visit(@Nullable Name name, @Nullable Object value) {
                ReadKotlinClassHeaderAnnotationVisitor.this.visitIntValueForSupportedAnnotation(name, value, annotationClassName);
            }

            @Override
            public void visitEnum(@NotNull Name name, @NotNull JvmClassName enumClassName, @NotNull Name enumEntryName) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$2", "visitEnum"));
                }
                if (enumClassName == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$2", "visitEnum"));
                }
                if (enumEntryName == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$2", "visitEnum"));
                }
                ReadKotlinClassHeaderAnnotationVisitor.this.unexpectedArgument(name, annotationClassName);
            }

            @Override
            @Nullable
            public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitArray(@NotNull Name name) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$2", "visitArray"));
                }
                return ReadKotlinClassHeaderAnnotationVisitor.this.unexpectedArgument(name, annotationClassName);
            }

            @Override
            public void visitEnd() {
            }
        };
        if (annotationArgumentVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "kotlinPackageFragmentVisitor"));
        }
        return annotationArgumentVisitor;
    }

    private void visitIntValueForSupportedAnnotation(@Nullable Name name, @Nullable Object value, @NotNull JvmClassName className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "visitIntValueForSupportedAnnotation"));
        }
        if (name != null && name.asString().equals("abiVersion")) {
            this.version = value == null ? -1 : (Integer)value;
        } else {
            this.unexpectedArgument(name, className);
        }
    }

    @Nullable
    private KotlinJvmBinaryClass.AnnotationArgumentVisitor unexpectedArgument(@Nullable Name name, @NotNull JvmClassName annotationClassName) {
        if (annotationClassName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "unexpectedArgument"));
        }
        if (AbiVersionUtil.isAbiVersionCompatible(this.version)) {
            throw new IllegalStateException("Unexpected argument " + name + " for annotation " + annotationClassName);
        }
        return null;
    }

    static /* synthetic */ String[] access$402(ReadKotlinClassHeaderAnnotationVisitor x0, String[] x1) {
        x0.annotationData = x1;
        return x1;
    }

    private static enum HeaderType {
        CLASS(JvmAnnotationNames.KOTLIN_CLASS),
        PACKAGE(JvmAnnotationNames.KOTLIN_PACKAGE),
        PACKAGE_FRAGMENT(JvmAnnotationNames.KOTLIN_PACKAGE_FRAGMENT),
        OLD_CLASS(JvmAnnotationNames.OLD_JET_CLASS_ANNOTATION),
        OLD_PACKAGE(JvmAnnotationNames.OLD_JET_PACKAGE_CLASS_ANNOTATION);

        @NotNull
        private final JvmClassName annotation;

        private HeaderType(@NotNull FqName annotation) {
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderType", "<init>"));
            }
            this.annotation = JvmClassName.byFqNameWithoutInnerClasses(annotation);
        }

        @Nullable
        private static HeaderType byClassName(@NotNull JvmClassName className) {
            if (className == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderType", "byClassName"));
            }
            for (HeaderType headerType : HeaderType.values()) {
                if (!className.equals(headerType.annotation)) continue;
                return headerType;
            }
            return null;
        }
    }
}

