/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import jet.Function0;
import jet.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.Importer;
import org.jetbrains.jet.lang.resolve.QualifiedExpressionResolver;
import org.jetbrains.jet.lang.resolve.lazy.ImportsProvider;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.LabelName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScopeSelectorUtil;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.storage.MemoizedFunctionToNotNull;

public class LazyImportScope
implements JetScope {
    private final ResolveSession resolveSession;
    private final NamespaceDescriptor packageDescriptor;
    private final ImportsProvider importsProvider;
    private final JetScope rootScope;
    private final BindingTrace traceForImportResolve;
    private final String debugName;
    private final MemoizedFunctionToNotNull<JetImportDirective, ImportDirectiveResolveCache> importedScopesProvider;
    private JetImportDirective directiveUnderResolve;

    public LazyImportScope(@NotNull ResolveSession resolveSession, @NotNull NamespaceDescriptor packageDescriptor, @NotNull List<JetImportDirective> imports, @NotNull BindingTrace traceForImportResolve, @NotNull String debugName) {
        if (resolveSession == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/LazyImportScope", "<init>"));
        }
        if (packageDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/lazy/LazyImportScope", "<init>"));
        }
        if (imports == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/lazy/LazyImportScope", "<init>"));
        }
        if (traceForImportResolve == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/resolve/lazy/LazyImportScope", "<init>"));
        }
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/jet/lang/resolve/lazy/LazyImportScope", "<init>"));
        }
        this.directiveUnderResolve = null;
        this.resolveSession = resolveSession;
        this.packageDescriptor = packageDescriptor;
        this.importsProvider = new ImportsProvider(resolveSession.getStorageManager(), imports);
        this.traceForImportResolve = traceForImportResolve;
        this.debugName = debugName;
        this.importedScopesProvider = resolveSession.getStorageManager().createMemoizedFunction(new Function1<JetImportDirective, ImportDirectiveResolveCache>(){

            @Override
            public ImportDirectiveResolveCache invoke(JetImportDirective directive) {
                return new ImportDirectiveResolveCache(directive);
            }
        });
        NamespaceDescriptor rootPackageDescriptor = resolveSession.getPackageDescriptorByFqName(FqName.ROOT);
        if (rootPackageDescriptor == null) {
            throw new IllegalStateException("Root package not found");
        }
        this.rootScope = rootPackageDescriptor.getMemberScope();
    }

    public static LazyImportScope createImportScopeForFile(@NotNull ResolveSession resolveSession, @NotNull NamespaceDescriptor packageDescriptor, @NotNull JetFile jetFile, @NotNull BindingTrace traceForImportResolve, @NotNull String debugName) {
        if (resolveSession == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/LazyImportScope", "createImportScopeForFile"));
        }
        if (packageDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/lazy/LazyImportScope", "createImportScopeForFile"));
        }
        if (jetFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/lazy/LazyImportScope", "createImportScopeForFile"));
        }
        if (traceForImportResolve == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/resolve/lazy/LazyImportScope", "createImportScopeForFile"));
        }
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/jet/lang/resolve/lazy/LazyImportScope", "createImportScopeForFile"));
        }
        return new LazyImportScope(resolveSession, packageDescriptor, Lists.reverse(jetFile.getImportDirectives()), traceForImportResolve, debugName);
    }

    @Nullable
    private <D extends DeclarationDescriptor> D selectFirstFromImports(final Name name, final QualifiedExpressionResolver.LookupMode lookupMode, final JetScopeSelectorUtil.ScopeByNameSelector<D> descriptorSelector) {
        return (D)((DeclarationDescriptor)this.resolveSession.getStorageManager().compute(new Function0<D>(){

            @Override
            public D invoke() {
                for (JetImportDirective directive : LazyImportScope.this.importsProvider.getImports(name)) {
                    if (directive == LazyImportScope.this.directiveUnderResolve) {
                        return null;
                    }
                    Object foundDescriptor = descriptorSelector.get(LazyImportScope.this.getImportScope(directive, lookupMode), name);
                    if (foundDescriptor == null) continue;
                    return foundDescriptor;
                }
                return null;
            }
        }));
    }

    @NotNull
    private <D extends DeclarationDescriptor> Collection<D> collectFromImports(final Name name, final QualifiedExpressionResolver.LookupMode lookupMode, final JetScopeSelectorUtil.ScopeByNameMultiSelector<D> descriptorsSelector) {
        Collection collection = (Collection)this.resolveSession.getStorageManager().compute(new Function0<Collection<D>>(){

            @Override
            public Collection<D> invoke() {
                HashSet descriptors = Sets.newHashSet();
                for (JetImportDirective directive : LazyImportScope.this.importsProvider.getImports(name)) {
                    if (directive == LazyImportScope.this.directiveUnderResolve) {
                        throw new IllegalStateException("Recursion while resolving many imports: " + directive.getText());
                    }
                    descriptors.addAll(descriptorsSelector.get(LazyImportScope.this.getImportScope(directive, lookupMode), name));
                }
                return descriptors;
            }
        });
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/LazyImportScope", "collectFromImports"));
        }
        return collection;
    }

    @NotNull
    private <D extends DeclarationDescriptor> Collection<D> collectFromImports(final QualifiedExpressionResolver.LookupMode lookupMode, final JetScopeSelectorUtil.ScopeDescriptorSelector<D> descriptorsSelector) {
        Collection collection = (Collection)this.resolveSession.getStorageManager().compute(new Function0<Collection<D>>(){

            @Override
            public Collection<D> invoke() {
                HashSet descriptors = Sets.newHashSet();
                for (JetImportDirective directive : LazyImportScope.this.importsProvider.getAllImports()) {
                    if (directive == LazyImportScope.this.directiveUnderResolve) {
                        throw new IllegalStateException("Recursion while resolving many imports: " + directive.getText());
                    }
                    descriptors.addAll(descriptorsSelector.get(LazyImportScope.this.getImportScope(directive, lookupMode)));
                }
                return descriptors;
            }
        });
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/LazyImportScope", "collectFromImports"));
        }
        return collection;
    }

    @NotNull
    private JetScope getImportScope(JetImportDirective directive, QualifiedExpressionResolver.LookupMode lookupMode) {
        JetScope jetScope = this.importedScopesProvider.invoke(directive).scopeForMode(lookupMode);
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/LazyImportScope", "getImportScope"));
        }
        return jetScope;
    }

    @Override
    @Nullable
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/LazyImportScope", "getClassifier"));
        }
        return this.selectFirstFromImports(name, QualifiedExpressionResolver.LookupMode.ONLY_CLASSES, JetScopeSelectorUtil.CLASSIFIER_DESCRIPTOR_SCOPE_SELECTOR);
    }

    @Override
    @Nullable
    public ClassDescriptor getObjectDescriptor(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/LazyImportScope", "getObjectDescriptor"));
        }
        return this.selectFirstFromImports(name, QualifiedExpressionResolver.LookupMode.ONLY_CLASSES, JetScopeSelectorUtil.NAMED_OBJECT_SCOPE_SELECTOR);
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> getObjectDescriptors() {
        Collection<ClassDescriptor> collection = this.collectFromImports(QualifiedExpressionResolver.LookupMode.ONLY_CLASSES, JetScopeSelectorUtil.OBJECTS_SCOPE_SELECTOR);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/LazyImportScope", "getObjectDescriptors"));
        }
        return collection;
    }

    @Override
    @Nullable
    public NamespaceDescriptor getNamespace(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/LazyImportScope", "getNamespace"));
        }
        return this.selectFirstFromImports(name, QualifiedExpressionResolver.LookupMode.ONLY_CLASSES, JetScopeSelectorUtil.NAMESPACE_SCOPE_SELECTOR);
    }

    @Override
    @NotNull
    public Collection<VariableDescriptor> getProperties(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/LazyImportScope", "getProperties"));
        }
        Collection<VariableDescriptor> collection = this.collectFromImports(name, QualifiedExpressionResolver.LookupMode.EVERYTHING, JetScopeSelectorUtil.NAMED_PROPERTIES_SCOPE_SELECTOR);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/LazyImportScope", "getProperties"));
        }
        return collection;
    }

    @Override
    @Nullable
    public VariableDescriptor getLocalVariable(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/LazyImportScope", "getLocalVariable"));
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<FunctionDescriptor> getFunctions(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/LazyImportScope", "getFunctions"));
        }
        Collection<FunctionDescriptor> collection = this.collectFromImports(name, QualifiedExpressionResolver.LookupMode.EVERYTHING, JetScopeSelectorUtil.NAMED_FUNCTION_SCOPE_SELECTOR);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/LazyImportScope", "getFunctions"));
        }
        return collection;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        NamespaceDescriptor namespaceDescriptor = this.packageDescriptor;
        if (namespaceDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/LazyImportScope", "getContainingDeclaration"));
        }
        return namespaceDescriptor;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(@NotNull LabelName labelName) {
        if (labelName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/LazyImportScope", "getDeclarationsByLabel"));
        }
        List<DeclarationDescriptor> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/LazyImportScope", "getDeclarationsByLabel"));
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getAllDescriptors() {
        Collection<DeclarationDescriptor> collection = this.collectFromImports(QualifiedExpressionResolver.LookupMode.EVERYTHING, JetScopeSelectorUtil.ALL_DESCRIPTORS_SCOPE_SELECTOR);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/LazyImportScope", "getAllDescriptors"));
        }
        return collection;
    }

    @Override
    @NotNull
    public List<ReceiverParameterDescriptor> getImplicitReceiversHierarchy() {
        List<ReceiverParameterDescriptor> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/LazyImportScope", "getImplicitReceiversHierarchy"));
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getOwnDeclaredDescriptors() {
        List<DeclarationDescriptor> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/LazyImportScope", "getOwnDeclaredDescriptors"));
        }
        return list;
    }

    public String toString() {
        return "LazyImportScope: " + this.debugName;
    }

    private class ImportDirectiveResolveCache {
        private final JetImportDirective directive;
        @Nullable
        private volatile ImportResolveStatus importResolveStatus;

        private ImportDirectiveResolveCache(JetImportDirective directive) {
            this.directive = directive;
        }

        private JetScope scopeForMode(final QualifiedExpressionResolver.LookupMode mode) {
            ImportResolveStatus status = this.importResolveStatus;
            if (status != null && (status.lookupMode == mode || status.lookupMode == QualifiedExpressionResolver.LookupMode.EVERYTHING)) {
                return status.scope;
            }
            return LazyImportScope.this.resolveSession.getStorageManager().compute(new Function0<JetScope>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public JetScope invoke() {
                    ImportResolveStatus cachedStatus = ImportDirectiveResolveCache.this.importResolveStatus;
                    if (cachedStatus != null && (cachedStatus.lookupMode == mode || cachedStatus.lookupMode == QualifiedExpressionResolver.LookupMode.EVERYTHING)) {
                        return cachedStatus.scope;
                    }
                    WritableScopeImpl directiveImportScope = new WritableScopeImpl(JetScope.EMPTY, LazyImportScope.this.packageDescriptor, RedeclarationHandler.DO_NOTHING, "Scope for import '" + ImportDirectiveResolveCache.this.directive.getText() + "' resolve in " + this.toString());
                    directiveImportScope.changeLockLevel(WritableScope.LockLevel.BOTH);
                    Importer.StandardImporter importer = new Importer.StandardImporter(directiveImportScope);
                    LazyImportScope.this.directiveUnderResolve = ImportDirectiveResolveCache.this.directive;
                    try {
                        LazyImportScope.this.resolveSession.getInjector().getQualifiedExpressionResolver().processImportReference(ImportDirectiveResolveCache.this.directive, LazyImportScope.this.rootScope, LazyImportScope.this.packageDescriptor.getMemberScope(), importer, LazyImportScope.this.traceForImportResolve, LazyImportScope.this.resolveSession.getRootModuleDescriptor(), mode);
                    }
                    finally {
                        LazyImportScope.this.directiveUnderResolve = null;
                        directiveImportScope.changeLockLevel(WritableScope.LockLevel.READING);
                    }
                    ImportDirectiveResolveCache.this.importResolveStatus = new ImportResolveStatus(mode, directiveImportScope);
                    return directiveImportScope;
                }
            });
        }
    }

    private static class ImportResolveStatus {
        private final QualifiedExpressionResolver.LookupMode lookupMode;
        private final JetScope scope;

        ImportResolveStatus(QualifiedExpressionResolver.LookupMode lookupMode, JetScope scope) {
            this.lookupMode = lookupMode;
            this.scope = scope;
        }
    }
}

