/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.declarations;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jet.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetMultiDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetTypedef;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSessionUtils;
import org.jetbrains.jet.lang.resolve.lazy.declarations.DeclarationProvider;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.storage.NotNullLazyValue;
import org.jetbrains.jet.storage.StorageManager;

public abstract class AbstractPsiBasedDeclarationProvider
implements DeclarationProvider {
    private final NotNullLazyValue<Index> index;

    public AbstractPsiBasedDeclarationProvider(@NotNull StorageManager storageManager) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/declarations/AbstractPsiBasedDeclarationProvider", "<init>"));
        }
        this.index = storageManager.createLazyValue(new Function0<Index>(){

            @Override
            public Index invoke() {
                Index index = new Index();
                AbstractPsiBasedDeclarationProvider.this.doCreateIndex(index);
                return index;
            }
        });
    }

    protected abstract void doCreateIndex(@NotNull Index var1);

    @Override
    public List<JetDeclaration> getAllDeclarations() {
        return this.index.invoke().allDeclarations;
    }

    @NotNull
    public List<JetNamedFunction> getFunctionDeclarations(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/declarations/AbstractPsiBasedDeclarationProvider", "getFunctionDeclarations"));
        }
        ArrayList<JetNamedFunction> arrayList = Lists.newArrayList(this.index.invoke().functions.get(name));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/declarations/AbstractPsiBasedDeclarationProvider", "getFunctionDeclarations"));
        }
        return arrayList;
    }

    @NotNull
    public List<JetProperty> getPropertyDeclarations(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/declarations/AbstractPsiBasedDeclarationProvider", "getPropertyDeclarations"));
        }
        ArrayList<JetProperty> arrayList = Lists.newArrayList(this.index.invoke().properties.get(name));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/declarations/AbstractPsiBasedDeclarationProvider", "getPropertyDeclarations"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Collection<JetClassOrObject> getClassOrObjectDeclarations(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/declarations/AbstractPsiBasedDeclarationProvider", "getClassOrObjectDeclarations"));
        }
        Collection<JetClassOrObject> collection = this.index.invoke().classesAndObjects.get(name);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/declarations/AbstractPsiBasedDeclarationProvider", "getClassOrObjectDeclarations"));
        }
        return collection;
    }

    protected static class Index {
        private final List<JetDeclaration> allDeclarations = Lists.newArrayList();
        private final Multimap<Name, JetNamedFunction> functions = HashMultimap.create();
        private final Multimap<Name, JetProperty> properties = HashMultimap.create();
        private final Multimap<Name, JetClassOrObject> classesAndObjects = ArrayListMultimap.create();

        protected Index() {
        }

        public void putToIndex(@NotNull JetDeclaration declaration) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/lazy/declarations/AbstractPsiBasedDeclarationProvider$Index", "putToIndex"));
            }
            if (declaration instanceof JetClassInitializer) {
                return;
            }
            this.allDeclarations.add(declaration);
            if (declaration instanceof JetNamedFunction) {
                JetNamedFunction namedFunction = (JetNamedFunction)declaration;
                this.functions.put(ResolveSessionUtils.safeNameForLazyResolve(namedFunction), namedFunction);
            } else if (declaration instanceof JetProperty) {
                JetProperty property = (JetProperty)declaration;
                this.properties.put(ResolveSessionUtils.safeNameForLazyResolve(property), property);
            } else if (declaration instanceof JetClassOrObject) {
                JetClassOrObject classOrObject = (JetClassOrObject)declaration;
                this.classesAndObjects.put(ResolveSessionUtils.safeNameForLazyResolve(classOrObject.getNameAsName()), classOrObject);
            } else if (!(declaration instanceof JetParameter || declaration instanceof JetTypedef || declaration instanceof JetMultiDeclaration)) {
                throw new IllegalArgumentException("Unknown declaration: " + declaration);
            }
        }
    }
}

