/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.ref;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

class SimpleParser {
    private final String input;
    private int position;

    public SimpleParser(@NotNull String input) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/ref/SimpleParser", "<init>"));
        }
        this.position = 0;
        this.input = input;
    }

    public void checkEof() {
        if (!this.lookingAtEof()) {
            throw new IllegalStateException("expecting EOF");
        }
    }

    public void checkNotEof() {
        if (this.lookingAtEof()) {
            throw new IllegalStateException("unexpected EOF");
        }
    }

    public boolean lookingAtEof() {
        return this.position == this.input.length();
    }

    public char peek() {
        this.checkNotEof();
        return this.input.charAt(this.position);
    }

    public boolean lookingAt(char c) {
        return !this.lookingAtEof() && this.peek() == c;
    }

    public char next() {
        this.checkNotEof();
        return this.input.charAt(this.position++);
    }

    public void consume(char c) {
        char next = this.next();
        if (next != c) {
            throw new IllegalStateException("invalid next, expecting " + c + ", actual " + next);
        }
    }

    public boolean consumeIfLookingAt(char c) {
        if (this.lookingAt(c)) {
            this.consume(c);
            return true;
        }
        return false;
    }

    @NotNull
    public String consume(@NotNull Pattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/ref/SimpleParser", "consume"));
        }
        Matcher matcher = pattern.matcher(this.input.substring(this.position));
        if (!matcher.lookingAt()) {
            throw new IllegalStateException("expecting " + pattern + " at pos " + this.position);
        }
        String r = matcher.group();
        this.position += r.length();
        String string = r;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ref/SimpleParser", "consume"));
        }
        return string;
    }
}

