/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.renderer;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.renderer.DescriptorRendererBuilder;
import org.jetbrains.jet.renderer.Renderer;

public interface DescriptorRenderer
extends Renderer<DeclarationDescriptor> {
    public static final DescriptorRenderer COMPACT_WITH_MODIFIERS = new DescriptorRendererBuilder().setWithDefinedIn(false).build();
    public static final DescriptorRenderer SOURCE_CODE = new DescriptorRendererBuilder().setNormalizedVisibilities(true).setWithDefinedIn(false).setShortNames(false).setShowInternalKeyword(false).setOverrideRenderingPolicy(OverrideRenderingPolicy.RENDER_OVERRIDE).setUnitReturnType(false).build();
    public static final DescriptorRenderer SOURCE_CODE_SHORT_NAMES_IN_TYPES = new DescriptorRendererBuilder().setNormalizedVisibilities(true).setWithDefinedIn(false).setShortNames(true).setShowInternalKeyword(false).setOverrideRenderingPolicy(OverrideRenderingPolicy.RENDER_OVERRIDE).setUnitReturnType(false).build();
    public static final DescriptorRenderer COMPACT = new DescriptorRendererBuilder().setWithDefinedIn(false).setModifiers(new Modifier[0]).build();
    public static final DescriptorRenderer STARTS_FROM_NAME = new DescriptorRendererBuilder().setWithDefinedIn(false).setModifiers(new Modifier[0]).setStartFromName(true).build();
    public static final DescriptorRenderer TEXT = new DescriptorRendererBuilder().build();
    public static final DescriptorRenderer SHORT_NAMES_IN_TYPES = new DescriptorRendererBuilder().setShortNames(true).build();
    public static final DescriptorRenderer DEBUG_TEXT = new DescriptorRendererBuilder().setDebugMode(true).build();
    public static final DescriptorRenderer HTML = new DescriptorRendererBuilder().setTextFormat(TextFormat.HTML).build();

    @NotNull
    public String renderType(@NotNull JetType var1);

    @Override
    @NotNull
    public String render(@NotNull DeclarationDescriptor var1);

    @NotNull
    public String renderFunctionParameters(@NotNull FunctionDescriptor var1);

    public static class DefaultValueParameterHandler
    implements ValueParametersHandler {
        @Override
        public void appendBeforeValueParameters(@NotNull FunctionDescriptor function, @NotNull StringBuilder stringBuilder) {
            if (function == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/renderer/DescriptorRenderer$DefaultValueParameterHandler", "appendBeforeValueParameters"));
            }
            if (stringBuilder == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/renderer/DescriptorRenderer$DefaultValueParameterHandler", "appendBeforeValueParameters"));
            }
            stringBuilder.append("(");
        }

        @Override
        public void appendAfterValueParameters(@NotNull FunctionDescriptor function, @NotNull StringBuilder stringBuilder) {
            if (function == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/renderer/DescriptorRenderer$DefaultValueParameterHandler", "appendAfterValueParameters"));
            }
            if (stringBuilder == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/renderer/DescriptorRenderer$DefaultValueParameterHandler", "appendAfterValueParameters"));
            }
            stringBuilder.append(")");
        }

        @Override
        public void appendBeforeValueParameter(@NotNull ValueParameterDescriptor parameter, @NotNull StringBuilder stringBuilder) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/renderer/DescriptorRenderer$DefaultValueParameterHandler", "appendBeforeValueParameter"));
            }
            if (stringBuilder == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/renderer/DescriptorRenderer$DefaultValueParameterHandler", "appendBeforeValueParameter"));
            }
        }

        @Override
        public void appendAfterValueParameter(@NotNull ValueParameterDescriptor parameter, @NotNull StringBuilder stringBuilder) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/renderer/DescriptorRenderer$DefaultValueParameterHandler", "appendAfterValueParameter"));
            }
            if (stringBuilder == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/renderer/DescriptorRenderer$DefaultValueParameterHandler", "appendAfterValueParameter"));
            }
            FunctionDescriptor function = (FunctionDescriptor)parameter.getContainingDeclaration();
            if (parameter.getIndex() != function.getValueParameters().size() - 1) {
                stringBuilder.append(", ");
            }
        }
    }

    public static interface ValueParametersHandler {
        public void appendBeforeValueParameters(@NotNull FunctionDescriptor var1, @NotNull StringBuilder var2);

        public void appendAfterValueParameters(@NotNull FunctionDescriptor var1, @NotNull StringBuilder var2);

        public void appendBeforeValueParameter(@NotNull ValueParameterDescriptor var1, @NotNull StringBuilder var2);

        public void appendAfterValueParameter(@NotNull ValueParameterDescriptor var1, @NotNull StringBuilder var2);
    }

    public static enum Modifier {
        VISIBILITY,
        MODALITY,
        OVERRIDE,
        ANNOTATIONS,
        INNER,
        MEMBER_KIND;

    }

    public static enum OverrideRenderingPolicy {
        RENDER_OVERRIDE,
        RENDER_OPEN,
        RENDER_OPEN_OVERRIDE;

    }

    public static enum TextFormat {
        PLAIN,
        HTML;

    }
}

