/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.utils;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.utils.KotlinPaths;

public class KotlinPathsFromHomeDir
implements KotlinPaths {
    private final File homePath;

    public KotlinPathsFromHomeDir(@NotNull File homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/utils/KotlinPathsFromHomeDir", "<init>"));
        }
        this.homePath = homePath;
    }

    @Override
    @NotNull
    public File getHomePath() {
        File file = this.homePath;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/utils/KotlinPathsFromHomeDir", "getHomePath"));
        }
        return file;
    }

    @Override
    @NotNull
    public File getLibPath() {
        File file = new File(this.homePath, "lib");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/utils/KotlinPathsFromHomeDir", "getLibPath"));
        }
        return file;
    }

    @Override
    @NotNull
    public File getRuntimePath() {
        File file = this.getLibraryFile("kotlin-runtime.jar");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/utils/KotlinPathsFromHomeDir", "getRuntimePath"));
        }
        return file;
    }

    @Override
    @NotNull
    public File getRuntimeSourcesPath() {
        File file = this.getLibraryFile("kotlin-runtime-sources.jar");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/utils/KotlinPathsFromHomeDir", "getRuntimeSourcesPath"));
        }
        return file;
    }

    @Override
    @NotNull
    public File getJdkAnnotationsPath() {
        File file = this.getLibraryFile("kotlin-jdk-annotations.jar");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/utils/KotlinPathsFromHomeDir", "getJdkAnnotationsPath"));
        }
        return file;
    }

    @Override
    @NotNull
    public File getAndroidSdkAnnotationsPath() {
        File file = this.getLibraryFile("kotlin-android-sdk-annotations.jar");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/utils/KotlinPathsFromHomeDir", "getAndroidSdkAnnotationsPath"));
        }
        return file;
    }

    @Override
    @NotNull
    public File getJsLibJsPath() {
        File file = this.getLibraryFile("kotlin.js");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/utils/KotlinPathsFromHomeDir", "getJsLibJsPath"));
        }
        return file;
    }

    @Override
    @NotNull
    public File getJsLibJarPath() {
        File file = this.getLibraryFile("kotlin-jslib.jar");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/utils/KotlinPathsFromHomeDir", "getJsLibJarPath"));
        }
        return file;
    }

    @NotNull
    private File getLibraryFile(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/utils/KotlinPathsFromHomeDir", "getLibraryFile"));
        }
        File file = new File(this.getLibPath(), fileName);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/utils/KotlinPathsFromHomeDir", "getLibraryFile"));
        }
        return file;
    }
}

