/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNumberLiteral;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetEscapeStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetLiteralStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntryWithExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateExpression;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.intrinsic.functions.factories.TopLevelFIF;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.NamePredicate;
import org.jetbrains.k2js.translate.utils.ErrorReportingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;

public final class StringTemplateTranslator
extends AbstractTranslator {
    private final JetStringTemplateEntry[] expressionEntries;

    @NotNull
    public static JsExpression translate(@NotNull JetStringTemplateExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/StringTemplateTranslator", "translate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/expression/StringTemplateTranslator", "translate"));
        }
        JsExpression jsExpression = new StringTemplateTranslator(expression, context).translate();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/StringTemplateTranslator", "translate"));
        }
        return jsExpression;
    }

    private StringTemplateTranslator(@NotNull JetStringTemplateExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/StringTemplateTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/expression/StringTemplateTranslator", "<init>"));
        }
        super(context);
        this.expressionEntries = expression.getEntries();
        assert (this.expressionEntries.length != 0) : ErrorReportingUtils.message(expression, "String template must have one or more entries.");
    }

    @NotNull
    private JsExpression translate() {
        EntryVisitor entryVisitor = new EntryVisitor();
        for (JetStringTemplateEntry entry : this.expressionEntries) {
            entry.accept(entryVisitor);
        }
        JsExpression jsExpression = entryVisitor.getResultingExpression();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/StringTemplateTranslator", "translate"));
        }
        return jsExpression;
    }

    private final class EntryVisitor
    extends JetVisitorVoid {
        @Nullable
        private JsExpression resultingExpression = null;

        private EntryVisitor() {
        }

        void append(@NotNull JsExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/StringTemplateTranslator$EntryVisitor", "append"));
            }
            this.resultingExpression = this.resultingExpression == null ? expression : JsAstUtils.sum(this.resultingExpression, expression);
        }

        @Override
        public void visitStringTemplateEntryWithExpression(@NotNull JetStringTemplateEntryWithExpression entry) {
            if (entry == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/StringTemplateTranslator$EntryVisitor", "visitStringTemplateEntryWithExpression"));
            }
            JetExpression entryExpression = entry.getExpression();
            assert (entryExpression != null) : "JetStringTemplateEntryWithExpression must have not null entry expression.";
            JsExpression translatedExpression = Translation.translateAsExpression(entryExpression, StringTemplateTranslator.this.context());
            if (translatedExpression instanceof JsNumberLiteral) {
                this.append(StringTemplateTranslator.this.context().program().getStringLiteral(translatedExpression.toString()));
                return;
            }
            JetType type = StringTemplateTranslator.this.context().bindingContext().get(BindingContext.EXPRESSION_TYPE, entryExpression);
            if (type == null || type.isNullable()) {
                this.append(TopLevelFIF.TO_STRING.apply((JsExpression)null, Collections.singletonList(translatedExpression), StringTemplateTranslator.this.context()));
            } else if (this.mustCallToString(type)) {
                this.append(new JsInvocation(new JsNameRef("toString", translatedExpression)));
            } else {
                this.append(translatedExpression);
            }
        }

        private boolean mustCallToString(@NotNull JetType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/StringTemplateTranslator$EntryVisitor", "mustCallToString"));
            }
            Name typeName = JsDescriptorUtils.getNameIfStandardType(type);
            if (typeName != null) {
                if (NamePredicate.STRING.apply(typeName)) {
                    return false;
                }
                if (NamePredicate.PRIMITIVE_NUMBERS.apply(typeName)) {
                    return this.resultingExpression == null;
                }
            }
            return StringTemplateTranslator.this.expressionEntries.length == 1;
        }

        @Override
        public void visitLiteralStringTemplateEntry(@NotNull JetLiteralStringTemplateEntry entry) {
            if (entry == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/StringTemplateTranslator$EntryVisitor", "visitLiteralStringTemplateEntry"));
            }
            this.appendText(entry.getText());
        }

        @Override
        public void visitEscapeStringTemplateEntry(@NotNull JetEscapeStringTemplateEntry entry) {
            if (entry == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/StringTemplateTranslator$EntryVisitor", "visitEscapeStringTemplateEntry"));
            }
            this.appendText(entry.getUnescapedValue());
        }

        private void appendText(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/expression/StringTemplateTranslator$EntryVisitor", "appendText"));
            }
            this.append(StringTemplateTranslator.this.program().getStringLiteral(text));
        }

        @NotNull
        public JsExpression getResultingExpression() {
            assert (this.resultingExpression != null);
            JsExpression jsExpression = this.resultingExpression;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/StringTemplateTranslator$EntryVisitor", "getResultingExpression"));
            }
            return jsExpression;
        }
    }
}

