/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.operation;

import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsConditional;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.intrinsic.operation.BinaryOperationIntrinsic;
import org.jetbrains.k2js.translate.operation.AssignmentTranslator;
import org.jetbrains.k2js.translate.operation.CompareToTranslator;
import org.jetbrains.k2js.translate.operation.OperatorTable;
import org.jetbrains.k2js.translate.reference.CallBuilder;
import org.jetbrains.k2js.translate.reference.CallType;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class BinaryOperationTranslator
extends AbstractTranslator {
    @NotNull
    private final JetBinaryExpression expression;
    @Nullable
    private final FunctionDescriptor operationDescriptor;

    @NotNull
    public static JsExpression translate(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/operation/BinaryOperationTranslator", "translate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/operation/BinaryOperationTranslator", "translate"));
        }
        JsExpression jsExpression = new BinaryOperationTranslator(expression, context).translate();
        JsExpression jsExpression2 = jsExpression.source(expression);
        if (jsExpression2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/BinaryOperationTranslator", "translate"));
        }
        return jsExpression2;
    }

    @NotNull
    static JsExpression translateAsOverloadedCall(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/operation/BinaryOperationTranslator", "translateAsOverloadedCall"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/operation/BinaryOperationTranslator", "translateAsOverloadedCall"));
        }
        JsExpression jsExpression = new BinaryOperationTranslator(expression, context).translateAsOverloadedBinaryOperation();
        JsExpression jsExpression2 = jsExpression.source(expression);
        if (jsExpression2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/BinaryOperationTranslator", "translateAsOverloadedCall"));
        }
        return jsExpression2;
    }

    private BinaryOperationTranslator(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/operation/BinaryOperationTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/operation/BinaryOperationTranslator", "<init>"));
        }
        super(context);
        this.expression = expression;
        this.operationDescriptor = BindingUtils.getFunctionDescriptorForOperationExpression(this.bindingContext(), expression);
    }

    @NotNull
    private JsExpression translate() {
        BinaryOperationIntrinsic intrinsic = this.getIntrinsicForExpression();
        if (intrinsic != null) {
            JsExpression jsExpression = this.applyIntrinsic(intrinsic);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/BinaryOperationTranslator", "translate"));
            }
            return jsExpression;
        }
        if (PsiUtils.getOperationToken(this.expression).equals(JetTokens.ELVIS)) {
            JsConditional jsConditional = TranslationUtils.notNullConditional(TranslationUtils.translateLeftExpression(this.context(), this.expression), TranslationUtils.translateRightExpression(this.context(), this.expression), this.context());
            if (jsConditional == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/BinaryOperationTranslator", "translate"));
            }
            return jsConditional;
        }
        if (AssignmentTranslator.isAssignmentOperator(this.expression)) {
            JsExpression jsExpression = AssignmentTranslator.translate(this.expression, this.context());
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/BinaryOperationTranslator", "translate"));
            }
            return jsExpression;
        }
        if (this.isNotOverloadable()) {
            JsExpression jsExpression = this.translateAsUnOverloadableBinaryOperation();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/BinaryOperationTranslator", "translate"));
            }
            return jsExpression;
        }
        if (CompareToTranslator.isCompareToCall(this.expression, this.context())) {
            JsExpression jsExpression = CompareToTranslator.translate(this.expression, this.context());
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/BinaryOperationTranslator", "translate"));
            }
            return jsExpression;
        }
        assert (this.operationDescriptor != null) : "Overloadable operations must have not null descriptor";
        JsExpression jsExpression = this.translateAsOverloadedBinaryOperation();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/BinaryOperationTranslator", "translate"));
        }
        return jsExpression;
    }

    @Nullable
    private BinaryOperationIntrinsic getIntrinsicForExpression() {
        return this.context().intrinsics().getBinaryOperationIntrinsics().getIntrinsic(this.expression, this.context());
    }

    @NotNull
    private JsExpression applyIntrinsic(@NotNull BinaryOperationIntrinsic intrinsic) {
        if (intrinsic == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/operation/BinaryOperationTranslator", "applyIntrinsic"));
        }
        JsExpression jsExpression = intrinsic.apply(this.expression, TranslationUtils.translateLeftExpression(this.context(), this.expression), TranslationUtils.translateRightExpression(this.context(), this.expression), this.context());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/BinaryOperationTranslator", "applyIntrinsic"));
        }
        return jsExpression;
    }

    private boolean isNotOverloadable() {
        return this.operationDescriptor == null;
    }

    @NotNull
    private JsExpression translateAsUnOverloadableBinaryOperation() {
        JetToken token = PsiUtils.getOperationToken(this.expression);
        JsBinaryOperator operator = OperatorTable.getBinaryOperator(token);
        assert (OperatorConventions.NOT_OVERLOADABLE.contains(token));
        JsExpression left = TranslationUtils.translateLeftExpression(this.context(), this.expression);
        JsExpression right = TranslationUtils.translateRightExpression(this.context(), this.expression);
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(operator, left, right);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/BinaryOperationTranslator", "translateAsUnOverloadableBinaryOperation"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    private JsExpression translateAsOverloadedBinaryOperation() {
        CallBuilder callBuilder = this.setReceiverAndArguments();
        ResolvedCall<?> resolvedCall = BindingUtils.getResolvedCall(this.bindingContext(), this.expression.getOperationReference());
        JsExpression result = callBuilder.resolvedCall(resolvedCall).type(CallType.NORMAL).translate();
        JsExpression jsExpression = this.mayBeWrapWithNegation(result);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/BinaryOperationTranslator", "translateAsOverloadedBinaryOperation"));
        }
        return jsExpression;
    }

    @NotNull
    private CallBuilder setReceiverAndArguments() {
        CallBuilder callBuilder = CallBuilder.build(this.context());
        JsExpression leftExpression = TranslationUtils.translateLeftExpression(this.context(), this.expression);
        JsExpression rightExpression = TranslationUtils.translateRightExpression(this.context(), this.expression);
        if (PsiUtils.isInOrNotInOperation(this.expression)) {
            CallBuilder callBuilder2 = callBuilder.receiver(rightExpression).args(leftExpression);
            if (callBuilder2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/BinaryOperationTranslator", "setReceiverAndArguments"));
            }
            return callBuilder2;
        }
        CallBuilder callBuilder3 = callBuilder.receiver(leftExpression).args(rightExpression);
        if (callBuilder3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/BinaryOperationTranslator", "setReceiverAndArguments"));
        }
        return callBuilder3;
    }

    @NotNull
    private JsExpression mayBeWrapWithNegation(@NotNull JsExpression result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/operation/BinaryOperationTranslator", "mayBeWrapWithNegation"));
        }
        if (PsiUtils.isNegatedOperation(this.expression)) {
            JsPrefixOperation jsPrefixOperation = JsAstUtils.not(result);
            if (jsPrefixOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/BinaryOperationTranslator", "mayBeWrapWithNegation"));
            }
            return jsPrefixOperation;
        }
        JsExpression jsExpression = result;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/BinaryOperationTranslator", "mayBeWrapWithNegation"));
        }
        return jsExpression;
    }
}

