/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.reference.CachedAccessTranslator;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class BackingFieldAccessTranslator
extends AbstractTranslator
implements CachedAccessTranslator {
    @NotNull
    private final PropertyDescriptor descriptor;

    static BackingFieldAccessTranslator newInstance(@NotNull JetSimpleNameExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/BackingFieldAccessTranslator", "newInstance"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/reference/BackingFieldAccessTranslator", "newInstance"));
        }
        assert (JetPsiUtil.isBackingFieldReference(expression));
        DeclarationDescriptor referencedProperty = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), expression);
        assert (referencedProperty instanceof PropertyDescriptor);
        return new BackingFieldAccessTranslator((PropertyDescriptor)referencedProperty, context);
    }

    private BackingFieldAccessTranslator(@NotNull PropertyDescriptor descriptor, @NotNull TranslationContext context) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/BackingFieldAccessTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/reference/BackingFieldAccessTranslator", "<init>"));
        }
        super(context);
        this.descriptor = descriptor;
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        JsNameRef jsNameRef = TranslationUtils.backingFieldReference(this.context(), this.descriptor);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/BackingFieldAccessTranslator", "translateAsGet"));
        }
        return jsNameRef;
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression setTo) {
        if (setTo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/BackingFieldAccessTranslator", "translateAsSet"));
        }
        JsExpression jsExpression = TranslationUtils.assignmentToBackingField(this.context(), this.descriptor, setTo);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/BackingFieldAccessTranslator", "translateAsSet"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public CachedAccessTranslator getCached() {
        BackingFieldAccessTranslator backingFieldAccessTranslator = this;
        if (backingFieldAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/BackingFieldAccessTranslator", "getCached"));
        }
        return backingFieldAccessTranslator;
    }

    @Override
    @NotNull
    public List<TemporaryVariable> declaredTemporaries() {
        List<TemporaryVariable> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/BackingFieldAccessTranslator", "declaredTemporaries"));
        }
        return list;
    }
}

