/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ClassReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ThisReceiver;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.reference.CallBuilder;
import org.jetbrains.k2js.translate.reference.CallParameters;
import org.jetbrains.k2js.translate.reference.ReferenceTranslator;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;

public final class CallParametersResolver {
    @Nullable
    private final JsExpression qualifier;
    @Nullable
    private final JsExpression callee;
    @NotNull
    private final CallableDescriptor descriptor;
    @NotNull
    private final TranslationContext context;
    @NotNull
    private final ResolvedCall<? extends CallableDescriptor> resolvedCall;
    private final boolean isExtensionCall;

    public static CallParameters resolveCallParameters(@Nullable JsExpression qualifier, @Nullable JsExpression callee, @NotNull CallableDescriptor descriptor, @NotNull ResolvedCall<? extends CallableDescriptor> call, @NotNull TranslationContext context) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/k2js/translate/reference/CallParametersResolver", "resolveCallParameters"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/k2js/translate/reference/CallParametersResolver", "resolveCallParameters"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/k2js/translate/reference/CallParametersResolver", "resolveCallParameters"));
        }
        return new CallParametersResolver(qualifier, callee, descriptor, call, context).resolve();
    }

    private CallParametersResolver(@Nullable JsExpression qualifier, @Nullable JsExpression callee, @NotNull CallableDescriptor descriptor, @NotNull ResolvedCall<? extends CallableDescriptor> call, @NotNull TranslationContext context) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/k2js/translate/reference/CallParametersResolver", "<init>"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/k2js/translate/reference/CallParametersResolver", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/k2js/translate/reference/CallParametersResolver", "<init>"));
        }
        this.qualifier = qualifier;
        this.callee = callee;
        this.descriptor = descriptor;
        this.context = context;
        this.resolvedCall = call;
        this.isExtensionCall = this.resolvedCall.getReceiverArgument().exists();
    }

    @NotNull
    private CallParameters resolve() {
        JsExpression receiver = this.isExtensionCall ? this.getExtensionFunctionCallReceiver() : null;
        JsExpression functionReference = this.getFunctionReference();
        JsExpression thisObject = this.getThisObject();
        CallParameters callParameters = new CallParameters(receiver, functionReference, thisObject);
        if (callParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallParametersResolver", "resolve"));
        }
        return callParameters;
    }

    @NotNull
    private JsExpression getFunctionReference() {
        if (this.callee != null) {
            JsExpression jsExpression = this.callee;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallParametersResolver", "getFunctionReference"));
            }
            return jsExpression;
        }
        if (!(this.resolvedCall instanceof VariableAsFunctionResolvedCall)) {
            JsExpression jsExpression = ReferenceTranslator.translateAsLocalNameReference(this.descriptor, this.context);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallParametersResolver", "getFunctionReference"));
            }
            return jsExpression;
        }
        ResolvedCallWithTrace<FunctionDescriptor> call = ((VariableAsFunctionResolvedCall)this.resolvedCall).getFunctionCall();
        JsExpression jsExpression = CallBuilder.build(this.context).resolvedCall(call).translate();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallParametersResolver", "getFunctionReference"));
        }
        return jsExpression;
    }

    @Nullable
    private JsExpression getThisObject() {
        if (this.qualifier != null && !this.isExtensionCall) {
            return this.qualifier;
        }
        ReceiverValue thisObject = this.resolvedCall.getThisObject();
        if (!thisObject.exists()) {
            return null;
        }
        if (thisObject instanceof ClassReceiver) {
            JsExpression ref = this.context.getAliasForDescriptor(((ClassReceiver)thisObject).getDeclarationDescriptor());
            return ref == null ? JsLiteral.THIS : ref;
        }
        if (thisObject instanceof ExtensionReceiver) {
            return this.context.getAliasForDescriptor(JsDescriptorUtils.getDeclarationDescriptorForReceiver(thisObject));
        }
        return this.resolvedCall.getReceiverArgument().exists() && this.resolvedCall.getExplicitReceiverKind().isThisObject() ? JsLiteral.THIS : null;
    }

    @NotNull
    private JsExpression getExtensionFunctionCallReceiver() {
        if (this.qualifier != null) {
            JsExpression jsExpression = this.qualifier;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallParametersResolver", "getExtensionFunctionCallReceiver"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = this.context.getThisObject(((ThisReceiver)this.resolvedCall.getReceiverArgument()).getDeclarationDescriptor());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/CallParametersResolver", "getExtensionFunctionCallReceiver"));
        }
        return jsExpression;
    }
}

