/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.common.collect.Maps;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsReturn;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.intellij.util.SmartList;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.reference.AbstractCallExpressionTranslator;
import org.jetbrains.k2js.translate.reference.CallArgumentTranslator;
import org.jetbrains.k2js.translate.reference.CallParameters;
import org.jetbrains.k2js.translate.reference.CallParametersResolver;
import org.jetbrains.k2js.translate.reference.CallType;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.mutator.LastExpressionMutator;
import org.jetbrains.k2js.translate.utils.mutator.Mutator;

public final class InlinedCallExpressionTranslator
extends AbstractCallExpressionTranslator {
    public static boolean shouldBeInlined(@NotNull JetCallExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/InlinedCallExpressionTranslator", "shouldBeInlined"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/reference/InlinedCallExpressionTranslator", "shouldBeInlined"));
        }
        return false;
    }

    @NotNull
    public static JsExpression translate(@NotNull JetCallExpression expression, @Nullable JsExpression receiver, @NotNull CallType callType, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/InlinedCallExpressionTranslator", "translate"));
        }
        if (callType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/k2js/translate/reference/InlinedCallExpressionTranslator", "translate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/k2js/translate/reference/InlinedCallExpressionTranslator", "translate"));
        }
        JsExpression jsExpression = new InlinedCallExpressionTranslator(expression, receiver, callType, context).translate();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/InlinedCallExpressionTranslator", "translate"));
        }
        return jsExpression;
    }

    private InlinedCallExpressionTranslator(@NotNull JetCallExpression expression, @Nullable JsExpression receiver, @NotNull CallType callType, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/InlinedCallExpressionTranslator", "<init>"));
        }
        if (callType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/k2js/translate/reference/InlinedCallExpressionTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/k2js/translate/reference/InlinedCallExpressionTranslator", "<init>"));
        }
        super(expression, receiver, callType, context);
    }

    @NotNull
    private JsExpression translate() {
        TranslationContext contextWithAllParametersAliased = this.createContextForInlining();
        JsBlock translatedBody = FunctionBodyTranslator.translateFunctionBody(this.getFunctionDescriptor(), this.getFunctionBody(), contextWithAllParametersAliased);
        TemporaryVariable temporaryVariable = contextWithAllParametersAliased.declareTemporary(JsLiteral.NULL);
        JsStatement mutatedBody = LastExpressionMutator.mutateLastExpression(translatedBody, new InlineFunctionMutator(temporaryVariable));
        this.context().addStatementToCurrentBlock(JsAstUtils.convertToBlock(mutatedBody));
        JsNameRef jsNameRef = temporaryVariable.reference();
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/InlinedCallExpressionTranslator", "translate"));
        }
        return jsNameRef;
    }

    @NotNull
    private JetFunction getFunctionBody() {
        JetFunction jetFunction = BindingUtils.getFunctionForDescriptor(this.bindingContext(), this.getFunctionDescriptor());
        if (jetFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/InlinedCallExpressionTranslator", "getFunctionBody"));
        }
        return jetFunction;
    }

    @NotNull
    private SimpleFunctionDescriptor getFunctionDescriptor() {
        CallableDescriptor descriptor = this.resolvedCall.getCandidateDescriptor().getOriginal();
        assert (descriptor instanceof SimpleFunctionDescriptor) : "Inlined functions should have descriptor of type SimpleFunctionDescriptor";
        SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)descriptor;
        if (simpleFunctionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/InlinedCallExpressionTranslator", "getFunctionDescriptor"));
        }
        return simpleFunctionDescriptor;
    }

    @NotNull
    private TranslationContext createContextForInlining() {
        TranslationContext contextForInlining = this.context();
        contextForInlining = this.createContextWithAliasForThisExpression(contextForInlining);
        TranslationContext translationContext = this.createContextWithAliasesForParameters(contextForInlining);
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/InlinedCallExpressionTranslator", "createContextForInlining"));
        }
        return translationContext;
    }

    @NotNull
    private TranslationContext createContextWithAliasesForParameters(@NotNull TranslationContext contextForInlining) {
        if (contextForInlining == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/InlinedCallExpressionTranslator", "createContextWithAliasesForParameters"));
        }
        HashMap<DeclarationDescriptor, JsExpression> aliases = Maps.newHashMap();
        for (ValueParameterDescriptor parameterDescriptor : this.resolvedCall.getResultingDescriptor().getValueParameters()) {
            TemporaryVariable aliasForArgument = this.createAliasForArgument(parameterDescriptor);
            aliases.put(parameterDescriptor, aliasForArgument.name().makeRef());
        }
        TranslationContext translationContext = contextForInlining.innerContextWithDescriptorsAliased(aliases);
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/InlinedCallExpressionTranslator", "createContextWithAliasesForParameters"));
        }
        return translationContext;
    }

    @NotNull
    private TranslationContext createContextWithAliasForThisExpression(@NotNull TranslationContext contextForInlining) {
        JsExpression thisObject;
        if (contextForInlining == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/InlinedCallExpressionTranslator", "createContextWithAliasForThisExpression"));
        }
        TranslationContext contextWithAliasForThisExpression = contextForInlining;
        SimpleFunctionDescriptor functionDescriptor = this.getFunctionDescriptor();
        CallParameters callParameters = CallParametersResolver.resolveCallParameters(this.receiver, null, functionDescriptor, this.resolvedCall, contextForInlining);
        JsExpression receiver = callParameters.getReceiver();
        if (receiver != null) {
            contextWithAliasForThisExpression = this.contextWithAlias(contextWithAliasForThisExpression, receiver, JsDescriptorUtils.getExpectedReceiverDescriptor(functionDescriptor));
        }
        if ((thisObject = callParameters.getThisObject()) != null) {
            contextWithAliasForThisExpression = this.contextWithAlias(contextWithAliasForThisExpression, thisObject, JsDescriptorUtils.getExpectedThisDescriptor(functionDescriptor));
        }
        TranslationContext translationContext = contextWithAliasForThisExpression;
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/InlinedCallExpressionTranslator", "createContextWithAliasForThisExpression"));
        }
        return translationContext;
    }

    @NotNull
    private TranslationContext contextWithAlias(@NotNull TranslationContext contextWithAliasForThisExpression, @NotNull JsExpression aliasExpression, @Nullable DeclarationDescriptor descriptorToAlias) {
        if (contextWithAliasForThisExpression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/InlinedCallExpressionTranslator", "contextWithAlias"));
        }
        if (aliasExpression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/reference/InlinedCallExpressionTranslator", "contextWithAlias"));
        }
        TemporaryVariable aliasForReceiver = this.context().declareTemporary(aliasExpression);
        assert (descriptorToAlias != null);
        TranslationContext newContext = contextWithAliasForThisExpression.innerContextWithThisAliased(descriptorToAlias, aliasForReceiver.reference());
        newContext.addStatementToCurrentBlock(aliasForReceiver.assignmentExpression().makeStmt());
        TranslationContext translationContext = newContext;
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/InlinedCallExpressionTranslator", "contextWithAlias"));
        }
        return translationContext;
    }

    @NotNull
    private TemporaryVariable createAliasForArgument(@NotNull ValueParameterDescriptor parameterDescriptor) {
        if (parameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/InlinedCallExpressionTranslator", "createAliasForArgument"));
        }
        ResolvedValueArgument actualArgument = this.resolvedCall.getValueArgumentsByIndex().get(parameterDescriptor.getIndex());
        JsExpression translatedArgument = this.translateArgument(actualArgument);
        TemporaryVariable aliasForArgument = this.context().declareTemporary(translatedArgument);
        this.context().addStatementToCurrentBlock(aliasForArgument.assignmentExpression().makeStmt());
        TemporaryVariable temporaryVariable = aliasForArgument;
        if (temporaryVariable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/InlinedCallExpressionTranslator", "createAliasForArgument"));
        }
        return temporaryVariable;
    }

    @NotNull
    private JsExpression translateArgument(@NotNull ResolvedValueArgument actualArgument) {
        if (actualArgument == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/InlinedCallExpressionTranslator", "translateArgument"));
        }
        SmartList<JsExpression> result = new SmartList<JsExpression>();
        CallArgumentTranslator.translateSingleArgument(actualArgument, result, this.context(), true);
        assert (result.size() == 1) : "We always wrap varargs in kotlin calls.";
        JsExpression jsExpression = (JsExpression)result.get(0);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/InlinedCallExpressionTranslator", "translateArgument"));
        }
        return jsExpression;
    }

    private static final class InlineFunctionMutator
    implements Mutator {
        @NotNull
        private final TemporaryVariable toAssignTo;

        private InlineFunctionMutator(@NotNull TemporaryVariable to) {
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/InlinedCallExpressionTranslator$InlineFunctionMutator", "<init>"));
            }
            this.toAssignTo = to;
        }

        @Override
        @NotNull
        public JsNode mutate(@NotNull JsNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/reference/InlinedCallExpressionTranslator$InlineFunctionMutator", "mutate"));
            }
            if (node instanceof JsReturn) {
                JsExpression returnedExpression = ((JsReturn)node).getExpression();
                JsExpression jsExpression = JsAstUtils.assignment(this.toAssignTo.name().makeRef(), returnedExpression);
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/InlinedCallExpressionTranslator$InlineFunctionMutator", "mutate"));
                }
                return jsExpression;
            }
            JsNode jsNode = node;
            if (jsNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/InlinedCallExpressionTranslator$InlineFunctionMutator", "mutate"));
            }
            return jsNode;
        }
    }
}

