/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ClassExtension;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ElementManipulators
extends ClassExtension<ElementManipulator> {
    @NonNls
    public static final String EP_NAME = "com.intellij.lang.elementManipulator";
    public static final ElementManipulators INSTANCE = new ElementManipulators();
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.ElementManipulators");

    private ElementManipulators() {
        super(EP_NAME);
    }

    public static <T extends PsiElement> ElementManipulator<T> getManipulator(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/ElementManipulators", "getManipulator"));
        }
        return (ElementManipulator)INSTANCE.forClass(element.getClass());
    }

    public static int getOffsetInElement(PsiElement element) {
        ElementManipulator<PsiElement> manipulator = ElementManipulators.getNotNullManipulator(element);
        return manipulator.getRangeInElement(element).getStartOffset();
    }

    public static <T extends PsiElement> ElementManipulator<T> getNotNullManipulator(T element) {
        ElementManipulator<T> manipulator = ElementManipulators.getManipulator(element);
        LOG.assertTrue(manipulator != null, element.getClass().getName());
        return manipulator;
    }

    public static TextRange getValueTextRange(PsiElement element) {
        ElementManipulator<PsiElement> manipulator = ElementManipulators.getManipulator(element);
        return manipulator == null ? TextRange.from(0, element.getTextLength()) : manipulator.getRangeInElement(element);
    }

    @NotNull
    public static String getValueText(PsiElement element) {
        TextRange valueTextRange = ElementManipulators.getValueTextRange(element);
        if (valueTextRange.isEmpty()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/ElementManipulators", "getValueText"));
            }
            return "";
        }
        String text = element.getText();
        if (valueTextRange.getEndOffset() > text.length()) {
            LOG.error("Wrong range for " + element + " text: " + text + " range " + valueTextRange);
        }
        String string = valueTextRange.substring(text);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/ElementManipulators", "getValueText"));
        }
        return string;
    }

    public static <T extends PsiElement> T handleContentChange(T element, String text) {
        ElementManipulator<T> manipulator = ElementManipulators.getNotNullManipulator(element);
        return manipulator.handleContentChange(element, text);
    }
}

