/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.AnalysisCanceledSoftException;
import com.intellij.psi.controlFlow.BranchingInstruction;
import com.intellij.psi.controlFlow.CallInstruction;
import com.intellij.psi.controlFlow.ConditionalGoToInstruction;
import com.intellij.psi.controlFlow.ConditionalThrowToInstruction;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowImpl;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowStack;
import com.intellij.psi.controlFlow.ControlFlowSubRange;
import com.intellij.psi.controlFlow.EmptyInstruction;
import com.intellij.psi.controlFlow.GoToInstruction;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.psi.controlFlow.ReadVariableInstruction;
import com.intellij.psi.controlFlow.ReturnInstruction;
import com.intellij.psi.controlFlow.ThrowToInstruction;
import com.intellij.psi.controlFlow.WriteVariableInstruction;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.Stack;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ControlFlowAnalyzer
extends JavaElementVisitor {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.controlFlow.ControlFlowAnalyzer");
    private final PsiElement myCodeFragment;
    private final ControlFlowPolicy myPolicy;
    private ControlFlowImpl myCurrentFlow;
    private final ControlFlowStack myStack;
    private final Stack<PsiParameter> myCatchParameters;
    private final Stack<PsiElement> myCatchBlocks;
    private final Stack<PsiElement> myFinallyBlocks;
    private final Stack<PsiElement> myUnhandledExceptionCatchBlocks;
    private final StatementStack myStartStatementStack;
    private final StatementStack myEndStatementStack;
    private final Stack<BranchingInstruction.Role> myStartJumpRoles;
    private final Stack<BranchingInstruction.Role> myEndJumpRoles;
    private final boolean myEnabledShortCircuit;
    private final boolean myEvaluateConstantIfCondition;
    private final boolean myAssignmentTargetsAreElements;
    private final Stack<TIntArrayList> intArrayPool;
    private final Map<PsiElement, TIntArrayList> offsetsAddElementStart;
    private final Map<PsiElement, TIntArrayList> offsetsAddElementEnd;
    private final ControlFlowFactory myControlFlowFactory;
    private final Map<PsiElement, ControlFlowSubRange> mySubRanges;
    private final PsiConstantEvaluationHelper myConstantEvaluationHelper;
    private final Map<PsiElement, List<PsiElement>> finallyBlockToUnhandledExceptions;

    ControlFlowAnalyzer(@NotNull PsiElement codeFragment, @NotNull ControlFlowPolicy policy, boolean enabledShortCircuit, boolean evaluateConstantIfCondition) {
        if (codeFragment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "<init>"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "<init>"));
        }
        this(codeFragment, policy, enabledShortCircuit, evaluateConstantIfCondition, false);
    }

    private ControlFlowAnalyzer(@NotNull PsiElement codeFragment, @NotNull ControlFlowPolicy policy, boolean enabledShortCircuit, boolean evaluateConstantIfCondition, boolean assignmentTargetsAreElements) {
        if (codeFragment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "<init>"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "<init>"));
        }
        this.myStack = new ControlFlowStack();
        this.myCatchParameters = new Stack();
        this.myCatchBlocks = new Stack();
        this.myFinallyBlocks = new Stack();
        this.myUnhandledExceptionCatchBlocks = new Stack();
        this.myStartStatementStack = new StatementStack();
        this.myEndStatementStack = new StatementStack();
        this.myStartJumpRoles = new Stack();
        this.myEndJumpRoles = new Stack();
        this.intArrayPool = new Stack();
        this.offsetsAddElementStart = new THashMap<PsiElement, TIntArrayList>();
        this.offsetsAddElementEnd = new THashMap<PsiElement, TIntArrayList>();
        this.mySubRanges = new THashMap<PsiElement, ControlFlowSubRange>();
        this.finallyBlockToUnhandledExceptions = new HashMap<PsiElement, List<PsiElement>>();
        this.myCodeFragment = codeFragment;
        this.myPolicy = policy;
        this.myEnabledShortCircuit = enabledShortCircuit;
        this.myEvaluateConstantIfCondition = evaluateConstantIfCondition;
        this.myAssignmentTargetsAreElements = assignmentTargetsAreElements;
        Project project = codeFragment.getProject();
        this.myControlFlowFactory = ControlFlowFactory.getInstance(project);
        this.myConstantEvaluationHelper = JavaPsiFacade.getInstance(project).getConstantEvaluationHelper();
    }

    @NotNull
    ControlFlow buildControlFlow() throws AnalysisCanceledException {
        this.myStartJumpRoles.push(BranchingInstruction.Role.END);
        this.myEndJumpRoles.push(BranchingInstruction.Role.END);
        this.myCurrentFlow = new ControlFlowImpl();
        this.myStartStatementStack.pushStatement(this.myCodeFragment, false);
        this.myEndStatementStack.pushStatement(this.myCodeFragment, false);
        try {
            this.myCodeFragment.accept(this);
            this.cleanup();
        }
        catch (AnalysisCanceledSoftException e) {
            throw new AnalysisCanceledException(e.getErrorElement());
        }
        ControlFlowImpl controlFlowImpl = this.myCurrentFlow;
        if (controlFlowImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "buildControlFlow"));
        }
        return controlFlowImpl;
    }

    private TIntArrayList getEmptyIntArray() {
        if (this.intArrayPool.isEmpty()) {
            return new TIntArrayList(1);
        }
        TIntArrayList list2 = this.intArrayPool.pop();
        list2.clear();
        return list2;
    }

    private void poolIntArray(TIntArrayList list2) {
        this.intArrayPool.add(list2);
    }

    private void addElementOffsetLater(PsiElement element, boolean atStart) {
        Map<PsiElement, TIntArrayList> offsetsAddElement = atStart ? this.offsetsAddElementStart : this.offsetsAddElementEnd;
        TIntArrayList offsets = offsetsAddElement.get(element);
        if (offsets == null) {
            offsets = this.getEmptyIntArray();
            offsetsAddElement.put(element, offsets);
        }
        int offset = this.myCurrentFlow.getSize() - 1;
        offsets.add(offset);
        if (this.myCurrentFlow.getEndOffset(element) != -1) {
            this.patchInstructionOffsets(element);
        }
    }

    private void patchInstructionOffsets(PsiElement element) {
        this.patchInstructionOffsets(this.offsetsAddElementStart.get(element), this.myCurrentFlow.getStartOffset(element));
        this.offsetsAddElementStart.put(element, null);
        this.patchInstructionOffsets(this.offsetsAddElementEnd.get(element), this.myCurrentFlow.getEndOffset(element));
        this.offsetsAddElementEnd.put(element, null);
    }

    private void patchInstructionOffsets(TIntArrayList offsets, int add) {
        if (offsets == null) {
            return;
        }
        for (int i = 0; i < offsets.size(); ++i) {
            int offset = offsets.get(i);
            BranchingInstruction instruction = (BranchingInstruction)this.myCurrentFlow.getInstructions().get(offset);
            instruction.offset += add;
            LOG.assertTrue(instruction.offset >= 0);
        }
        this.poolIntArray(offsets);
    }

    private void cleanup() {
        for (TIntArrayList tIntArrayList : this.offsetsAddElementStart.values()) {
            this.patchInstructionOffsets(tIntArrayList, this.myCurrentFlow.getEndOffset(this.myCodeFragment));
        }
        for (TIntArrayList tIntArrayList : this.offsetsAddElementEnd.values()) {
            this.patchInstructionOffsets(tIntArrayList, this.myCurrentFlow.getEndOffset(this.myCodeFragment));
        }
        for (Map.Entry entry : this.mySubRanges.entrySet()) {
            ProgressIndicatorProvider.checkCanceled();
            ControlFlowSubRange subRange = (ControlFlowSubRange)entry.getValue();
            PsiElement element = (PsiElement)entry.getKey();
            this.myControlFlowFactory.registerSubRange(element, subRange, this.myEvaluateConstantIfCondition, this.myPolicy);
        }
    }

    private void startElement(PsiElement element) {
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            ProgressIndicatorProvider.checkCanceled();
            if (!(child instanceof PsiErrorElement) || Comparing.strEqual(((PsiErrorElement)child).getErrorDescription(), JavaErrorMessages.message("expected.semicolon", new Object[0]))) continue;
            throw new AnalysisCanceledSoftException(element);
        }
        ProgressIndicatorProvider.checkCanceled();
        this.myCurrentFlow.startElement(element);
        this.generateUncheckedExceptionJumpsIfNeeded(element, true);
    }

    private void generateUncheckedExceptionJumpsIfNeeded(PsiElement element, boolean atStart) {
        boolean isGeneratingCodeBlock;
        boolean isGeneratingStatement = element instanceof PsiStatement && !(element instanceof PsiSwitchLabelStatement);
        boolean bl = isGeneratingCodeBlock = element instanceof PsiCodeBlock && !(element.getParent() instanceof PsiSwitchStatement);
        if (isGeneratingStatement || isGeneratingCodeBlock) {
            this.generateUncheckedExceptionJumps(element, atStart);
        }
    }

    private void finishElement(PsiElement element) {
        this.generateUncheckedExceptionJumpsIfNeeded(element, false);
        this.myCurrentFlow.finishElement(element);
        this.patchInstructionOffsets(element);
    }

    private void generateUncheckedExceptionJumps(PsiElement element, boolean atStart) {
        if (atStart && element instanceof PsiStatement && element.getParent() instanceof PsiCodeBlock && element.getPrevSibling() != null) {
            return;
        }
        for (int i = this.myUnhandledExceptionCatchBlocks.size() - 1; i >= 0; --i) {
            ProgressIndicatorProvider.checkCanceled();
            PsiElement block = (PsiElement)this.myUnhandledExceptionCatchBlocks.get(i);
            if (block == null) {
                if (this.myFinallyBlocks.isEmpty()) continue;
                break;
            }
            ConditionalThrowToInstruction throwToInstruction = new ConditionalThrowToInstruction(-1);
            this.myCurrentFlow.addInstruction(throwToInstruction);
            if (this.patchUncheckedThrowInstructionIfInsideFinally(throwToInstruction, element, block)) continue;
            this.addElementOffsetLater(block, true);
        }
        if (!this.myFinallyBlocks.isEmpty()) {
            PsiElement finallyBlock = this.myFinallyBlocks.peek();
            ConditionalThrowToInstruction throwToInstruction = new ConditionalThrowToInstruction(-2);
            this.myCurrentFlow.addInstruction(throwToInstruction);
            if (!this.patchUncheckedThrowInstructionIfInsideFinally(throwToInstruction, element, finallyBlock)) {
                this.addElementOffsetLater(finallyBlock, true);
            }
        }
    }

    private void generateCheckedExceptionJumps(PsiElement element) {
        Collection<PsiClassType> unhandledExceptions = ExceptionUtil.collectUnhandledExceptions(element, element.getParent());
        for (PsiClassType unhandledException : unhandledExceptions) {
            ProgressIndicatorProvider.checkCanceled();
            this.generateThrow(unhandledException, element);
        }
    }

    private void generateThrow(PsiClassType unhandledException, PsiElement throwingElement) {
        List<PsiElement> catchBlocks = this.findThrowToBlocks(unhandledException);
        for (PsiElement block : catchBlocks) {
            ProgressIndicatorProvider.checkCanceled();
            ConditionalThrowToInstruction instruction = new ConditionalThrowToInstruction(0);
            this.myCurrentFlow.addInstruction(instruction);
            if (this.patchCheckedThrowInstructionIfInsideFinally(instruction, throwingElement, block)) continue;
            if (block == null) {
                this.addElementOffsetLater(this.myCodeFragment, false);
                continue;
            }
            --instruction.offset;
            this.addElementOffsetLater(block, true);
        }
    }

    private boolean patchCheckedThrowInstructionIfInsideFinally(@NotNull ConditionalThrowToInstruction instruction, PsiElement throwingElement, PsiElement elementToJumpTo) {
        int index;
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "patchCheckedThrowInstructionIfInsideFinally"));
        }
        PsiElement finallyBlock = this.findEnclosingFinallyBlockElement(throwingElement, elementToJumpTo);
        if (finallyBlock == null) {
            return false;
        }
        List<PsiElement> unhandledExceptionCatchBlocks = this.finallyBlockToUnhandledExceptions.get(finallyBlock);
        if (unhandledExceptionCatchBlocks == null) {
            unhandledExceptionCatchBlocks = new ArrayList<PsiElement>();
            this.finallyBlockToUnhandledExceptions.put(finallyBlock, unhandledExceptionCatchBlocks);
        }
        if ((index = unhandledExceptionCatchBlocks.indexOf(elementToJumpTo)) == -1) {
            index = unhandledExceptionCatchBlocks.size();
            unhandledExceptionCatchBlocks.add(elementToJumpTo);
        }
        instruction.offset = 3 + index;
        this.addElementOffsetLater(finallyBlock, false);
        return true;
    }

    private boolean patchUncheckedThrowInstructionIfInsideFinally(@NotNull ConditionalThrowToInstruction instruction, PsiElement throwingElement, PsiElement elementToJumpTo) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "patchUncheckedThrowInstructionIfInsideFinally"));
        }
        PsiElement finallyBlock = this.findEnclosingFinallyBlockElement(throwingElement, elementToJumpTo);
        if (finallyBlock == null) {
            return false;
        }
        instruction.offset = 2;
        this.addElementOffsetLater(finallyBlock, false);
        return true;
    }

    @Override
    public void visitCodeFragment(JavaCodeFragment codeFragment) {
        PsiElement[] children;
        this.startElement(codeFragment);
        int prevOffset = this.myCurrentFlow.getSize();
        for (PsiElement child : children = codeFragment.getChildren()) {
            ProgressIndicatorProvider.checkCanceled();
            child.accept(this);
        }
        this.finishElement(codeFragment);
        this.registerSubRange(codeFragment, prevOffset);
    }

    private void registerSubRange(PsiElement codeFragment, int startOffset) {
        ControlFlowSubRange flow = new ControlFlowSubRange(this.myCurrentFlow, startOffset, this.myCurrentFlow.getSize());
        this.mySubRanges.put(codeFragment, flow);
    }

    @Override
    public void visitCodeBlock(PsiCodeBlock block) {
        PsiStatement[] statements;
        this.startElement(block);
        int prevOffset = this.myCurrentFlow.getSize();
        for (PsiStatement statement : statements = block.getStatements()) {
            ProgressIndicatorProvider.checkCanceled();
            statement.accept(this);
        }
        int nextOffset = this.myCurrentFlow.getSize();
        if (!(block.getParent() instanceof PsiSwitchStatement) && prevOffset == nextOffset) {
            this.emitEmptyInstruction();
        }
        this.finishElement(block);
        if (prevOffset != 0) {
            this.registerSubRange(block, prevOffset);
        }
    }

    private void emitEmptyInstruction() {
        this.myCurrentFlow.addInstruction(EmptyInstruction.INSTANCE);
    }

    @Override
    public void visitFile(PsiFile file) {
        this.visitChildren(file);
    }

    @Override
    public void visitBlockStatement(PsiBlockStatement statement) {
        this.startElement(statement);
        PsiCodeBlock codeBlock = statement.getCodeBlock();
        codeBlock.accept(this);
        this.finishElement(statement);
    }

    @Override
    public void visitBreakStatement(PsiBreakStatement statement) {
        this.startElement(statement);
        PsiStatement exitedStatement = statement.findExitedStatement();
        if (exitedStatement != null) {
            GoToInstruction instruction;
            int finallyStartOffset;
            PsiElement finallyBlock = this.findEnclosingFinallyBlockElement(statement, exitedStatement);
            int n = finallyStartOffset = finallyBlock == null ? -1 : this.myCurrentFlow.getStartOffset(finallyBlock);
            if (finallyBlock != null && finallyStartOffset != -1) {
                CallInstruction callInstruction = (CallInstruction)this.myCurrentFlow.getInstructions().get(finallyStartOffset - 2);
                instruction = new ReturnInstruction(0, this.myStack, callInstruction);
            } else {
                instruction = new GoToInstruction(0);
            }
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater(exitedStatement, false);
        }
        this.finishElement(statement);
    }

    private PsiElement findEnclosingFinallyBlockElement(PsiElement sourceElement, PsiElement jumpElement) {
        for (PsiElement element = sourceElement; element != null && !(element instanceof PsiFile); element = element.getParent()) {
            if (!(element instanceof PsiCodeBlock) || !(element.getParent() instanceof PsiTryStatement) || ((PsiTryStatement)element.getParent()).getFinallyBlock() != element) continue;
            if (this.myCurrentFlow.getStartOffset(element.getParent()) == -1) {
                return null;
            }
            if (jumpElement != null && PsiTreeUtil.isAncestor(element, jumpElement, false)) continue;
            return element;
        }
        return null;
    }

    @Override
    public void visitContinueStatement(PsiContinueStatement statement) {
        this.startElement(statement);
        PsiStatement continuedStatement = statement.findContinuedStatement();
        if (continuedStatement != null) {
            GoToInstruction instruction;
            PsiElement finallyBlock;
            int finallyStartOffset;
            PsiElement body = null;
            if (continuedStatement instanceof PsiForStatement) {
                body = ((PsiForStatement)continuedStatement).getBody();
            } else if (continuedStatement instanceof PsiWhileStatement) {
                body = ((PsiWhileStatement)continuedStatement).getBody();
            } else if (continuedStatement instanceof PsiDoWhileStatement) {
                body = ((PsiDoWhileStatement)continuedStatement).getBody();
            } else if (continuedStatement instanceof PsiForeachStatement) {
                body = ((PsiForeachStatement)continuedStatement).getBody();
            }
            if (body == null) {
                body = this.myCodeFragment;
            }
            int n = finallyStartOffset = (finallyBlock = this.findEnclosingFinallyBlockElement(statement, continuedStatement)) == null ? -1 : this.myCurrentFlow.getStartOffset(finallyBlock);
            if (finallyBlock != null && finallyStartOffset != -1) {
                CallInstruction callInstruction = (CallInstruction)this.myCurrentFlow.getInstructions().get(finallyStartOffset - 2);
                instruction = new ReturnInstruction(0, this.myStack, callInstruction);
            } else {
                instruction = new GoToInstruction(0);
            }
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater(body, false);
        }
        this.finishElement(statement);
    }

    @Override
    public void visitDeclarationStatement(PsiDeclarationStatement statement) {
        PsiElement[] elements;
        this.startElement(statement);
        int pc = this.myCurrentFlow.getSize();
        for (PsiElement element : elements = statement.getDeclaredElements()) {
            ProgressIndicatorProvider.checkCanceled();
            if (element instanceof PsiClass) {
                element.accept(this);
                continue;
            }
            if (!(element instanceof PsiVariable)) continue;
            this.processVariable((PsiVariable)element);
        }
        if (pc == this.myCurrentFlow.getSize()) {
            this.emitEmptyInstruction();
        }
        this.finishElement(statement);
    }

    private void processVariable(PsiVariable element) {
        PsiExpression initializer = element.getInitializer();
        if (initializer != null) {
            this.myStartStatementStack.pushStatement(initializer, false);
            this.myEndStatementStack.pushStatement(initializer, false);
            initializer.accept(this);
            this.myStartStatementStack.popStatement();
            this.myEndStatementStack.popStatement();
        }
        if (element instanceof PsiLocalVariable && initializer != null || element instanceof PsiField) {
            if (element instanceof PsiLocalVariable && !this.myPolicy.isLocalVariableAccepted((PsiLocalVariable)element)) {
                return;
            }
            if (this.myAssignmentTargetsAreElements) {
                this.startElement(element);
            }
            this.generateWriteInstruction(element);
            if (this.myAssignmentTargetsAreElements) {
                this.finishElement(element);
            }
        }
    }

    @Override
    public void visitDoWhileStatement(PsiDoWhileStatement statement) {
        PsiExpression condition;
        this.startElement(statement);
        this.myStartStatementStack.pushStatement(statement.getBody() == null ? statement : statement.getBody(), true);
        this.myEndStatementStack.pushStatement(statement, false);
        PsiStatement body = statement.getBody();
        if (body != null) {
            body.accept(this);
        }
        if ((condition = statement.getCondition()) != null) {
            condition.accept(this);
        }
        int offset = this.myCurrentFlow.getStartOffset(statement);
        Object loopCondition = this.myConstantEvaluationHelper.computeConstantExpression(statement.getCondition());
        if (loopCondition instanceof Boolean) {
            if (((Boolean)loopCondition).booleanValue()) {
                this.myCurrentFlow.addInstruction(new GoToInstruction(offset));
            } else {
                this.emitEmptyInstruction();
            }
        } else {
            ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(offset, statement.getCondition());
            this.myCurrentFlow.addInstruction(instruction);
        }
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement(statement);
    }

    @Override
    public void visitEmptyStatement(PsiEmptyStatement statement) {
        this.startElement(statement);
        this.emitEmptyInstruction();
        this.finishElement(statement);
    }

    @Override
    public void visitExpressionStatement(PsiExpressionStatement statement) {
        this.startElement(statement);
        PsiExpression expression = statement.getExpression();
        expression.accept(this);
        for (PsiParameter catchParameter : this.myCatchParameters) {
            ProgressIndicatorProvider.checkCanceled();
            PsiType type = catchParameter.getType();
            if (!(type instanceof PsiClassType)) continue;
            this.generateThrow((PsiClassType)type, statement);
        }
        this.finishElement(statement);
    }

    @Override
    public void visitExpressionListStatement(PsiExpressionListStatement statement) {
        PsiExpression[] expressions;
        this.startElement(statement);
        for (PsiExpression expr : expressions = statement.getExpressionList().getExpressions()) {
            ProgressIndicatorProvider.checkCanceled();
            expr.accept(this);
        }
        this.finishElement(statement);
    }

    @Override
    public void visitField(PsiField field) {
        PsiExpression initializer = field.getInitializer();
        if (initializer != null) {
            this.startElement(field);
            initializer.accept(this);
            this.finishElement(field);
        }
    }

    @Override
    public void visitForStatement(PsiForStatement statement) {
        PsiStatement update;
        Object loopCondition;
        PsiExpression condition;
        this.startElement(statement);
        this.myStartStatementStack.pushStatement(statement.getBody() == null ? statement : statement.getBody(), false);
        this.myEndStatementStack.pushStatement(statement, false);
        PsiStatement initialization = statement.getInitialization();
        if (initialization != null) {
            initialization.accept(this);
        }
        if ((condition = statement.getCondition()) != null) {
            condition.accept(this);
        }
        if ((loopCondition = this.myConstantEvaluationHelper.computeConstantExpression(condition)) instanceof Boolean || condition == null) {
            boolean value;
            boolean bl = value = condition == null || (Boolean)loopCondition != false;
            if (value) {
                this.emitEmptyInstruction();
            } else {
                this.myCurrentFlow.addInstruction(new GoToInstruction(0));
                this.addElementOffsetLater(statement, false);
            }
        } else {
            ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(0, statement.getCondition());
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater(statement, false);
        }
        PsiStatement body = statement.getBody();
        if (body != null) {
            body.accept(this);
        }
        if ((update = statement.getUpdate()) != null) {
            update.accept(this);
        }
        int offset = initialization != null ? this.myCurrentFlow.getEndOffset(initialization) : this.myCurrentFlow.getStartOffset(statement);
        GoToInstruction instruction = new GoToInstruction(offset);
        this.myCurrentFlow.addInstruction(instruction);
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement(statement);
    }

    @Override
    public void visitForeachStatement(PsiForeachStatement statement) {
        this.startElement(statement);
        PsiStatement body = statement.getBody();
        this.myStartStatementStack.pushStatement(body == null ? statement : body, false);
        this.myEndStatementStack.pushStatement(statement, false);
        PsiExpression iteratedValue = statement.getIteratedValue();
        if (iteratedValue != null) {
            iteratedValue.accept(this);
        }
        int gotoTarget = this.myCurrentFlow.getSize();
        ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(0, statement.getIteratedValue());
        this.myCurrentFlow.addInstruction(instruction);
        this.addElementOffsetLater(statement, false);
        PsiParameter iterationParameter = statement.getIterationParameter();
        if (this.myPolicy.isParameterAccepted(iterationParameter)) {
            this.generateWriteInstruction(iterationParameter);
        }
        if (body != null) {
            body.accept(this);
        }
        GoToInstruction gotoInstruction = new GoToInstruction(gotoTarget);
        this.myCurrentFlow.addInstruction(gotoInstruction);
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement(statement);
    }

    @Override
    public void visitIfStatement(PsiIfStatement statement) {
        this.startElement(statement);
        PsiStatement elseBranch = statement.getElseBranch();
        PsiStatement thenBranch = statement.getThenBranch();
        PsiExpression conditionExpression = statement.getCondition();
        this.generateConditionalStatementInstructions(statement, conditionExpression, thenBranch, elseBranch);
        this.finishElement(statement);
    }

    private void generateConditionalStatementInstructions(PsiElement statement, PsiExpression conditionExpression, PsiElement thenBranch, PsiElement elseBranch) {
        Object value;
        if (thenBranch == null) {
            this.myStartStatementStack.pushStatement(statement, false);
        } else {
            this.myStartStatementStack.pushStatement(thenBranch, true);
        }
        if (elseBranch == null) {
            this.myEndStatementStack.pushStatement(statement, false);
        } else {
            this.myEndStatementStack.pushStatement(elseBranch, true);
        }
        this.myEndJumpRoles.push(elseBranch == null ? BranchingInstruction.Role.END : BranchingInstruction.Role.ELSE);
        this.myStartJumpRoles.push(thenBranch == null ? BranchingInstruction.Role.END : BranchingInstruction.Role.THEN);
        if (conditionExpression != null) {
            conditionExpression.accept(this);
        }
        boolean generateElseFlow = true;
        boolean generateThenFlow = true;
        boolean generateConditionalJump = true;
        if (this.myEvaluateConstantIfCondition && (value = this.myConstantEvaluationHelper.computeConstantExpression(conditionExpression)) instanceof Boolean) {
            boolean condition;
            generateThenFlow = condition = ((Boolean)value).booleanValue();
            generateElseFlow = !condition;
            generateConditionalJump = false;
            this.myCurrentFlow.setConstantConditionOccurred(true);
        }
        if (generateConditionalJump) {
            BranchingInstruction.Role role = elseBranch == null ? BranchingInstruction.Role.END : BranchingInstruction.Role.ELSE;
            ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(0, role, conditionExpression);
            this.myCurrentFlow.addInstruction(instruction);
            if (elseBranch == null) {
                this.addElementOffsetLater(statement, false);
            } else {
                this.addElementOffsetLater(elseBranch, true);
            }
        }
        if (thenBranch != null && generateThenFlow) {
            thenBranch.accept(this);
        }
        if (elseBranch != null && generateElseFlow) {
            if (generateThenFlow) {
                GoToInstruction instruction = new GoToInstruction(0);
                this.myCurrentFlow.addInstruction(instruction);
                this.addElementOffsetLater(statement, false);
            }
            elseBranch.accept(this);
        }
        this.myStartJumpRoles.pop();
        this.myEndJumpRoles.pop();
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
    }

    @Override
    public void visitLabeledStatement(PsiLabeledStatement statement) {
        this.startElement(statement);
        PsiStatement innerStatement = statement.getStatement();
        if (innerStatement != null) {
            innerStatement.accept(this);
        }
        this.finishElement(statement);
    }

    @Override
    public void visitReturnStatement(PsiReturnStatement statement) {
        this.startElement(statement);
        PsiExpression returnValue = statement.getReturnValue();
        this.myStartStatementStack.pushStatement(returnValue, false);
        this.myEndStatementStack.pushStatement(returnValue, false);
        if (returnValue != null) {
            returnValue.accept(this);
        }
        this.addReturnInstruction(statement);
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement(statement);
    }

    private void addReturnInstruction(PsiElement statement) {
        int finallyStartOffset;
        PsiElement finallyBlock = this.findEnclosingFinallyBlockElement(statement, null);
        int n = finallyStartOffset = finallyBlock == null ? -1 : this.myCurrentFlow.getStartOffset(finallyBlock);
        if (finallyBlock != null && finallyStartOffset != -1) {
            GoToInstruction instruction = new GoToInstruction(1, BranchingInstruction.Role.END, true);
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater(finallyBlock, false);
        } else {
            GoToInstruction instruction = new GoToInstruction(0, BranchingInstruction.Role.END, true);
            this.myCurrentFlow.addInstruction(instruction);
            if (this.myFinallyBlocks.isEmpty()) {
                this.addElementOffsetLater(this.myCodeFragment, false);
            } else {
                instruction.offset = -4;
                this.addElementOffsetLater(this.myFinallyBlocks.peek(), true);
            }
        }
    }

    @Override
    public void visitSwitchLabelStatement(PsiSwitchLabelStatement statement) {
        this.startElement(statement);
        PsiExpression caseValue = statement.getCaseValue();
        this.myStartStatementStack.pushStatement(caseValue, false);
        this.myEndStatementStack.pushStatement(caseValue, false);
        if (caseValue != null) {
            caseValue.accept(this);
        }
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement(statement);
    }

    @Override
    public void visitSwitchStatement(PsiSwitchStatement statement) {
        PsiCodeBlock body;
        this.startElement(statement);
        PsiExpression expr = statement.getExpression();
        if (expr != null) {
            expr.accept(this);
        }
        if ((body = statement.getBody()) != null) {
            PsiStatement[] statements = body.getStatements();
            PsiSwitchLabelStatement defaultLabel = null;
            for (PsiStatement aStatement : statements) {
                ProgressIndicatorProvider.checkCanceled();
                if (!(aStatement instanceof PsiSwitchLabelStatement)) continue;
                if (((PsiSwitchLabelStatement)aStatement).isDefaultCase()) {
                    defaultLabel = (PsiSwitchLabelStatement)aStatement;
                }
                ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(0, statement.getExpression());
                this.myCurrentFlow.addInstruction(instruction);
                this.addElementOffsetLater(aStatement, true);
            }
            if (defaultLabel == null) {
                GoToInstruction instruction = new GoToInstruction(0);
                this.myCurrentFlow.addInstruction(instruction);
                this.addElementOffsetLater(body, false);
            }
            body.accept(this);
        }
        this.finishElement(statement);
    }

    @Override
    public void visitSynchronizedStatement(PsiSynchronizedStatement statement) {
        PsiCodeBlock body;
        this.startElement(statement);
        PsiExpression lock = statement.getLockExpression();
        if (lock != null) {
            lock.accept(this);
        }
        if ((body = statement.getBody()) != null) {
            body.accept(this);
        }
        this.finishElement(statement);
    }

    @Override
    public void visitThrowStatement(PsiThrowStatement statement) {
        List<PsiElement> blocks;
        this.startElement(statement);
        PsiExpression exception = statement.getException();
        if (exception != null) {
            exception.accept(this);
        }
        if ((blocks = this.findThrowToBlocks(statement)).isEmpty() || blocks.get(0) == null) {
            ThrowToInstruction instruction = new ThrowToInstruction(0);
            this.myCurrentFlow.addInstruction(instruction);
            if (this.myFinallyBlocks.isEmpty()) {
                PsiElement element = this.myCodeFragment;
                this.addElementOffsetLater(element, false);
            } else {
                instruction.offset = -2;
                PsiElement element = this.myFinallyBlocks.peek();
                this.addElementOffsetLater(element, true);
            }
        } else {
            for (int i = 0; i < blocks.size(); ++i) {
                ProgressIndicatorProvider.checkCanceled();
                PsiElement element = blocks.get(i);
                BranchingInstruction instruction = i == blocks.size() - 1 ? new ThrowToInstruction(0) : new ConditionalThrowToInstruction(0);
                this.myCurrentFlow.addInstruction(instruction);
                instruction.offset = -1;
                this.addElementOffsetLater(element, true);
            }
        }
        this.finishElement(statement);
    }

    private List<PsiElement> findThrowToBlocks(PsiThrowStatement statement) {
        PsiExpression exceptionExpr = statement.getException();
        if (exceptionExpr == null) {
            return Collections.emptyList();
        }
        PsiType throwType = exceptionExpr.getType();
        if (!(throwType instanceof PsiClassType)) {
            return Collections.emptyList();
        }
        return this.findThrowToBlocks((PsiClassType)throwType);
    }

    private List<PsiElement> findThrowToBlocks(PsiClassType throwType) {
        ArrayList<PsiElement> blocks = new ArrayList<PsiElement>();
        for (int i = this.myCatchParameters.size() - 1; i >= 0; --i) {
            ProgressIndicatorProvider.checkCanceled();
            PsiParameter parameter = (PsiParameter)this.myCatchParameters.get(i);
            PsiType catchType = parameter.getType();
            if (!catchType.isAssignableFrom(throwType) && !throwType.isAssignableFrom(catchType)) continue;
            blocks.add((PsiElement)this.myCatchBlocks.get(i));
        }
        if (blocks.isEmpty()) {
            blocks.add(null);
        }
        return blocks;
    }

    @Override
    public void visitAssertStatement(PsiAssertStatement statement) {
        PsiExpression description;
        this.startElement(statement);
        PsiExpression condition = statement.getAssertCondition();
        if (condition != null) {
            this.myStartStatementStack.pushStatement(statement, false);
            this.myEndStatementStack.pushStatement(statement, false);
            this.myEndJumpRoles.push(BranchingInstruction.Role.END);
            this.myStartJumpRoles.push(BranchingInstruction.Role.END);
            condition.accept(this);
            this.myStartJumpRoles.pop();
            this.myEndJumpRoles.pop();
            this.myStartStatementStack.popStatement();
            this.myEndStatementStack.popStatement();
        }
        if ((description = statement.getAssertDescription()) != null) {
            description.accept(this);
        }
        ConditionalThrowToInstruction instruction = new ConditionalThrowToInstruction(0, statement.getAssertCondition());
        this.myCurrentFlow.addInstruction(instruction);
        this.addElementOffsetLater(this.myCodeFragment, false);
        this.finishElement(statement);
    }

    @Override
    public void visitTryStatement(PsiTryStatement statement) {
        int i;
        PsiCodeBlock tryBlock;
        PsiResourceList resourceList;
        this.startElement(statement);
        PsiCodeBlock[] catchBlocks = statement.getCatchBlocks();
        PsiParameter[] catchBlockParameters = statement.getCatchBlockParameters();
        int catchNum = Math.min(catchBlocks.length, catchBlockParameters.length);
        this.myUnhandledExceptionCatchBlocks.push(null);
        block0: for (int i2 = catchNum - 1; i2 >= 0; --i2) {
            ProgressIndicatorProvider.checkCanceled();
            this.myCatchParameters.push(catchBlockParameters[i2]);
            this.myCatchBlocks.push(catchBlocks[i2]);
            PsiType type = catchBlockParameters[i2].getType();
            if (type instanceof PsiClassType && ExceptionUtil.isUncheckedExceptionOrSuperclass((PsiClassType)type)) {
                this.myUnhandledExceptionCatchBlocks.push(catchBlocks[i2]);
                continue;
            }
            if (!(type instanceof PsiDisjunctionType)) continue;
            PsiType lub = ((PsiDisjunctionType)type).getLeastUpperBound();
            if (lub instanceof PsiClassType && ExceptionUtil.isUncheckedExceptionOrSuperclass((PsiClassType)lub)) {
                this.myUnhandledExceptionCatchBlocks.push(catchBlocks[i2]);
                continue;
            }
            if (!(lub instanceof PsiIntersectionType)) continue;
            for (PsiType conjunct : ((PsiIntersectionType)lub).getConjuncts()) {
                if (!(conjunct instanceof PsiClassType) || !ExceptionUtil.isUncheckedExceptionOrSuperclass((PsiClassType)conjunct)) continue;
                this.myUnhandledExceptionCatchBlocks.push(catchBlocks[i2]);
                continue block0;
            }
        }
        PsiCodeBlock finallyBlock = statement.getFinallyBlock();
        if (finallyBlock != null) {
            this.myFinallyBlocks.push(finallyBlock);
        }
        if ((resourceList = statement.getResourceList()) != null) {
            this.generateCheckedExceptionJumps(resourceList);
            resourceList.accept(this);
        }
        if ((tryBlock = statement.getTryBlock()) != null) {
            this.generateCheckedExceptionJumps(tryBlock);
            tryBlock.accept(this);
        }
        while (this.myUnhandledExceptionCatchBlocks.pop() != null) {
        }
        this.myCurrentFlow.addInstruction(new GoToInstruction(finallyBlock == null ? 0 : -6));
        if (finallyBlock == null) {
            this.addElementOffsetLater(statement, false);
        } else {
            this.addElementOffsetLater(finallyBlock, true);
        }
        for (i = 0; i < catchNum; ++i) {
            this.myCatchParameters.pop();
            this.myCatchBlocks.pop();
        }
        for (i = catchNum - 1; i >= 0; --i) {
            ProgressIndicatorProvider.checkCanceled();
            if (this.myPolicy.isParameterAccepted(catchBlockParameters[i])) {
                this.generateWriteInstruction(catchBlockParameters[i]);
            }
            PsiCodeBlock catchBlock = catchBlocks[i];
            assert (catchBlock != null) : i + statement.getText();
            catchBlock.accept(this);
            this.myCurrentFlow.addInstruction(new GoToInstruction(finallyBlock == null ? 0 : -6));
            if (finallyBlock == null) {
                this.addElementOffsetLater(statement, false);
                continue;
            }
            this.addElementOffsetLater(finallyBlock, true);
        }
        if (finallyBlock != null) {
            this.myFinallyBlocks.pop();
        }
        if (finallyBlock != null) {
            this.myCurrentFlow.addInstruction(new CallInstruction(0, 0, this.myStack));
            this.addElementOffsetLater(finallyBlock, true);
            this.myCurrentFlow.addInstruction(new GoToInstruction(0));
            this.addElementOffsetLater(statement, false);
            this.myCurrentFlow.addInstruction(new CallInstruction(0, 0, this.myStack));
            this.addElementOffsetLater(finallyBlock, true);
            this.addReturnInstruction(statement);
            this.myCurrentFlow.addInstruction(new CallInstruction(0, 0, this.myStack));
            this.addElementOffsetLater(finallyBlock, true);
            GoToInstruction gotoUncheckedRethrow = new GoToInstruction(0);
            this.myCurrentFlow.addInstruction(gotoUncheckedRethrow);
            this.addElementOffsetLater(finallyBlock, false);
            finallyBlock.accept(this);
            int procStart = this.myCurrentFlow.getStartOffset(finallyBlock);
            int procEnd = this.myCurrentFlow.getEndOffset(finallyBlock);
            int offset = procStart - 6;
            List<Instruction> instructions = this.myCurrentFlow.getInstructions();
            CallInstruction callInstruction = (CallInstruction)instructions.get(offset);
            callInstruction.procBegin = procStart;
            callInstruction.procEnd = procEnd;
            callInstruction = (CallInstruction)instructions.get(offset += 2);
            callInstruction.procBegin = procStart;
            callInstruction.procEnd = procEnd;
            callInstruction = (CallInstruction)instructions.get(offset += 2);
            callInstruction.procBegin = procStart;
            callInstruction.procEnd = procEnd;
            this.myCurrentFlow.addInstruction(new ReturnInstruction(0, this.myStack, callInstruction));
            this.myCurrentFlow.addInstruction(new ReturnInstruction(procStart - 3, this.myStack, callInstruction));
            this.myCurrentFlow.addInstruction(new ReturnInstruction(procStart - 1, this.myStack, callInstruction));
            List<PsiElement> unhandledExceptionCatchBlocks = this.finallyBlockToUnhandledExceptions.remove(finallyBlock);
            for (int i3 = 0; unhandledExceptionCatchBlocks != null && i3 < unhandledExceptionCatchBlocks.size(); ++i3) {
                ProgressIndicatorProvider.checkCanceled();
                PsiElement catchBlock = unhandledExceptionCatchBlocks.get(i3);
                ReturnInstruction returnInstruction = new ReturnInstruction(0, this.myStack, callInstruction);
                returnInstruction.setRethrowFromFinally();
                this.myCurrentFlow.addInstruction(returnInstruction);
                if (catchBlock == null) {
                    returnInstruction.offset = procStart - 1;
                    continue;
                }
                --returnInstruction.offset;
                this.addElementOffsetLater(catchBlock, true);
            }
            gotoUncheckedRethrow.offset = this.myCurrentFlow.getSize();
            this.generateUncheckedExceptionJumps(statement, false);
            this.myCurrentFlow.addInstruction(new ThrowToInstruction(0));
            this.addElementOffsetLater(this.myCodeFragment, false);
        }
        this.finishElement(statement);
    }

    @Override
    public void visitResourceList(PsiResourceList resourceList) {
        this.startElement(resourceList);
        List<PsiResourceVariable> resources = resourceList.getResourceVariables();
        for (PsiResourceVariable resource : resources) {
            ProgressIndicatorProvider.checkCanceled();
            this.processVariable(resource);
        }
        this.finishElement(resourceList);
    }

    @Override
    public void visitWhileStatement(PsiWhileStatement statement) {
        Object loopCondition;
        this.startElement(statement);
        if (statement.getBody() == null) {
            this.myStartStatementStack.pushStatement(statement, false);
        } else {
            this.myStartStatementStack.pushStatement(statement.getBody(), true);
        }
        this.myEndStatementStack.pushStatement(statement, false);
        PsiExpression condition = statement.getCondition();
        if (condition != null) {
            condition.accept(this);
        }
        if ((loopCondition = this.myConstantEvaluationHelper.computeConstantExpression(statement.getCondition())) instanceof Boolean) {
            boolean value = (Boolean)loopCondition;
            if (value) {
                this.emitEmptyInstruction();
            } else {
                this.myCurrentFlow.addInstruction(new GoToInstruction(0));
                this.addElementOffsetLater(statement, false);
            }
        } else {
            ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(0, statement.getCondition());
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater(statement, false);
        }
        PsiStatement body = statement.getBody();
        if (body != null) {
            body.accept(this);
        }
        int offset = this.myCurrentFlow.getStartOffset(statement);
        GoToInstruction instruction = new GoToInstruction(offset);
        this.myCurrentFlow.addInstruction(instruction);
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement(statement);
    }

    @Override
    public void visitExpressionList(PsiExpressionList list2) {
        PsiExpression[] expressions;
        for (PsiExpression expression : expressions = list2.getExpressions()) {
            ProgressIndicatorProvider.checkCanceled();
            this.myStartStatementStack.pushStatement(expression, false);
            this.myEndStatementStack.pushStatement(expression, false);
            expression.accept(this);
            this.myStartStatementStack.popStatement();
            this.myEndStatementStack.popStatement();
        }
    }

    @Override
    public void visitArrayAccessExpression(PsiArrayAccessExpression expression) {
        this.startElement(expression);
        expression.getArrayExpression().accept(this);
        PsiExpression indexExpression = expression.getIndexExpression();
        if (indexExpression != null) {
            indexExpression.accept(this);
        }
        this.finishElement(expression);
    }

    @Override
    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
        PsiExpression[] initializers;
        this.startElement(expression);
        for (PsiExpression initializer : initializers = expression.getInitializers()) {
            ProgressIndicatorProvider.checkCanceled();
            initializer.accept(this);
        }
        this.finishElement(expression);
    }

    @Override
    public void visitAssignmentExpression(PsiAssignmentExpression expression) {
        PsiExpression lExpr;
        this.startElement(expression);
        this.myStartStatementStack.pushStatement(expression.getRExpression() == null ? expression : expression.getRExpression(), false);
        this.myEndStatementStack.pushStatement(expression.getRExpression() == null ? expression : expression.getRExpression(), false);
        PsiExpression rExpr = expression.getRExpression();
        if (rExpr != null) {
            rExpr.accept(this);
        }
        if ((lExpr = PsiUtil.skipParenthesizedExprDown(expression.getLExpression())) instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lExpr;
            if (!referenceExpression.isQualified() || referenceExpression.getQualifierExpression() instanceof PsiThisExpression) {
                PsiVariable variable = this.getUsedVariable(referenceExpression);
                if (variable != null) {
                    if (this.myAssignmentTargetsAreElements) {
                        this.startElement(lExpr);
                    }
                    if (expression.getOperationTokenType() != JavaTokenType.EQ) {
                        this.generateReadInstruction(variable);
                    }
                    this.generateWriteInstruction(variable);
                    if (this.myAssignmentTargetsAreElements) {
                        this.finishElement(lExpr);
                    }
                }
            } else {
                lExpr.accept(this);
            }
        } else {
            lExpr.accept(this);
        }
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement(expression);
    }

    @Override
    public void visitPolyadicExpression(PsiPolyadicExpression expression) {
        this.startElement(expression);
        IElementType signTokenType = expression.getOperationTokenType();
        boolean isAndAnd = signTokenType == JavaTokenType.ANDAND;
        boolean isOrOr = signTokenType == JavaTokenType.OROR;
        PsiExpression[] operands = expression.getOperands();
        Boolean lValue = isAndAnd;
        PsiExpression lOperand = null;
        Boolean rValue = null;
        for (int i = 0; i < operands.length; ++i) {
            PsiExpression rOperand = operands[i];
            if ((isAndAnd || isOrOr) && this.myEnabledShortCircuit) {
                boolean gotoIsAtStart;
                Object exprValue = this.myConstantEvaluationHelper.computeConstantExpression(rOperand);
                if (exprValue instanceof Boolean) {
                    this.myCurrentFlow.setConstantConditionOccurred(true);
                    rValue = this.shouldCalculateConstantExpression(expression) ? (Boolean)exprValue : null;
                }
                BranchingInstruction.Role role = isAndAnd ? this.myEndJumpRoles.peek() : this.myStartJumpRoles.peek();
                PsiElement gotoElement = isAndAnd ? this.myEndStatementStack.peekElement() : this.myStartStatementStack.peekElement();
                boolean bl = gotoIsAtStart = isAndAnd ? this.myEndStatementStack.peekAtStart() : this.myStartStatementStack.peekAtStart();
                Shortcut shortcut = lValue != null ? (lValue == isOrOr ? Shortcut.STOP_EXPRESSION : Shortcut.SKIP_CURRENT_OPERAND) : (rValue != null && rValue == isOrOr ? Shortcut.STOP_EXPRESSION : Shortcut.NO_SHORTCUT);
                switch (shortcut) {
                    case NO_SHORTCUT: {
                        assert (lOperand != null);
                        this.myCurrentFlow.addInstruction(new ConditionalGoToInstruction(0, role, lOperand));
                        this.addElementOffsetLater(gotoElement, gotoIsAtStart);
                        break;
                    }
                    case STOP_EXPRESSION: {
                        if (lOperand == null) break;
                        this.myCurrentFlow.addInstruction(new GoToInstruction(0, role));
                        this.addElementOffsetLater(gotoElement, gotoIsAtStart);
                        break;
                    }
                }
                if (shortcut == Shortcut.STOP_EXPRESSION) break;
            }
            this.generateLOperand(rOperand, i == operands.length - 1 ? null : operands[i + 1], signTokenType);
            lOperand = rOperand;
            lValue = rValue;
        }
        this.finishElement(expression);
    }

    private void generateLOperand(@NotNull PsiExpression lOperand, PsiExpression rOperand, IElementType signTokenType) {
        if (lOperand == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "generateLOperand"));
        }
        if (rOperand != null) {
            this.myStartJumpRoles.push(BranchingInstruction.Role.END);
            this.myEndJumpRoles.push(BranchingInstruction.Role.END);
            PsiExpression then = signTokenType == JavaTokenType.OROR ? this.myStartStatementStack.peekElement() : rOperand;
            boolean thenAtStart = signTokenType != JavaTokenType.OROR || this.myStartStatementStack.peekAtStart();
            this.myStartStatementStack.pushStatement(then, thenAtStart);
            PsiExpression elseS = signTokenType == JavaTokenType.ANDAND ? this.myEndStatementStack.peekElement() : rOperand;
            boolean elseAtStart = signTokenType != JavaTokenType.ANDAND || this.myEndStatementStack.peekAtStart();
            this.myEndStatementStack.pushStatement(elseS, elseAtStart);
        }
        lOperand.accept(this);
        if (rOperand != null) {
            this.myStartStatementStack.popStatement();
            this.myEndStatementStack.popStatement();
            this.myStartJumpRoles.pop();
            this.myEndJumpRoles.pop();
        }
    }

    private static boolean isInsideIfCondition(PsiExpression expression) {
        PsiElement element = expression;
        while (element instanceof PsiExpression) {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiIfStatement && element == ((PsiIfStatement)parent).getCondition()) {
                return true;
            }
            element = parent;
        }
        return false;
    }

    private boolean shouldCalculateConstantExpression(PsiExpression expression) {
        return this.myEvaluateConstantIfCondition || !ControlFlowAnalyzer.isInsideIfCondition(expression);
    }

    @Override
    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression) {
        this.visitChildren(expression);
    }

    private void visitChildren(PsiElement element) {
        PsiElement[] children;
        this.startElement(element);
        for (PsiElement child : children = element.getChildren()) {
            ProgressIndicatorProvider.checkCanceled();
            child.accept(this);
        }
        this.finishElement(element);
    }

    @Override
    public void visitConditionalExpression(PsiConditionalExpression expression) {
        this.startElement(expression);
        PsiExpression condition = expression.getCondition();
        PsiExpression thenExpression = expression.getThenExpression();
        PsiExpression elseExpression = expression.getElseExpression();
        this.generateConditionalStatementInstructions(expression, condition, thenExpression, elseExpression);
        this.finishElement(expression);
    }

    @Override
    public void visitInstanceOfExpression(PsiInstanceOfExpression expression) {
        this.startElement(expression);
        PsiExpression operand = expression.getOperand();
        operand.accept(this);
        this.finishElement(expression);
    }

    @Override
    public void visitLiteralExpression(PsiLiteralExpression expression) {
        this.startElement(expression);
        this.finishElement(expression);
    }

    @Override
    public void visitLambdaExpression(PsiLambdaExpression expression) {
        this.startElement(expression);
        PsiElement body = expression.getBody();
        if (body != null) {
            ArrayList<PsiVariable> array = new ArrayList<PsiVariable>();
            this.addUsedVariables(array, body);
            for (PsiVariable var : array) {
                ProgressIndicatorProvider.checkCanceled();
                this.generateReadInstruction(var);
            }
        }
        this.finishElement(expression);
    }

    @Override
    public void visitMethodCallExpression(PsiMethodCallExpression expression) {
        this.startElement(expression);
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        methodExpression.accept(this);
        PsiExpressionList argumentList = expression.getArgumentList();
        argumentList.accept(this);
        this.emitEmptyInstruction();
        this.generateCheckedExceptionJumps(expression);
        this.finishElement(expression);
    }

    @Override
    public void visitNewExpression(PsiNewExpression expression) {
        PsiElement[] children;
        this.startElement(expression);
        int pc = this.myCurrentFlow.getSize();
        for (PsiElement child : children = expression.getChildren()) {
            ProgressIndicatorProvider.checkCanceled();
            child.accept(this);
        }
        this.generateCheckedExceptionJumps(expression);
        if (pc == this.myCurrentFlow.getSize()) {
            this.emitEmptyInstruction();
        }
        this.finishElement(expression);
    }

    @Override
    public void visitParenthesizedExpression(PsiParenthesizedExpression expression) {
        this.visitChildren(expression);
    }

    @Override
    public void visitPostfixExpression(PsiPostfixExpression expression) {
        PsiVariable variable;
        this.startElement(expression);
        IElementType op = expression.getOperationTokenType();
        PsiExpression operand = PsiUtil.skipParenthesizedExprDown(expression.getOperand());
        operand.accept(this);
        if ((op == JavaTokenType.PLUSPLUS || op == JavaTokenType.MINUSMINUS) && operand instanceof PsiReferenceExpression && (variable = this.getUsedVariable((PsiReferenceExpression)operand)) != null) {
            this.generateWriteInstruction(variable);
        }
        this.finishElement(expression);
    }

    @Override
    public void visitPrefixExpression(PsiPrefixExpression expression) {
        this.startElement(expression);
        PsiExpression operand = PsiUtil.skipParenthesizedExprDown(expression.getOperand());
        if (operand != null) {
            PsiVariable variable;
            IElementType operationSign = expression.getOperationTokenType();
            if (operationSign == JavaTokenType.EXCL) {
                PsiElement topStartStatement = this.myStartStatementStack.peekElement();
                boolean topAtStart = this.myStartStatementStack.peekAtStart();
                this.myStartStatementStack.pushStatement(this.myEndStatementStack.peekElement(), this.myEndStatementStack.peekAtStart());
                this.myEndStatementStack.pushStatement(topStartStatement, topAtStart);
            }
            operand.accept(this);
            if (operationSign == JavaTokenType.EXCL) {
                this.myStartStatementStack.popStatement();
                this.myEndStatementStack.popStatement();
            }
            if (operand instanceof PsiReferenceExpression && (operationSign == JavaTokenType.PLUSPLUS || operationSign == JavaTokenType.MINUSMINUS) && (variable = this.getUsedVariable((PsiReferenceExpression)operand)) != null) {
                this.generateWriteInstruction(variable);
            }
        }
        this.finishElement(expression);
    }

    @Override
    public void visitReferenceExpression(PsiReferenceExpression expression) {
        PsiVariable variable;
        this.startElement(expression);
        PsiExpression qualifier = expression.getQualifierExpression();
        if (qualifier != null) {
            qualifier.accept(this);
        }
        if ((variable = this.getUsedVariable(expression)) != null) {
            this.generateReadInstruction(variable);
        }
        this.finishElement(expression);
    }

    @Override
    public void visitSuperExpression(PsiSuperExpression expression) {
        this.startElement(expression);
        this.finishElement(expression);
    }

    @Override
    public void visitThisExpression(PsiThisExpression expression) {
        this.startElement(expression);
        this.finishElement(expression);
    }

    @Override
    public void visitTypeCastExpression(PsiTypeCastExpression expression) {
        this.startElement(expression);
        PsiExpression operand = expression.getOperand();
        if (operand != null) {
            operand.accept(this);
        }
        this.finishElement(expression);
    }

    @Override
    public void visitClass(PsiClass aClass) {
        PsiExpressionList arguments;
        this.startElement(aClass);
        if (aClass instanceof PsiAnonymousClass && (arguments = PsiTreeUtil.getChildOfType(aClass, PsiExpressionList.class)) != null) {
            arguments.accept(this);
        }
        ArrayList<PsiVariable> array = new ArrayList<PsiVariable>();
        this.addUsedVariables(array, aClass);
        for (PsiVariable var : array) {
            ProgressIndicatorProvider.checkCanceled();
            this.generateReadInstruction(var);
        }
        this.finishElement(aClass);
    }

    private void addUsedVariables(List<PsiVariable> array, PsiElement scope) {
        PsiElement[] children;
        PsiVariable variable;
        if (scope instanceof PsiReferenceExpression && (variable = this.getUsedVariable((PsiReferenceExpression)scope)) != null && !array.contains(variable)) {
            array.add(variable);
        }
        for (PsiElement child : children = scope.getChildren()) {
            ProgressIndicatorProvider.checkCanceled();
            this.addUsedVariables(array, child);
        }
    }

    private void generateReadInstruction(PsiVariable variable) {
        ReadVariableInstruction instruction = new ReadVariableInstruction(variable);
        this.myCurrentFlow.addInstruction(instruction);
    }

    private void generateWriteInstruction(PsiVariable variable) {
        WriteVariableInstruction instruction = new WriteVariableInstruction(variable);
        this.myCurrentFlow.addInstruction(instruction);
    }

    @Nullable
    private PsiVariable getUsedVariable(PsiReferenceExpression refExpr) {
        if (refExpr.getParent() instanceof PsiMethodCallExpression) {
            return null;
        }
        return this.myPolicy.getUsedVariable(refExpr);
    }

    private static enum Shortcut {
        NO_SHORTCUT,
        SKIP_CURRENT_OPERAND,
        STOP_EXPRESSION;

    }

    private static class StatementStack {
        private final Stack<PsiElement> myStatements = new Stack();
        private final TIntArrayList myAtStart = new TIntArrayList();

        private StatementStack() {
        }

        private void popStatement() {
            this.myAtStart.remove(this.myAtStart.size() - 1);
            this.myStatements.pop();
        }

        private PsiElement peekElement() {
            return this.myStatements.peek();
        }

        private boolean peekAtStart() {
            return this.myAtStart.get(this.myAtStart.size() - 1) == 1;
        }

        private void pushStatement(PsiElement statement, boolean atStart) {
            this.myStatements.push(statement);
            this.myAtStart.add(atStart ? 1 : 0);
        }
    }
}

