/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.common.messages;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.jar.CoreJarVirtualFile;
import com.intellij.openapi.vfs.local.CoreLocalVirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.jet.lang.diagnostics.DiagnosticUtils;

public class MessageUtil {
    private MessageUtil() {
    }

    @NotNull
    public static CompilerMessageLocation psiElementToMessageLocation(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/cli/common/messages/MessageUtil", "psiElementToMessageLocation"));
        }
        PsiFile file = element.getContainingFile();
        DiagnosticUtils.LineAndColumn lineAndColumn = DiagnosticUtils.getLineAndColumnInPsiFile(file, element.getTextRange());
        CompilerMessageLocation compilerMessageLocation = MessageUtil.psiFileToMessageLocation(file, "<no path>", lineAndColumn.getLine(), lineAndColumn.getColumn());
        if (compilerMessageLocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/messages/MessageUtil", "psiElementToMessageLocation"));
        }
        return compilerMessageLocation;
    }

    @NotNull
    public static CompilerMessageLocation psiFileToMessageLocation(@NotNull PsiFile file, @Nullable String defaultValue, int line, int column) {
        String path;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/cli/common/messages/MessageUtil", "psiFileToMessageLocation"));
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            path = defaultValue;
        } else {
            path = virtualFile.getPath();
            if (virtualFile instanceof CoreLocalVirtualFile || virtualFile instanceof CoreJarVirtualFile) {
                path = FileUtil.toSystemDependentName(path);
            }
        }
        CompilerMessageLocation compilerMessageLocation = CompilerMessageLocation.create(path, line, column);
        if (compilerMessageLocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/messages/MessageUtil", "psiFileToMessageLocation"));
        }
        return compilerMessageLocation;
    }
}

